/*
 * Decompiled with CFR 0.152.
 */
package com.ubintis.agt5.module.pt;

import com.ubintis.agt5.common.util.CheckSumUtil;
import com.ubintis.agt5.common.util.StrUtil;
import com.ubintis.agt5.framework.bean.AgentBean;
import com.ubintis.agt5.framework.bean.IntgrtyBean;
import com.ubintis.agt5.framework.config.AgentConfig;
import com.ubintis.agt5.framework.config.IntgrtyConfig;
import com.ubintis.agt5.framework.log.PniLogger;
import com.ubintis.agt5.module.cs.CipherBlock;
import com.ubintis.agt5.module.cs.Digest;
import com.ubintis.agt5.module.cs.key.KeyStorage;
import com.ubintis.agt5.module.cs.key.type.SecretKey;
import com.ubintis.crypto.jni.PniccJNI;
import java.io.File;
import java.util.HashMap;

public class SelfTestAgent {
    private static final PniLogger LOGGER = PniLogger.getLogger();

    public HashMap<String, Boolean> execute(String ser_r, String ser_e, String ser_s) {
        boolean moduleTestFlag = false;
        boolean cryptoTestFlag = false;
        boolean intgrtyTestFlag = false;
        try {
            moduleTestFlag = this.moduleTest(ser_r, ser_e, ser_s);
            cryptoTestFlag = this.cryptoTest();
            intgrtyTestFlag = this.intgrtyTest();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        HashMap<String, Boolean> dataMap = new HashMap<String, Boolean>();
        dataMap.put("moduleTest", moduleTestFlag);
        dataMap.put("cryptoTest", cryptoTestFlag);
        dataMap.put("intgrtyTest", intgrtyTestFlag);
        return dataMap;
    }

    public HashMap<String, Boolean> execute() {
        boolean cryptoTestFlag = false;
        boolean intgrtyTestFlag = false;
        try {
            cryptoTestFlag = this.cryptoTest();
            intgrtyTestFlag = this.intgrtyTest();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        HashMap<String, Boolean> dataMap = new HashMap<String, Boolean>();
        dataMap.put("moduleTest", true);
        dataMap.put("cryptoTest", cryptoTestFlag);
        dataMap.put("intgrtyTest", intgrtyTestFlag);
        return dataMap;
    }

    private boolean moduleTest(String ser_r, String ser_e, String ser_s) {
        Digest digest;
        String encoding;
        String decryptData;
        KeyStorage keyStorage;
        SecretKey calculateKey;
        CipherBlock cipherBlock = new CipherBlock();
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        return agentBean != null && (calculateKey = (SecretKey)(keyStorage = KeyStorage.getInstance()).getKey("com.ubintis.sso.agt.cs.key.CalculateKey")) != null && (decryptData = cipherBlock.decrypt(ser_e, encoding = StrUtil.NVL(agentBean.getEncoding(), "UTF-8"), calculateKey)) != null && ser_r.equals(decryptData) && (digest = new Digest()).verifyHmac(decryptData, ser_s, calculateKey);
    }

    private boolean cryptoTest() {
        PniccJNI pniccJni = new PniccJNI();
        int nRet = pniccJni.SELFTEST_DoPowerUpSelfTest();
        return nRet == 1;
    }

    private boolean intgrtyTest() {
        String agent_root_path = "";
        String agent_jar_name = "";
        AgentBean agentBean = AgentConfig.getInstance().getAgentBean();
        if (agentBean != null) {
            agent_root_path = agentBean.getAgent_root_path();
            agent_jar_name = "passni-sso-agent-" + agentBean.getAgent_version() + ".jar";
        }
        if (!"".equals(agent_root_path)) {
            String pni_config_path = String.valueOf(agent_root_path) + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "spconfig" + File.separator + "pni5-config.xml";
            String pni_jar_path = String.valueOf(agent_root_path) + File.separator + "WEB-INF" + File.separator + "lib" + File.separator + agent_jar_name;
            IntgrtyBean intgrtyBean = IntgrtyConfig.getInstance().getIntgrtyBean();
            if (intgrtyBean != null) {
                String pni_config_checksum = intgrtyBean.getPni_config();
                String pni_jar_checksum = intgrtyBean.getPni_jar();
                boolean pniConfigFlag = this.verifyChecksum(pni_config_path, pni_config_checksum);
                boolean pniJarFlag = this.verifyChecksum(pni_jar_path, pni_jar_checksum);
                if (pniConfigFlag && pniJarFlag) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean verifyChecksum(String filePath, String checksum) {
        try {
            String newChecksum = CheckSumUtil.getFileCheckSum(filePath);
            if (newChecksum != null && !"".equals(newChecksum) && newChecksum.equalsIgnoreCase(checksum)) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return false;
    }
}

