/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.JIS0201CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0208CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0212CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0213ByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0213CharToByteConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class EUCJPCharToByteConverter
extends JIS0208CharToByteConverter {
    private JIS0201CharToByteConverter JIS0201cb = new JIS0201CharToByteConverter();
    private JIS0212CharToByteConverter JIS0212cb = new JIS0212CharToByteConverter();
    short[] JIS0208Index1 = super.getIndex1();
    String[] JIS0208Index2 = super.getIndex2();
    final int MAX_BYTE_SIZE = 3;
    static final int[][] EUC_JISX0213__COMP_TABLE_DATA = new int[][]{{44004, 44005}, {44000, 44006}, {43484, 43972}, {43960, 43976}, {43959, 43978}, {43952, 43980}, {43971, 43982}, {43960, 43977}, {43959, 43979}, {43952, 43981}, {43971, 43983}, {42155, 42231}, {42157, 42232}, {42159, 42233}, {42161, 42234}, {42163, 42235}, {42411, 42487}, {42413, 42488}, {42415, 42489}, {42417, 42490}, {42419, 42491}, {42427, 42492}, {42436, 42493}, {42440, 42494}, {42741, 42744}};
    static final int[] EUC_JISX0213__COMBINED_UNICODE_TABLE = new int[]{42231, 42232, 42233, 42234, 42235, 42487, 42488, 42489, 42490, 42491, 42492, 42493, 42494, 42744, 43972, 43976, 43977, 43978, 43979, 43980, 43981, 43982, 43983, 44005, 44006};
    static final int[] EUC_JISX0213__CJK_EXT_B_TABLE = new int[]{44706, 44994, 45004, 45024, 45051, 53204, 53219, 53230, 62906, 62962, 63145, 63154, 63200, 63468, 63742, 63913, 63943, 63956, 63982, 64221, 64435, 64457, 64492, 64713, 64721, 65254, 9413025, 9413035, 9413038, 9413046, 9413062, 9413104, 9413111, 9413113, 9413538, 9413541, 9413543, 9413553, 9413554, 9413560, 9413567, 9413569, 9413578, 9413586, 9413587, 9413593, 9413596, 9413623, 9413802, 9413809, 9413810, 9413818, 9413821, 9413849, 9413852, 9413854, 9413859, 9413866, 9413867, 9413874, 9413876, 9413877, 9414053, 9414066, 9414078, 9414084, 9414087, 9414101, 9414102, 9414142, 9414832, 9414839, 9414840, 9414842, 9414843, 9414847, 9414848, 9414853, 9414856, 9414858, 9414859, 9414875, 9414886, 9414892, 9415842, 9415851, 9415856, 9415888, 9415909, 9415917, 9415922, 9416100, 9416105, 9416106, 9416114, 9416116, 9416117, 9416121, 9416150, 9416189, 9416355, 9416356, 9416378, 9416380, 9416381, 9416386, 9416387, 9416388, 9416391, 9416393, 9416405, 9416406, 9416407, 9416411, 9416439, 9416440, 0x8FAFAA, 9416639, 9416640, 9416642, 9416643, 9416654, 9416665, 9416673, 9416681, 9416682, 9416688, 9416693, 9432739, 9432756, 9432777, 9432796, 9432798, 9432799, 9432800, 9433010, 9433031, 9433037, 9433057, 9433060, 9433250, 9433267, 9433273, 9433299, 9433339, 9433518, 9433520, 9433525, 9433540, 9433565, 9433569, 9433574, 9433577, 9433589, 9433591, 9433594, 9433761, 9433763, 9433764, 9433768, 9433772, 9433789, 9433800, 9433819, 9433845, 9433846, 9434034, 9434045, 9434046, 9434048, 9434066, 9434077, 9434078, 0x8FF3F3, 9434100, 9434101, 9434103, 9434107, 9434109, 9434274, 9434276, 9434279, 9434286, 9434287, 9434292, 9434293, 9434301, 9434306, 9434319, 9434345, 9434347, 9434354, 9434357, 9434361, 9434549, 9434554, 9434566, 9434582, 9434584, 9434586, 9434589, 9434591, 9434595, 9434602, 9434608, 9434611, 9434820, 9434830, 9434845, 9434869, 9434878, 9435041, 9435042, 9435059, 9435062, 9435108, 9435109, 9435115, 9435118, 9435123, 9435305, 0x8FF8AA, 9435308, 9435316, 9435324, 9435326, 9435330, 9435350, 9435363, 0x8FF8F7, 0x8FF8F9, 0x8FF8FA, 9435557, 9435567, 9435570, 9435577, 9435586, 9435592, 9435609, 9435614, 9435622, 9435627, 9435642, 9435646, 9435809, 9435820, 0x8FFAAF, 9435855, 9435856, 9435863, 9435877, 9435878, 9435889, 9435890, 9435902, 9436065, 9436076, 9436077, 9436086, 9436087, 9436093, 9436094, 9436110, 9436111, 9436119, 9436122, 9436124, 9436125, 9436129, 9436133, 9436135, 9436137, 9436145, 9436322, 9436323, 9436344, 9436354, 0x8FFCCC, 9436374, 9436377, 9436381, 9436406, 9436588, 9436619, 9436620, 9436633, 9436635, 0x8FFDDD, 9436647, 9436653, 9436656, 9436837, 9436841, 9436843, 9436850, 9436853, 9436883, 9436888, 9436890, 0x8FFEEE, 9436912, 9436914, 9436918};

    @Override
    public boolean canConvert(char c) throws SQLException {
        byte[] byArray = new byte[3];
        return this.convSingleByte(c, byArray) != 0 || this.convDoubleByte(c) != 0;
    }

    @Override
    protected int convDoubleByte(char c) throws SQLException {
        char c2 = c;
        if (c2 == '\u301c' || c2 == '\uff5e') {
            int n = 161;
            int n2 = 193;
            return n << 8 | n2;
        }
        if (c2 == '\u2015') {
            c2 = '\u2014';
        }
        try {
            int n = this.JIS0208Index1[(c2 & 0xFF00) >> 8] << 8;
            int n3 = this.JIS0208Index2[n >> 12].charAt((n & 0xFFF) + (c2 & 0xFF));
            if (n3 != 0) {
                return n3 + 32896;
            }
            n3 = this.JIS0212cb.convDoubleByte(c2);
            if (n3 == 0) {
                return n3;
            }
            return n3 + 0x8F8080;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw TbError.newSQLException(-590743, arrayIndexOutOfBoundsException.getMessage());
        }
    }

    @Override
    public int getMaxBytesPerChar() {
        return 3;
    }

    @Override
    protected int convSingleByte(char c, byte[] byArray) {
        if (c == '\u0000') {
            byArray[0] = 0;
            return 1;
        }
        byte by = this.JIS0201cb.getNative(c);
        if (by == 0) {
            return 0;
        }
        if (by > 0 && by < 128) {
            byArray[0] = by;
            return 1;
        }
        byArray[0] = -114;
        byArray[1] = by;
        return 2;
    }

    @Override
    public int convCharArr(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[3];
        n6 = n3;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int[] nArray = JIS0213CharToByteConverter.JISX0213__CJK_EXT_B_DATA;
        for (n5 = n; n5 < n2; ++n5) {
            int n10;
            int n11;
            char c = cArray[n5];
            int n12 = this.convSingleByte(c, byArray2);
            n8 = n7;
            n7 = this.parse(c, cArray, n5, n2);
            if ((n7 & 0xFFFF0000) >> 16 == 2) {
                for (n11 = 0; n11 < nArray.length; ++n11) {
                    if (nArray[n11] != n7) continue;
                    n10 = EUC_JISX0213__CJK_EXT_B_TABLE[n11];
                    if (n10 > 65535) {
                        byArray2[0] = (byte)((n10 & 0xFF0000) >> 16);
                        byArray2[1] = (byte)((n10 & 0xFF00) >> 8);
                        byArray2[2] = (byte)(n10 & 0xFF);
                        n12 = 3;
                    } else {
                        byArray2[0] = (byte)((n10 & 0xFF00) >> 8);
                        byArray2[1] = (byte)(n10 & 0xFF);
                        n12 = 2;
                    }
                    ++n5;
                    break;
                }
            }
            if (n12 == 0) {
                n11 = this.convDoubleByte(c);
                if (n11 != 0) {
                    if (n11 == 9415105 && n2 - n5 > 1 && cArray[n5 + 1] == '\u0300') {
                        byArray2[0] = -85;
                        byArray2[1] = -60;
                        n12 = 2;
                        ++n5;
                    } else if ((n11 & 0xFF0000) == 0) {
                        byArray2[0] = (byte)((n11 & 0xFF00) >> 8);
                        byArray2[1] = (byte)(n11 & 0xFF);
                        n12 = 2;
                    } else {
                        byArray2[0] = -113;
                        byArray2[1] = (byte)((n11 & 0xFF00) >> 8);
                        byArray2[2] = (byte)(n11 & 0xFF);
                        n12 = 3;
                    }
                } else {
                    int n13;
                    if (n8 > 0) {
                        n10 = 0;
                        n13 = n8 << 16 | n7;
                        int[][] nArray2 = JIS0213ByteToCharConverter.JISX0213_TO_UCS__COMBINING;
                        for (int i = 0; i < nArray2.length; ++i) {
                            if (n13 != (nArray2[i][0] << 16 | nArray2[i][1])) continue;
                            n10 = EUC_JISX0213__COMBINED_UNICODE_TABLE[i];
                            break;
                        }
                        if (n10 > 0) {
                            byArray[n6 - n9] = (byte)(n10 >> 8 & 0xFF | 0x80);
                            byArray[n6 - n9 + 1] = (byte)(n10 & 0xFF | 0x80);
                            n6 -= n9 - 2;
                            continue;
                        }
                    }
                    if ((n11 = JIS0213CharToByteConverter.convFromUCS4(n7)) != 0) {
                        if (n11 == 741) {
                            n10 = 1;
                            n13 = 0;
                        } else if (n11 == 745) {
                            n10 = 1;
                            n13 = 1;
                        } else if (n11 == 768) {
                            n10 = 2;
                            n13 = 5;
                        } else if (n11 == 769) {
                            n10 = 7;
                            n13 = 4;
                        } else if (n11 == 12442) {
                            n10 = 11;
                            n13 = 14;
                        } else {
                            n10 = 0;
                            n13 = -1;
                        }
                        int n14 = n11 | 0x8080;
                        while (n13 > 0 && EUC_JISX0213__COMP_TABLE_DATA[n10][0] != n14) {
                            ++n10;
                            --n13;
                        }
                        if (n13 > 0) {
                            n14 = EUC_JISX0213__COMP_TABLE_DATA[n10][1];
                            byArray2[0] = (byte)(n14 >> 8 & 0xFF);
                            byArray2[1] = (byte)(n14 & 0xFF);
                            n12 += 2;
                        } else if ((n11 & 0x8000) != 0) {
                            byArray2[0] = -113;
                            byArray2[1] = (byte)(n11 >> 8 & 0xFF | 0x80);
                            byArray2[2] = (byte)(n11 & 0xFF | 0x80);
                            n12 = 3;
                        } else {
                            byArray2[0] = (byte)(n11 >> 8 & 0xFF | 0x80);
                            byArray2[1] = (byte)(n11 & 0xFF | 0x80);
                            n12 = 2;
                        }
                    } else {
                        throw TbError.newSQLException(-590714, "unknown character");
                    }
                }
            }
            n9 = n12;
            if (n4 - n6 < n12) {
                throw TbError.newSQLException(-590714, "Conversion buffer overflow");
            }
            for (n11 = 0; n11 < n12; ++n11) {
                byArray[n6++] = byArray2[n11];
            }
        }
        return n6 - n3;
    }
}

