/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.util;

public class TbSQLTypeScanner {
    private static final char NULL = '\u0000';
    private static final int STATE_START = 0;
    private static final int STATE_1 = 1;
    private static final int STATE_2 = 2;
    private static final int STATE_3 = 3;
    private static final int STATE_4 = 4;
    private static final int STATE_5 = 5;
    private static final int STATE_6 = 6;
    private static final int STATE_DONE = 10;
    public static final int STMT_UNKNOWN = 0;
    public static final int STMT_QUERY = 16;
    public static final int STMT_DML = 32;
    public static final int STMT_DML_DELETE = 33;
    public static final int STMT_DML_UPDATE = 34;
    public static final int STMT_DML_INSERT = 36;
    public static final int STMT_DML_MERGE = 40;
    public static final int STMT_PSM = 64;
    public static final int STMT_PSM_BEGIN = 65;
    public static final int STMT_PSM_CALL = 66;
    public static final int STMT_PSM_DECLARE = 68;
    private int state;
    private int index;
    private int textLen;
    private String text;

    public int getCurrentIndex() {
        return this.index;
    }

    private char getNextChar() {
        if (this.index < this.textLen) {
            return this.text.charAt(this.index++);
        }
        return '\u0000';
    }

    public synchronized int getSQLType(String string) {
        this.index = 0;
        this.textLen = string.length();
        this.text = string;
        String string2 = this.getToken();
        if (string2.equals("(")) {
            string2 = this.getToken();
        }
        if (string2.equals("SELECT")) {
            return 16;
        }
        if (string2.equals("DELETE")) {
            return 33;
        }
        if (string2.equals("INSERT")) {
            return 36;
        }
        if (string2.equals("UPDATE")) {
            return 34;
        }
        if (string2.equals("MERGE")) {
            return 40;
        }
        if (string2.equals("BEGIN")) {
            return 65;
        }
        if (string2.equals("DECLARE")) {
            return 68;
        }
        if (string2.equals("CALL")) {
            return 66;
        }
        return 0;
    }

    private String getToken() {
        this.state = 0;
        StringBuffer stringBuffer = new StringBuffer(32);
        while (this.state != 10) {
            char c = this.getNextChar();
            boolean bl = true;
            block0 : switch (this.state) {
                case 0: {
                    switch (c) {
                        case '/': {
                            this.state = 1;
                            break block0;
                        }
                        case '-': {
                            this.state = 4;
                            break block0;
                        }
                        case '\'': {
                            this.state = 6;
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            if (stringBuffer.length() > 0) {
                                this.state = 10;
                                bl = false;
                                this.ungetNextChar();
                                break block0;
                            }
                            this.state = 10;
                            bl = true;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (stringBuffer.length() > 0) {
                                this.state = 10;
                            }
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '*': {
                            this.state = 2;
                            bl = false;
                            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            bl = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '*': {
                            this.state = 3;
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    switch (c) {
                        case '*': {
                            bl = false;
                            break block0;
                        }
                        case '/': {
                            this.state = 0;
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 2;
                    bl = false;
                    break;
                }
                case 4: {
                    switch (c) {
                        case '-': {
                            this.state = 5;
                            bl = false;
                            stringBuffer.delete(stringBuffer.length() - 1, stringBuffer.length());
                            break block0;
                        }
                        case '(': 
                        case ')': {
                            this.state = 10;
                            bl = false;
                            this.ungetNextChar();
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    switch (c) {
                        case '\n': 
                        case '\r': {
                            this.state = 0;
                            this.ungetNextChar();
                            bl = false;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                    bl = false;
                    break;
                }
                case 6: {
                    switch (c) {
                        case '\'': {
                            this.state = 0;
                            break block0;
                        }
                        case '\u0000': {
                            this.state = 10;
                            bl = false;
                            break block0;
                        }
                    }
                }
            }
            if (!bl) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.substring(0, stringBuffer.length()).toUpperCase();
    }

    private void ungetNextChar() {
        --this.index;
    }

    public static boolean isDMLStmt(int n) {
        return (n & 0x20) > 0;
    }

    public static boolean isPSMStmt(int n) {
        return (n & 0x40) > 0;
    }

    public static boolean isQueryStmt(int n) {
        return (n & 0x10) > 0;
    }
}

