/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.CharsetEncoder;
import com.tmax.tibero.jdbc.data.charset.UTF8CharToByteConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class UTF8Encoder
implements CharsetEncoder {
    private UTF8CharToByteConverter conv = new UTF8CharToByteConverter();
    private int maxBytesPerChar = this.conv.getMaxBytesPerChar();

    public int charsToBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.conv.convCharArr(cArray, n, n + n2, byArray, n3, n3 + n4);
    }

    public int charsToFixedBytes(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        throw TbError.newSQLException(-590714);
    }

    public int getEndingBytePos(byte[] byArray, int n) {
        if (byArray[n] >= 0) {
            return n;
        }
        int n2 = this.getLeadingBytePos(byArray, n);
        if (byArray[n2] >= -32) {
            return n2 + 2;
        }
        return n2 + 1;
    }

    public int getLeadingBytePos(byte[] byArray, int n) {
        int n2 = n;
        while ((byArray[n2] & 0x80) != 0 && (byArray[n2] & 0x40) == 0) {
            --n2;
        }
        return n2;
    }

    public int getMaxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public boolean isEndingByte(byte[] byArray, int n) {
        if (byArray[n] >= 0) {
            return true;
        }
        int n2 = this.getLeadingBytePos(byArray, n);
        if (byArray[n2] >= -32) {
            return n == n2 + 2;
        }
        return n == n2 + 1;
    }

    public boolean isLeadingByte(byte[] byArray, int n) {
        byte by = byArray[n];
        return (by & 0x80) == 0 || (by & 0x40) != 0;
    }

    public byte[] stringToBytes(String string) throws SQLException {
        byte[] byArray = new byte[string.length() * this.getMaxBytesPerChar()];
        int n = this.conv.convString(string, 0, string.length(), byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    public int stringToBytes(byte[] byArray, int n, String string) throws SQLException {
        return this.conv.convString(string, 0, string.length(), byArray, n, byArray.length);
    }
}

