/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbSQLInput;
import com.tmax.tibero.jdbc.TbSQLOutput;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import java.util.StringTokenizer;

public class TbStructDescriptor {
    private String owner;
    private String packageName;
    private String typeName;
    private String sqlTypeName;
    private TbConnection conn;
    private int objectId;
    private int memberNo;
    private int numOfFields;
    private int kind;
    private int[] attributeTypes;
    private String[] attributeTypeName;
    private TbStructDescriptor[] subDescriptor;
    private boolean initialized;

    public TbStructDescriptor(String string, String string2, String string3, Connection connection) throws SQLException {
        this.owner = string.toUpperCase();
        this.conn = (TbConnection)connection;
        this.typeName = string3.toUpperCase();
        this.packageName = string2.toUpperCase();
        this.sqlTypeName = TbStructDescriptor.makeSqlTypeName(string, string2, string3);
        if (!this.initialized) {
            this.initPsmUdtInfo(this.owner, this.packageName, this.typeName);
        }
    }

    public TbStructDescriptor(String string, String string2, Connection connection) throws SQLException {
        this.conn = (TbConnection)connection;
        this.typeName = string2.toUpperCase();
        this.owner = string.toUpperCase();
        this.sqlTypeName = TbStructDescriptor.makeSqlTypeName(string, null, string2);
        if (!this.initialized) {
            this.initUdtInfo(this.owner, this.typeName);
        }
    }

    public TbStructDescriptor(String string, Connection connection) throws SQLException {
        if (string == null) {
            throw TbError.newSQLException(-590713, string);
        }
        this.conn = (TbConnection)connection;
        this.sqlTypeName = string.toUpperCase();
        int n = this.parseSQLTypeName(string);
        if (!this.initialized) {
            if (n == 3) {
                this.initPsmUdtInfo(this.owner, this.packageName, this.typeName);
            } else {
                this.initUdtInfo(this.owner, this.typeName);
            }
        }
    }

    protected TbStructDescriptor(int n, int n2, int[] nArray) {
        this.kind = n;
        this.numOfFields = n2;
        this.attributeTypes = nArray;
    }

    public static TbStructDescriptor createDescriptor(String string, String string2, String string3, Connection connection) throws SQLException {
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0 || connection == null) {
            throw new IllegalArgumentException();
        }
        String string4 = TbStructDescriptor.makeSqlTypeName(string, string2, string3).toUpperCase();
        TbStructDescriptor tbStructDescriptor = (TbStructDescriptor)((TbConnection)connection).getDescriptor(string4);
        if (tbStructDescriptor == null) {
            tbStructDescriptor = new TbStructDescriptor(string4, connection);
            ((TbConnection)connection).putDescriptor(string4, tbStructDescriptor);
        }
        return tbStructDescriptor;
    }

    public static TbStructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            throw new IllegalArgumentException();
        }
        String string2 = string.toUpperCase();
        TbStructDescriptor tbStructDescriptor = (TbStructDescriptor)((TbConnection)connection).getDescriptor(string2);
        if (tbStructDescriptor == null) {
            tbStructDescriptor = new TbStructDescriptor(string2, connection);
            ((TbConnection)connection).putDescriptor(string2, tbStructDescriptor);
        }
        return tbStructDescriptor;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUdtInfo(String string, String string2) throws SQLException {
        String string3 = "select typecode from user_types where type_name = ?";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.conn.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string4 = resultSet.getString(1);
                if (!string4.equals("OBJECT")) {
                    throw TbError.newSQLException(-590704, string4);
                }
            } else {
                throw new SQLException("Type does not exist : " + string2);
            }
            this.kind = 32;
            string3 = "select count(*)from user_type_attrs where type_name = ?";
            preparedStatement = this.conn.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                this.numOfFields = resultSet.getInt(1);
            }
            this.attributeTypes = new int[this.numOfFields];
            this.attributeTypeName = new String[this.numOfFields];
            this.subDescriptor = new TbStructDescriptor[this.numOfFields];
            String string5 = "select attr_name, attr_type_name from user_type_attrs where type_name = ? order by attr_no";
            preparedStatement = this.conn.prepareStatement(string5);
            preparedStatement.setString(1, string2);
            resultSet = preparedStatement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                this.attributeTypes[n] = DataType.toIntDataType(resultSet.getString(2));
                this.attributeTypeName[n] = resultSet.getString(2);
                if (this.attributeTypes[n] == 32) {
                    String string6 = this.makeSQLTypeName(string, this.packageName, this.attributeTypeName[n]);
                    this.subDescriptor[n] = TbStructDescriptor.createDescriptor(string6, this.conn);
                }
                ++n;
            }
            if (n == 0) {
                throw new SQLException("Attribute Type Info does not exist : " + string2);
            }
            this.objectId = this.getObjectId(string2);
            this.memberNo = -1;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPsmUdtInfo(String string, String string2, String string3) throws SQLException {
        block16: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_UDT_PSMDEF);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    this.kind = resultSet.getInt(1);
                    if (this.kind != 28) {
                        throw TbError.newSQLException(-590703, "PSM_MEMBER_KIND=" + resultSet.getInt(2));
                    }
                    this.numOfFields = resultSet.getInt(3);
                    this.objectId = resultSet.getInt(9);
                    this.memberNo = resultSet.getInt(8);
                    this.attributeTypes = new int[this.numOfFields];
                    int n = 0;
                    do {
                        this.attributeTypes[n] = resultSet.getInt(5);
                        ++n;
                    } while (resultSet.next());
                    break block16;
                }
                throw new SQLException("Type does not exist : " + string + ", " + string2 + ", " + string3);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    private int getObjectId(String string) throws SQLException {
        String string2 = "select object_id from all_objects where owner = ? and object_name = ? and (object_type = 'TYPE')";
        PreparedStatement preparedStatement = this.conn.prepareStatement(string2);
        preparedStatement.setString(1, this.owner);
        preparedStatement.setString(2, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            throw new SQLException(string + "'s object id does not exist : ");
        }
        int n = resultSet.getInt(1);
        return n;
    }

    public SQLInput toSQLInput(TbStruct tbStruct, Map map) throws SQLException {
        return new TbSQLInput(tbStruct, this, map);
    }

    public SQLOutput toSQLOutput() {
        return new TbSQLOutput(this, this.conn);
    }

    public int getNumOfFields() {
        return this.numOfFields;
    }

    public int getKind() {
        return this.kind;
    }

    public int[] getAttributeTypes() {
        return this.attributeTypes;
    }

    public String[] getAttributeTypeName() {
        return this.attributeTypeName;
    }

    public TbStructDescriptor[] getSubStructDescriptor() {
        return this.subDescriptor;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getMemberNo() {
        return this.memberNo;
    }

    public Class getClass(Map map) throws SQLException {
        String string = this.getSQLTypeName();
        Class clazz = (Class)map.get(string);
        if (clazz == null) {
            throw new SQLException();
        }
        return clazz;
    }

    public String getSQLTypeName() {
        return this.sqlTypeName;
    }

    private String makeSQLTypeName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(".");
        if (string2 != null) {
            stringBuffer.append(string2).append(".");
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private static String makeSqlTypeName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(".");
        if (string2 != null) {
            stringBuffer.append(string2).append(".");
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private int parseSQLTypeName(String string) throws SQLException {
        String string2 = ".";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n == 2) {
            this.owner = stringTokenizer.nextToken().toUpperCase();
            this.typeName = stringTokenizer.nextToken().toUpperCase();
            this.packageName = null;
        } else if (n == 3) {
            this.owner = stringTokenizer.nextToken().toUpperCase();
            this.packageName = stringTokenizer.nextToken().toUpperCase();
            this.typeName = stringTokenizer.nextToken().toUpperCase();
        } else {
            throw new SQLException("Invalid type name : " + string);
        }
        return n;
    }
}

