/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.Connection;
import java.sql.SQLException;

public class TbClob
extends TbClobBase {
    private static final TbClob EMPTY_CLOB = new TbClob(null, new byte[1], false);
    private static final TbClob EMPTY_NCLOB = new TbClob(null, new byte[1], false);

    public TbClob(TbConnection tbConnection, byte[] byArray, boolean bl) {
        super(tbConnection, byArray, bl);
    }

    public static TbClob createEmptyClob() {
        return EMPTY_CLOB;
    }

    public static TbClob createEmptyNClob() {
        return EMPTY_NCLOB;
    }

    public static TbClob createTemporary(Connection connection) throws SQLException {
        Debug.logMethod("TbClob.createTemporary", new Object[]{connection});
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-590713);
        }
        return ((TbConnection)connection).createTbClob();
    }

    public static TbClob createTemporaryNClob(Connection connection) throws SQLException {
        Debug.logMethod("TbClob.createTemporaryNClob", null, new Object[0]);
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-590713);
        }
        return new TbClob((TbConnection)connection, ((TbConnection)connection).getClobAccessor().createTemporaryNClob(), false);
    }

    public static void freeTemporary(TbClob tbClob) throws SQLException {
        Debug.logMethod("TbClob.freeTemporary", new String[]{"CLOB"}, new Object[]{tbClob});
        if (tbClob == null) {
            throw TbError.newSQLException(-590713);
        }
        tbClob.free();
    }

    public void freeTemporary() throws SQLException {
        this.free();
    }
}

