/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbWebRowSet;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class TbFilteredRowSet
extends TbWebRowSet {
    private static final long serialVersionUID = 8256521646635679356L;
    private boolean isOnInsert;

    public TbFilteredRowSet() throws SQLException {
        Debug.logMethod("TbFilteredRowSet", new Object[]{this});
    }

    public boolean absolute(int n) throws SQLException {
        int n2;
        Debug.logMethod("TbFilteredRowSet.absolute", new Object[]{this, Integer.toString(n)});
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590761);
        }
        if (n == 0 || Math.abs(n) > this.rowCount) {
            return false;
        }
        int n3 = n >= 0 ? n : this.rowCount + n + 1;
        this.currentRowIndex = 0;
        for (n2 = 0; n2 < n3 && this.currentRowIndex <= this.rowCount; ++n2) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (n2 == n3) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    protected void checkAndFilterObject(int n, Object object) throws SQLException {
    }

    public void insertRow() throws SQLException {
        Debug.logMethod("TbFilteredRowSet.insertRow", new Object[]{this});
        this.isOnInsert = false;
        super.insertRow();
    }

    public void moveToInsertRow() throws SQLException {
        Debug.logMethod("TbFilteredRowSet.moveToInsertRow", new Object[]{this});
        this.isOnInsert = true;
        super.moveToInsertRow();
    }

    public boolean next() throws SQLException {
        Debug.logMethod("TbFilteredRowSet.next", new Object[]{this});
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.currentRowIndex >= this.rowCount) {
            return false;
        }
        boolean bl = false;
        ++this.currentRowIndex;
        bl = true;
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        Debug.logMethod("TbFilteredRowSet.previous", new Object[]{this});
        if (this.rowsetType == 1003) {
            throw TbError.newSQLException(-590761);
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.currentRowIndex <= 1) {
            return false;
        }
        boolean bl = false;
        --this.currentRowIndex;
        bl = true;
        if (bl) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public void updateArray(int n, Array array) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateArray", new Object[]{this, Integer.toString(n), array});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, array);
        }
        super.updateArray(n, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateArray", new Object[]{this, string, array});
        this.updateArray(this.findColumn(string), array);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateAsciiStream", new Object[]{this, Integer.toString(n), inputStream, Integer.toString(n2)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, inputStream);
        }
        super.updateAsciiStream(n, inputStream, n2);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateAsciiStream", new Object[]{this, string, inputStream, Integer.toString(n)});
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBigDecimal", new Object[]{this, Integer.toString(n), bigDecimal});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, bigDecimal);
        }
        super.updateBigDecimal(n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBigDecimal", new Object[]{this, string, bigDecimal});
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBinaryStream", new Object[]{this, Integer.toString(n), inputStream, Integer.toString(n2)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, inputStream);
        }
        super.updateBinaryStream(n, inputStream, n2);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBinaryStream", new Object[]{this, string, inputStream, Integer.toString(n)});
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBlob", new Object[]{this, Integer.toString(n), blob});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, blob);
        }
        super.updateBlob(n, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBlob", new Object[]{this, string, blob});
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBoolean", new Object[]{this, Integer.toString(n), new Boolean(bl)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Boolean(bl));
        }
        super.updateBoolean(n, bl);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBoolean", new Object[]{this, string, new Boolean(bl)});
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(int n, byte by) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateByte", new Object[]{this, Integer.toString(n), Byte.toString(by)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Byte(by));
        }
        super.updateByte(n, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateByte", new Object[]{this, string, Byte.toString(by)});
        this.updateByte(this.findColumn(string), by);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBytes", new Object[]{this, Integer.toString(n), byArray});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, byArray);
        }
        super.updateBytes(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateBytes", new Object[]{this, string, byArray});
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateCharacterStream", new Object[]{this, Integer.toString(n), reader, Integer.toString(n2)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, reader);
        }
        super.updateCharacterStream(n, reader, n2);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateCharacterStream", new Object[]{this, string, reader, Integer.toString(n)});
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateClob", new Object[]{this, Integer.toString(n), clob});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, clob);
        }
        super.updateClob(n, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateClob", new Object[]{this, string, clob});
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateDate(int n, Date date) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateDate", new Object[]{this, Integer.toString(n), date});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, date);
        }
        super.updateDate(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateDate", new Object[]{this, string, date});
        this.updateDate(this.findColumn(string), date);
    }

    public void updateDouble(int n, double d) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateDouble", new Object[]{this, Integer.toString(n), Double.toString(d)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Double(d));
        }
        super.updateDouble(n, d);
    }

    public void updateDouble(String string, double d) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateDouble", new Object[]{this, string, Double.toString(d)});
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateFloat", new Object[]{this, Integer.toString(n), Float.toString(f)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Float(f));
        }
        super.updateFloat(n, f);
    }

    public void updateFloat(String string, float f) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateFloat", new Object[]{this, string, Float.toString(f)});
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateInt(int n, int n2) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateInt", new Object[]{this, Integer.toString(n), Integer.toString(n2)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Integer(n2));
        }
        super.updateInt(n, n2);
    }

    public void updateInt(String string, int n) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateInt", new Object[]{this, string, Integer.toString(n)});
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(int n, long l) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateLong", new Object[]{this, Integer.toString(n), Long.toString(l)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Long(l));
        }
        super.updateLong(n, l);
    }

    public void updateLong(String string, long l) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateLong", new Object[]{this, string, Long.toString(l)});
        this.updateLong(this.findColumn(string), l);
    }

    public void updateObject(int n, Object object) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateObject", new Object[]{this, Integer.toString(n), object});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, object);
        }
        super.updateObject(n, object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateObject", new Object[]{this, Integer.toString(n), object, Integer.toString(n2)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, object);
        }
        super.updateObject(n, object, n2);
    }

    public void updateObject(String string, Object object) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateObject", new Object[]{this, string, object});
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateObject", new Object[]{this, string, object, Integer.toString(n)});
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateRef", new Object[]{this, Integer.toString(n), ref});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, ref);
        }
        super.updateRef(n, ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateRef", new Object[]{this, string, ref});
        this.updateRef(this.findColumn(string), ref);
    }

    public void updateShort(int n, short s) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateShort", new Object[]{this, Integer.toString(n), Short.toString(s)});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, new Short(s));
        }
        super.updateShort(n, s);
    }

    public void updateShort(String string, short s) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateShort", new Object[]{this, string, Short.toString(s)});
        this.updateShort(this.findColumn(string), s);
    }

    public void updateString(int n, String string) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateString", new Object[]{this, Integer.toString(n), string});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, string);
        }
        super.updateString(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateString", new Object[]{this, string, string2});
        this.updateString(this.findColumn(string), string2);
    }

    public void updateTime(int n, Time time) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateTime", new Object[]{this, Integer.toString(n), time});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, time);
        }
        super.updateTime(n, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateTime", new Object[]{this, string, time});
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateTimestamp", new Object[]{this, Integer.toString(n), timestamp});
        if (this.isOnInsert) {
            this.checkAndFilterObject(n, timestamp);
        }
        super.updateTimestamp(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        Debug.logMethod("TbFilteredRowSet.updateTimestamp", new Object[]{this, string, timestamp});
        this.updateTimestamp(this.findColumn(string), timestamp);
    }
}

