/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import com.tmax.tibero.jdbc.ext.TbPooledConnection;
import com.tmax.tibero.jdbc.ext.TbXAException;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TbXAConnection
extends TbPooledConnection
implements XAConnection,
XAResource {
    private boolean autoCommit = false;

    public TbXAConnection(TbConnection tbConnection) throws SQLException {
        super(tbConnection);
        this.getPhysicalConnection().setAutoCommit(true);
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        this.getPhysicalConnection().getTbXAComm().xaCommit(xid, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        try {
            this.getPhysicalConnection().setTxnMode(0);
            this.getPhysicalConnection().getTbXAComm().xaEnd(xid, n);
        }
        finally {
            try {
                this.restoreAutoCommit();
            }
            catch (SQLException sQLException) {
                throw new TbXAException(sQLException.getMessage());
            }
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
    }

    @Override
    protected TbLogicalConnection getNewLogicalConnection() throws SQLException {
        return new TbLogicalConnection(this, this.getPhysicalConnection(), true);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return -1;
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (!(xAResource instanceof TbXAConnection)) {
            return false;
        }
        TbConnection tbConnection = ((TbXAConnection)xAResource).getPhysicalConnection();
        if (tbConnection == null || tbConnection.info == null) {
            return false;
        }
        TbConnection tbConnection2 = this.getPhysicalConnection();
        String string = tbConnection2.info.getURL();
        return tbConnection.equals(tbConnection2) || tbConnection.info.getURL().equals(string);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        return this.getPhysicalConnection().getTbXAComm().xaPrepare(xid);
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        if ((n & 0x1800000) != n) {
            throw new TbXAException(-5, "Invalid flag: " + n);
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        return this.getPhysicalConnection().getTbXAComm().xaRecover(n);
    }

    public final void restoreAutoCommit() throws SQLException {
        this.getPhysicalConnection().setAutoCommit(this.autoCommit);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        this.getPhysicalConnection().getTbXAComm().xaRollback(xid);
    }

    private final void saveAutoCommit() throws SQLException {
        this.autoCommit = this.getPhysicalConnection().getAutoCommit();
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        if (xid == null) {
            throw new TbXAException(-5, "Xid is null");
        }
        if (this.getPhysicalConnection().isClosed()) {
            throw new TbXAException(-7, "Connection is already closed");
        }
        try {
            this.saveAutoCommit();
            this.getPhysicalConnection().setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
        try {
            this.getPhysicalConnection().getTbXAComm().xaStart(xid, n);
            this.getPhysicalConnection().setTxnMode(2);
        }
        catch (XAException xAException) {
            try {
                this.restoreAutoCommit();
            }
            catch (SQLException sQLException) {
                throw new TbXAException(sQLException.getMessage());
            }
            throw xAException;
        }
    }
}

