/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import java.util.Calendar;

public class TbDate {
    static final short OFFSET_CENTURY = 0;
    static final short OFFSET_YEAR = 1;
    static final short OFFSET_MONTH = 2;
    static final short OFFSET_DAY_OF_MONTH = 3;
    static final short OFFSET_HOUR_OF_DAY = 4;
    static final short OFFSET_MINUTE = 5;
    static final short OFFSET_SECOND = 6;
    static final short OFFSET_DATE_END = 7;
    public static final char DELIMITER_DATE = '-';
    public static final char DELIMITER_TIME = ':';
    public static final char DELIMITER_BLANK = ' ';
    private byte[] data;

    public TbDate(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data should not be null");
        }
        if (byArray.length != 8) {
            throw new IllegalArgumentException("invalid array size");
        }
        this.data = byArray;
    }

    public TbDate(int n, int n2, int n3, int n4, int n5, int n6) {
        this.data = new byte[8];
        this.data[0] = (byte)(n / 100 + 100);
        this.data[1] = (byte)(n % 100 + 100);
        this.data[2] = (byte)n2;
        this.data[3] = (byte)n3;
        this.data[4] = (byte)n4;
        this.data[5] = (byte)n5;
        this.data[6] = (byte)n6;
        this.data[7] = 0;
    }

    public TbDate(long l) {
        this.data = new byte[8];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        int n = calendar.get(0);
        int n2 = calendar.get(1);
        if (n == 0) {
            n2 = n2 * -1 + 1;
        }
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        this.data[0] = (byte)(n2 / 100 + 100);
        this.data[1] = (byte)(n2 % 100 + 100);
        this.data[2] = (byte)n3;
        this.data[3] = (byte)n4;
        this.data[4] = (byte)n5;
        this.data[5] = (byte)n6;
        this.data[6] = (byte)n7;
        this.data[7] = 0;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getYear() {
        int n = 0xFF & this.data[0];
        int n2 = 0xFF & this.data[1];
        int n3 = (n - 100) * 100 + (n2 - 100);
        return n3;
    }

    public int getMonth() {
        int n = 0xFF & this.data[2];
        return n;
    }

    public int getDayOfMonth() {
        int n = 0xFF & this.data[3];
        return n;
    }

    public int getHourOfDay() {
        int n = 0xFF & this.data[4];
        return n;
    }

    public int getMinutes() {
        int n = 0xFF & this.data[5];
        return n;
    }

    public int getSeconds() {
        int n = 0xFF & this.data[6];
        return n;
    }

    public String toString() {
        char[] cArray = new char[20];
        int n = 0;
        int n2 = this.getYear();
        if (n2 < 10000 && n2 >= 0) {
            n += TbDate.writeFormattedInt(cArray, n, 4, this.getYear());
        } else {
            int n3;
            String string = Integer.toString(n2);
            for (n3 = 0; n3 < string.length(); ++n3) {
                cArray[n + n3] = string.charAt(n3);
            }
            n += n3;
        }
        cArray[n++] = 45;
        n += TbDate.writeFormattedInt(cArray, n, 2, this.getMonth());
        cArray[n++] = 45;
        n += TbDate.writeFormattedInt(cArray, n, 2, this.getDayOfMonth());
        cArray[n++] = 32;
        n += TbDate.writeFormattedInt(cArray, n, 2, this.getHourOfDay());
        cArray[n++] = 58;
        n += TbDate.writeFormattedInt(cArray, n, 2, this.getMinutes());
        cArray[n++] = 58;
        n += TbDate.writeFormattedInt(cArray, n, 2, this.getSeconds());
        return new String(cArray, 0, n);
    }

    private static int writeFormattedInt(char[] cArray, int n, int n2, int n3) {
        for (int i = n + n2 - 1; i >= n; --i) {
            int n4 = n3 % 10;
            cArray[i] = (char)(48 + n4);
            n3 /= 10;
        }
        return n2;
    }
}

