/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbClobReader;
import com.tmax.tibero.jdbc.TbClobWriter;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbLobInputStream;
import com.tmax.tibero.jdbc.TbLobOutputStream;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import com.tmax.tibero.jdbc.comm.TbLobAccessor;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public abstract class TbClobBase
extends TbLob
implements Clob {
    public TbClobBase(TbConnection tbConnection, byte[] byArray, boolean bl) {
        super(tbConnection, byArray, bl);
    }

    public InputStream getAsciiStream() throws SQLException {
        Debug.logMethod("TbClob.getAsciiStream", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        return new TbLobInputStream(this, 1L, Integer.MAX_VALUE);
    }

    public int getBufferSize() throws SQLException {
        Debug.logMethod("TbClob.getBufferSize", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        return TbLob.getMaxChunkSize();
    }

    public Reader getCharacterStream() throws SQLException {
        Debug.logMethod("TbClob.getCharacterStream", new Object[]{this});
        this.checkInvalidActionOnEmpty();
        return new TbClobReader(this, 1L, Long.MAX_VALUE);
    }

    public long getChars(long l, char[] cArray) throws SQLException {
        return this.getChars(l, cArray, 0L, cArray.length);
    }

    public long getChars(long l, char[] cArray, long l2) throws SQLException {
        return this.getChars(l, cArray, 0L, l2);
    }

    public long getChars(long l, char[] cArray, long l2, long l3) throws SQLException {
        Debug.logMethod("TbClob.getChars", new Object[]{this, Long.toString(l), cArray, Long.toString(l2), Long.toString(l3)});
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590764, l);
        }
        if (l3 < 0L) {
            throw TbError.newSQLException(-590765, l3);
        }
        if (l3 > (long)cArray.length) {
            l3 = cArray.length;
        }
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = this.getLengthInternal();
        long l5 = this.getClobAccessor().read(this, l - 1L, cArray, l2, l3);
        if (l4 > -1L && l == 1L && l4 <= l5 && this.getIsTempLob() && !this.getIsRsScrollable()) {
            Debug.log("Implicit clob free. " + this.toString());
            this.getLobAccessor().freeTemporary(this);
        }
        return l5;
    }

    protected TbClobAccessor getClobAccessor() {
        return this.getConnection().getClobAccessor();
    }

    protected TbLobAccessor getLobAccessor() {
        return this.getClobAccessor();
    }

    public String getSubString(long l, int n) throws SQLException {
        Debug.logMethod("TbClob.getSubString", new Object[]{this, Long.toString(l), Integer.toString(n)});
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590764, l);
        }
        if (n < 0) {
            throw TbError.newSQLException(-590765, n);
        }
        if (n == 0) {
            return new String();
        }
        char[] cArray = new char[n];
        long l2 = this.getChars(l, cArray);
        if (l2 > 0L) {
            return new String(cArray, 0, (int)l2);
        }
        return new String();
    }

    public long position(Clob clob, long l) throws SQLException {
        return super.position((TbLob)((Object)clob), l);
    }

    public long position(String string, long l) throws SQLException {
        Debug.logMethod("TbClob.position", new Object[]{this, string, Long.toString(l)});
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590766, "" + l);
        }
        return this.getClobAccessor().position(this, string.toCharArray(), l - 1L);
    }

    public long putChars(long l, char[] cArray) throws SQLException {
        Debug.logMethod("TbClob.putChars", new Object[]{this, Long.toString(l), cArray});
        return this.putCharsInternal(l, cArray, 0L, cArray.length);
    }

    public long putChars(long l, char[] cArray, long l2) throws SQLException {
        Debug.logMethod("TbClob.putChars", new Object[]{this, Long.toString(l), cArray, Long.toString(l2)});
        return this.putCharsInternal(l, cArray, 0L, l2);
    }

    public int putChars(long l, char[] cArray, long l2, long l3) throws SQLException {
        Debug.logMethod("TbClob.putChars", new Object[]{this, Long.toString(l), cArray, Long.toString(l2), Long.toString(l3)});
        return (int)this.putCharsInternal(l, cArray, l2, l3);
    }

    private long putCharsInternal(long l, char[] cArray, long l2, long l3) throws SQLException {
        this.checkInvalidActionOnEmpty();
        if (l < 1L) {
            throw TbError.newSQLException(-590764, l);
        }
        if (l3 < 0L) {
            throw TbError.newSQLException(-590765, l3);
        }
        if (l2 + l3 > (long)cArray.length) {
            l3 = (long)cArray.length - l2;
        }
        if (l3 <= 0L) {
            return 0L;
        }
        return this.getClobAccessor().write(this, l - 1L, cArray, l2, l3);
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        Debug.logMethod("TbClob.setAsciiStream", new Object[]{this, Long.toString(l)});
        this.checkInvalidActionOnEmpty();
        return new TbLobOutputStream(this, l == 0L ? 1L : l);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        Debug.logMethod("TbClob.setCharacterStream", new Object[]{this, Long.toString(l)});
        this.checkInvalidActionOnEmpty();
        return new TbClobWriter(this, l == 0L ? 1L : l);
    }

    public int setString(long l, String string) throws SQLException {
        Debug.logMethod("TbClob.setString", new Object[]{this, Long.toString(l), string});
        this.checkInvalidActionOnEmpty();
        if (string == null) {
            throw TbError.newSQLException(-590768);
        }
        char[] cArray = string.toCharArray();
        return (int)this.putCharsInternal(l, cArray, 0L, cArray.length);
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        Debug.logMethod("TbClob.setString", new Object[]{this, Long.toString(l), string, Integer.toString(n), Integer.toString(n2)});
        this.checkInvalidActionOnEmpty();
        if (n2 < 0) {
            throw TbError.newSQLException(-590765, n2);
        }
        if (string == null) {
            throw TbError.newSQLException(-590768);
        }
        if (n2 == 0) {
            return 0;
        }
        char[] cArray = new char[n2];
        string.getChars(n, n + n2, cArray, 0);
        return (int)this.putCharsInternal(l, cArray, 0L, n2);
    }
}

