/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSet;
import com.tmax.tibero.jdbc.rowset.TbCachedRowSetReader;
import com.tmax.tibero.jdbc.rowset.TbRow;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;

public class TbCachedRowSetWriter
implements RowSetWriter,
Serializable {
    private static final long serialVersionUID = -4465449178814496564L;
    private StringBuffer updateClause = new StringBuffer("");
    private StringBuffer deleteClause = new StringBuffer("");
    private StringBuffer insertClause = new StringBuffer("");
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection conn;
    private int columnCount;

    private boolean deleteRow(RowSet rowSet, TbRow tbRow) throws SQLException {
        this.deleteStmt.clearParameters();
        for (int i = 1; i <= this.columnCount; ++i) {
            if (tbRow.isNull(i)) {
                return this.deleteRowWithNull(rowSet, tbRow);
            }
            Object object = tbRow.getColumn(i);
            if (object == null) {
                this.deleteStmt.setNull(i, this.rsmd.getColumnType(i));
                continue;
            }
            this.deleteStmt.setObject(i, object);
        }
        return this.deleteStmt.executeUpdate() == 1;
    }

    private boolean deleteRowWithNull(RowSet rowSet, TbRow tbRow) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        for (n = 1; n <= this.columnCount; n += 1) {
            if (!n) {
                stringBuffer.append(" AND ");
            }
            if (tbRow.isNull(n)) {
                stringBuffer.append(this.rsmd.getColumnName(n) + " IS NULL ");
                continue;
            }
            stringBuffer.append(this.rsmd.getColumnName(n) + " = :" + n);
        }
        Statement statement = null;
        try {
            statement = this.conn.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            int n2 = 1;
            for (int i = 1; i <= this.columnCount; ++i) {
                if (tbRow.isNull(i)) continue;
                statement.setObject(n2++, tbRow.getColumn(i));
            }
            int n3 = n = statement.executeUpdate() == 1 ? 1 : 0;
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
        return n != 0;
    }

    private String getTableName(RowSet rowSet) throws SQLException {
        String string = rowSet.getCommand().toUpperCase();
        int n = string.indexOf(" FROM ");
        if (n == -1) {
            throw TbError.newSQLException(-90821);
        }
        String string2 = string.substring(n + 6).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    private void initSQLStatement(RowSet rowSet) throws SQLException {
        int n;
        this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowSet) + "(");
        this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        this.rsmd = rowSet.getMetaData();
        this.columnCount = this.rsmd.getColumnCount();
        for (n = 0; n < this.columnCount; ++n) {
            if (n != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(this.rsmd.getColumnName(n + 1));
            if (n != 0) {
                this.updateClause.append(", ");
            }
            this.updateClause.append(this.rsmd.getColumnName(n + 1) + " = :" + n);
            if (n != 0) {
                this.deleteClause.append(" AND ");
            }
            this.deleteClause.append(this.rsmd.getColumnName(n + 1) + " = :" + n);
        }
        this.insertClause.append(") VALUES (");
        this.updateClause.append(" WHERE ");
        for (n = 0; n < this.columnCount; ++n) {
            if (n != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(":" + n);
            if (n != 0) {
                this.updateClause.append(" AND ");
            }
            this.updateClause.append(this.rsmd.getColumnName(n + 1) + " = :" + n);
        }
        this.insertClause.append(")");
        this.insertStmt = this.conn.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
        this.updateStmt = this.conn.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
        this.deleteStmt = this.conn.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
    }

    private boolean insertRow(TbRow tbRow) throws SQLException {
        this.insertStmt.clearParameters();
        for (int i = 1; i <= this.columnCount; ++i) {
            Object object = null;
            Object object2 = object = tbRow.isColumnChanged(i) ? tbRow.getChangedColumn(i) : tbRow.getColumn(i);
            if (object == null) {
                this.insertStmt.setNull(i, this.rsmd.getColumnType(i));
                continue;
            }
            this.insertStmt.setObject(i, object);
        }
        return this.insertStmt.executeUpdate() == 1;
    }

    private boolean updateRow(RowSet rowSet, TbRow tbRow) throws SQLException {
        int n;
        this.updateStmt.clearParameters();
        for (n = 1; n <= this.columnCount; ++n) {
            Object object = null;
            Object object2 = object = tbRow.isColumnChanged(n) ? tbRow.getChangedColumn(n) : tbRow.getColumn(n);
            if (object == null) {
                this.updateStmt.setNull(n, this.rsmd.getColumnType(n));
                continue;
            }
            this.updateStmt.setObject(n, object);
        }
        for (n = 1; n <= this.columnCount; ++n) {
            if (tbRow.isNull(n)) {
                return this.updateRowWithNull(rowSet, tbRow);
            }
            this.updateStmt.setObject(n + this.columnCount, tbRow.getColumn(n));
        }
        return this.updateStmt.executeUpdate() == 1;
    }

    private boolean updateRowWithNull(RowSet rowSet, TbRow tbRow) throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        for (n = 1; n <= this.columnCount; n += 1) {
            if (!n) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.rsmd.getColumnName(n) + " = :" + n);
        }
        stringBuffer.append(" WHERE ");
        for (n = 1; n <= this.columnCount; n += 1) {
            if (!n) {
                stringBuffer.append(" AND ");
            }
            if (tbRow.isNull(n)) {
                stringBuffer.append(this.rsmd.getColumnName(n) + " IS NULL ");
                continue;
            }
            stringBuffer.append(this.rsmd.getColumnName(n) + " = :" + n);
        }
        Statement statement = null;
        try {
            int n2;
            statement = this.conn.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            for (n2 = 1; n2 <= this.columnCount; ++n2) {
                Object object = null;
                Object object2 = object = tbRow.isColumnChanged(n2) ? tbRow.getChangedColumn(n2) : tbRow.getColumn(n2);
                if (object == null) {
                    statement.setNull(n2, this.rsmd.getColumnType(n2));
                    continue;
                }
                statement.setObject(n2, object);
            }
            int n3 = 1;
            for (n2 = 1; n2 <= this.columnCount; ++n2) {
                if (tbRow.isNull(n2)) continue;
                statement.setObject(n3 + this.columnCount, tbRow.getColumn(n2));
                ++n3;
            }
            int n4 = n = statement.executeUpdate() == 1 ? 1 : 0;
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            if (statement != null) {
                statement.close();
            }
            throw sQLException;
        }
        return n != 0;
    }

    public synchronized boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        TbCachedRowSet tbCachedRowSet = (TbCachedRowSet)rowSetInternal;
        this.conn = ((TbCachedRowSetReader)tbCachedRowSet.getReader()).getConnection(rowSetInternal);
        if (this.conn.getAutoCommit()) {
            this.conn.setAutoCommit(false);
        }
        this.conn.setTransactionIsolation(tbCachedRowSet.getTransactionIsolation());
        this.initSQLStatement(tbCachedRowSet);
        if (this.columnCount < 1) {
            this.conn.close();
            return true;
        }
        boolean bl = tbCachedRowSet.getShowDeleted();
        tbCachedRowSet.setShowDeleted(true);
        tbCachedRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        while (tbCachedRowSet.next()) {
            TbRow tbRow;
            if (tbCachedRowSet.rowInserted()) {
                if (tbCachedRowSet.rowDeleted()) continue;
                tbRow = tbCachedRowSet.getCurrentRow();
                bl3 = this.insertRow(tbRow) || bl3;
                continue;
            }
            if (tbCachedRowSet.rowUpdated()) {
                tbRow = tbCachedRowSet.getCurrentRow();
                bl2 = this.updateRow(tbCachedRowSet, tbRow) || bl2;
                continue;
            }
            if (!tbCachedRowSet.rowDeleted()) continue;
            tbRow = tbCachedRowSet.getCurrentRow();
            bl4 = this.deleteRow(tbCachedRowSet, tbRow) || bl4;
        }
        if (bl2 && bl3 && bl4) {
            this.conn.commit();
            tbCachedRowSet.setOriginal();
        } else {
            this.conn.rollback();
        }
        this.insertStmt.close();
        this.updateStmt.close();
        this.deleteStmt.close();
        if (!tbCachedRowSet.isConnectionOpened()) {
            this.conn.close();
        }
        tbCachedRowSet.setShowDeleted(bl);
        return true;
    }
}

