/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.pivot;

import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import com.tmax.tibero.pivot.TbPivotColMeta;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class TbPivotMeta {
    TbPivotInfo[] pivotInfo;
    Vector pivotData;
    int[] startChunkIdx;
    int[] offset;
    int[] curChunkPos;
    HashMap colIdxMap;
    Vector[] metas;
    HashMap[] newIdxMap;
    int[] curIdx;

    public TbPivotMeta(TbStatement tbStatement) throws Exception {
        int n;
        this.pivotInfo = tbStatement.getPivotInfo();
        this.pivotData = tbStatement.getPivotData();
        if (this.pivotInfo == null) {
            return;
        }
        this.startChunkIdx = new int[this.pivotInfo.length];
        this.offset = new int[this.pivotInfo.length];
        this.curChunkPos = new int[this.pivotInfo.length];
        this.colIdxMap = new HashMap();
        int n2 = 0;
        for (n = 0; n < this.pivotInfo.length; ++n) {
            this.colIdxMap.put(new Integer(this.pivotInfo[n].colIdx), new Integer(n));
            this.startChunkIdx[n] = n2;
            this.curChunkPos[n] = n2;
            this.offset[n] = 0;
            n2 += this.pivotInfo[n].chunkCnt;
        }
        this.metas = new Vector[this.pivotInfo.length];
        this.newIdxMap = new HashMap[this.pivotInfo.length];
        this.curIdx = new int[this.pivotInfo.length];
        for (n = 0; n < this.pivotInfo.length; ++n) {
            Object object;
            this.metas[n] = new Vector();
            this.newIdxMap[n] = new HashMap();
            int n3 = 0;
            while ((object = this.getNextOldColName(n)) != null) {
                this.metas[n].add(new TbPivotColMeta(n3, (String)object, this.getOldValType(n, n3)));
                ++n3;
            }
            Collections.sort(this.metas[n]);
            for (n3 = 0; n3 < this.metas[n].size(); ++n3) {
                object = (TbPivotColMeta)this.metas[n].elementAt(n3);
                this.newIdxMap[n].put(new Integer(((TbPivotColMeta)object).getOldIdx()), new Integer(n3));
            }
            this.curIdx[n] = 0;
        }
        this.pivotInfo = null;
        this.pivotData = null;
        this.startChunkIdx = null;
        this.offset = null;
        this.curChunkPos = null;
    }

    private int getPivotIdx(int n) throws Exception {
        Integer n2 = (Integer)this.colIdxMap.get(new Integer(n));
        if (n2 != null) {
            return n2;
        }
        throw new Exception("invalid index for pivot column: " + n);
    }

    private String getNextOldColName(int n) throws Exception {
        if (this.curChunkPos[n] == this.startChunkIdx[n] + this.pivotInfo[n].chunkCnt) {
            return null;
        }
        byte[] byArray = (byte[])this.pivotData.elementAt(this.curChunkPos[n]);
        int n2 = this.offset[n];
        int n3 = 0;
        if (byArray[n2] <= 250) {
            n3 = 0xFF & byArray[n2];
            ++n2;
            int n4 = n;
            this.offset[n4] = this.offset[n4] + (1 + n3);
        } else if (byArray[n2] == 254) {
            n3 = (0xFF & byArray[n2 + 1]) << 8;
            n3 &= 0xFF & byArray[n2 + 2];
            n2 += 3;
            int n5 = n;
            this.offset[n5] = this.offset[n5] + (3 + n3);
        } else {
            throw new Exception("rpcol length field curruption");
        }
        if (this.offset[n] == byArray.length) {
            int n6 = n;
            this.curChunkPos[n6] = this.curChunkPos[n6] + 1;
            this.offset[n] = 0;
        }
        if (n3 == 0) {
            return "";
        }
        return new String(byArray, n2, n3);
    }

    private int getOldValType(int n, int n2) throws Exception {
        TbPivotInfo tbPivotInfo = this.pivotInfo[n];
        if (tbPivotInfo.valType == null) {
            throw new Exception("can't provide value type information");
        }
        int n3 = tbPivotInfo.valType.length;
        return tbPivotInfo.valType[n2 % n3].type;
    }

    public String getNextColName(int n) throws Exception {
        if (this.colIdxMap == null) {
            return null;
        }
        int n2 = this.getPivotIdx(n);
        if (this.curIdx[n2] == this.metas[n2].size()) {
            return null;
        }
        TbPivotColMeta tbPivotColMeta = (TbPivotColMeta)this.metas[n2].elementAt(this.curIdx[n2]);
        int n3 = n2;
        this.curIdx[n3] = this.curIdx[n3] + 1;
        return tbPivotColMeta.getName();
    }

    public int getValType(int n, int n2) throws Exception {
        int n3 = this.getPivotIdx(n);
        TbPivotColMeta tbPivotColMeta = (TbPivotColMeta)this.metas[n3].elementAt(n2);
        return tbPivotColMeta.getType();
    }

    public HashMap getNewIdxMap(int n) throws Exception {
        return this.newIdxMap[this.getPivotIdx(n)];
    }
}

