/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.driver.TbTimeoutPollingThread;
import java.sql.SQLException;

public class TbTimeout {
    private static final long INFINITE_TIME = Long.MAX_VALUE;
    private static final TbTimeoutPollingThread pollingThread = new TbTimeoutPollingThread();
    private TbStatement stmt;
    private long interruptAfter;

    static TbTimeout newTimeout() throws SQLException {
        TbTimeout tbTimeout = new TbTimeout();
        return tbTimeout;
    }

    TbTimeout() {
        Debug.logMethod("TbTimeout", new Object[]{this});
        this.interruptAfter = Long.MAX_VALUE;
        pollingThread.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelStmtOfTimeover(long l) {
        Debug.logMethod("TbTimeout.cancelStmtOfTimeover", new Object[]{this});
        if (l > this.interruptAfter) {
            TbTimeout tbTimeout = this;
            synchronized (tbTimeout) {
                if (l > this.interruptAfter) {
                    try {
                        this.stmt.cancel();
                        this.stmt = null;
                        this.interruptAfter = Long.MAX_VALUE;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            }
        }
    }

    synchronized void cancelTimeout() throws SQLException {
        Debug.logMethod("TbTimeout.cancelTimeout", new Object[]{this});
        this.stmt = null;
        this.interruptAfter = Long.MAX_VALUE;
    }

    void close() {
        Debug.logMethod("TbTimeout.close", new Object[]{this});
        pollingThread.remove(this);
    }

    synchronized void setTimeout(long l, TbStatement tbStatement) throws SQLException {
        Debug.logMethod("TbTimeout.setTimeout", new Object[]{this, new Long(l), tbStatement});
        this.stmt = tbStatement;
        this.interruptAfter = System.currentTimeMillis() + l;
    }
}

