/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbPreparedStatement;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import com.tmax.tibero.jdbc.ext.TbStatementEventHandler;
import com.tmax.tibero.jdbc.msg.TbPivotInfo;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

class TbLogicalPreparedStatement
extends TbPreparedStatement
implements TbStatementEventHandler {
    private TbLogicalConnection logicalConn = null;
    private boolean closed = true;
    protected com.tmax.tibero.jdbc.driver.TbPreparedStatement physicalStmt = null;
    protected HashMap<StatementEventListener, StatementEventListener> stmtEventMap = null;

    public TbLogicalPreparedStatement(TbLogicalConnection tbLogicalConnection, com.tmax.tibero.jdbc.driver.TbPreparedStatement tbPreparedStatement) throws SQLException {
        this.logicalConn = tbLogicalConnection;
        this.stmtEventMap = this.logicalConn.getStatementEventListeners();
        this.physicalStmt = tbPreparedStatement;
        if (tbPreparedStatement.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90658);
        }
        this.closed = false;
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void addPivotData(byte[] byArray) {
        if (this.physicalStmt != null) {
            this.physicalStmt.addPivotData(byArray);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.cancel();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        this.physicalStmt.clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearParameters();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.physicalStmt.resetForCache();
        this.notifyClosedEvent();
    }

    @Override
    public void closeInternal() throws SQLException {
        if (this.physicalStmt != null) {
            this.physicalStmt.closeInternal();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeBatch();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.logicalConn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxRows();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getOriginalSql() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getOriginalSql();
        }
        return null;
    }

    @Override
    public ParamContainer getParamContainer() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getParamContainer();
        }
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public Vector<byte[]> getPivotData() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotData();
        }
        return null;
    }

    @Override
    public TbPivotInfo[] getPivotInfo() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPivotInfo();
        }
        return null;
    }

    @Override
    public byte[] getPPID() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getPPID();
        }
        return null;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSet();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.physicalStmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetType();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getSqlType() {
        if (this.physicalStmt != null) {
            return this.physicalStmt.getSqlType();
        }
        return 0;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.isPoolable();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public void notifyClosedEvent() {
        if (this.physicalStmt != null && this.stmtEventMap != null) {
            Iterator<StatementEventListener> iterator = this.stmtEventMap.keySet().iterator();
            while (iterator.hasNext()) {
                StatementEventListener statementEventListener = this.stmtEventMap.get(iterator.next());
                statementEventListener.statementClosed(new StatementEvent((PooledConnection)((Object)this.logicalConn.getEventHandler()), this));
            }
        }
    }

    @Override
    public void notifyExceptionEvent(PreparedStatement preparedStatement, Exception exception) {
        if (this.physicalStmt != null && this.stmtEventMap != null) {
            Iterator<StatementEventListener> iterator = this.stmtEventMap.keySet().iterator();
            while (iterator.hasNext()) {
                StatementEventListener statementEventListener = this.stmtEventMap.get(iterator.next());
                statementEventListener.statementErrorOccurred(new StatementEvent((PooledConnection)((Object)this.logicalConn.getEventHandler()), this, (SQLException)exception));
            }
        }
    }

    @Override
    public void resetForCache() {
        if (this.physicalStmt != null) {
            this.physicalStmt.resetForCache();
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setArray(n, array);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryDouble(int n, double d) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryFloat(int n, float f) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(n, inputStream);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(n, inputStream, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setByte(n, by);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setBytes(int n, int n2, byte[] byArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(n, n2, byArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCursorName(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(n, date);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFixedCHAR(int n, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFixedCHAR(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setLong(n, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(n, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNCharacterStream(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Clob clob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(n, nClob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(n, reader);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNClob(n, reader, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNString(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setPivotInfo(TbPivotInfo[] tbPivotInfoArray) {
        if (this.physicalStmt != null) {
            this.physicalStmt.setPivotInfo(tbPivotInfoArray);
        }
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setPoolable(bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRowId(n, rowId);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setShort(n, s);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setSQLXML(n, sQLXML);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setString(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTbDate(int n, TbDate tbDate) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbDate(n, tbDate);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTbTimestamp(n, tbTimestamp);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(n, time);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }
}

