/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;

public abstract class TbResultSet
implements com.tmax.tibero.jdbc.TbResultSet {
    protected SQLWarning warnings = null;
    protected RsetType rsetType = RsetType.FWRD;
    protected int rowsFetchedCnt = 0;
    protected boolean haveLocator = false;

    protected TbResultSet(RsetType rsetType) {
        if (rsetType != null) {
            this.rsetType = rsetType.getCopy();
        }
    }

    @Override
    public synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    @Override
    public abstract void buildRowTable(int var1, byte[] var2) throws SQLException;

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public int getBytes(int n, byte[] byArray) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public abstract Column[] getCols() throws SQLException;

    protected abstract int getColumnDataType(int var1) throws SQLException;

    protected abstract int getColumnMaxLength(int var1) throws SQLException;

    protected abstract String getColumnName(int var1) throws SQLException;

    protected abstract boolean getColumnNullable(int var1) throws SQLException;

    protected abstract int getColumnPrecision(int var1) throws SQLException;

    protected abstract int getColumnScale(int var1) throws SQLException;

    protected abstract int getColumnSqlType(int var1) throws SQLException;

    @Override
    public int getConcurrency() throws SQLException {
        return this.rsetType.getConcurrency();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.rsetType.getHoldability();
    }

    @Override
    public InputStream getLongByteStream(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public abstract byte[] getRowChunk(int var1) throws SQLException;

    @Override
    public RsetType getRsetType() {
        return this.rsetType;
    }

    @Override
    public int getType() throws SQLException {
        return this.rsetType.getType();
    }

    @Override
    public long getUpdateCount() {
        return this.rowsFetchedCnt;
    }

    @Override
    public abstract TbDate getTbDate(int var1) throws SQLException;

    @Override
    public abstract TbTimestamp getTbTimestamp(int var1) throws SQLException;

    @Override
    public abstract void updateTbTimestamp(int var1, TbTimestamp var2) throws SQLException;

    @Override
    public abstract void updateTbTimestamp(String var1, TbTimestamp var2) throws SQLException;

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    protected void reset() {
        this.warnings = null;
        this.rsetType = null;
        this.rowsFetchedCnt = 0;
        this.haveLocator = true;
    }

    @Override
    public abstract void setFetchCompleted(int var1) throws SQLException;

    @Override
    public void setHaveLocator(boolean bl) {
        this.haveLocator = bl;
    }

    @Override
    public void setRsetType(RsetType rsetType) {
        this.rsetType = rsetType;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }
}

