/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class TbArrayDescriptor
extends TbTypeDescriptor {
    private TbConnection conn;
    private int elementType;
    private String elementTypeName;
    private int elementsLimit;

    protected TbArrayDescriptor(String string, Connection connection) throws SQLException {
        this.init(29, string.toUpperCase());
        this.conn = (TbConnection)connection;
    }

    protected TbArrayDescriptor(int n, String string, int n2, int n3, String string2, int n4, Connection connection) throws SQLException {
        this.init(n, string);
        this.elementType = n3;
        this.elementTypeName = string2;
        this.elementsLimit = n4;
    }

    public static TbArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        if (!tbConnection.getExtFeatureInfo().supports(2)) {
            throw TbError.newSQLException(-90203);
        }
        String string2 = string.toUpperCase();
        Object object = tbConnection.getDescriptor(string2);
        if (object instanceof TbArrayDescriptor) {
            return (TbArrayDescriptor)object;
        }
        if (object != null) {
            throw TbError.newSQLException(-90666);
        }
        TbArrayDescriptor tbArrayDescriptor = new TbArrayDescriptor(string2, connection);
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(TbDatabaseMetaQuery.QUERY_COLLECTION_TYPE);
            preparedStatement.setString(1, tbArrayDescriptor.getSchemaName());
            preparedStatement.setString(2, tbArrayDescriptor.getTypeName());
            ResultSet resultSet = preparedStatement.executeQuery();
            bl = resultSet.next();
            if (bl) {
                tbArrayDescriptor.elementsLimit = resultSet.getInt(2);
                tbArrayDescriptor.elementType = resultSet.getInt(3);
                tbArrayDescriptor.elementTypeName = resultSet.getString(4);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw TbError.newSQLException(-90664, exception);
        }
        if (!bl) {
            throw TbError.newSQLException(-90665);
        }
        return tbArrayDescriptor;
    }

    public static TbArrayDescriptor createDescriptor(String string, int n, int n2, String string2, int n3, Connection connection) throws SQLException {
        if (string == null || string.length() == 0) {
            throw TbError.newSQLException(-90608, "sqlTypeName[" + string + "]");
        }
        if (!(connection instanceof TbConnection)) {
            throw TbError.newSQLException(-90608, "conn[" + connection + "]");
        }
        TbConnection tbConnection = (TbConnection)connection;
        String string3 = string.toUpperCase();
        TbArrayDescriptor tbArrayDescriptor = new TbArrayDescriptor(29, string3, n, n2, string2, n3, tbConnection);
        tbConnection.putDescriptor(tbArrayDescriptor.getSQLTypeName(), tbArrayDescriptor);
        return tbArrayDescriptor;
    }

    public int getBaseType() throws SQLException {
        return DataType.getSqlType(this.elementType);
    }

    public int getElementType() {
        return this.elementType;
    }

    public String getElementTypeName() {
        return this.elementTypeName;
    }

    public int getElementsLimit() {
        return this.elementsLimit;
    }
}

