/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbSQLOutput;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbStruct
implements Struct {
    private TbStructDescriptor descriptor;
    private TbConnection conn;
    private Object[] attributes;
    private Params subParams;

    public TbStruct(TbStructDescriptor tbStructDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        if (tbStructDescriptor == null) {
            throw TbError.newSQLException(-90608, "desc=null");
        }
        if (connection == null) {
            throw TbError.newSQLException(-90608, "conn=null");
        }
        this.descriptor = tbStructDescriptor;
        this.conn = (TbConnection)connection;
        this.attributes = objectArray;
        int n = tbStructDescriptor.getNumOfFields();
        int[] nArray = tbStructDescriptor.getAttributeTypes();
        this.subParams = new Params();
        this.initSubParams(n, nArray, objectArray);
    }

    private void initSubParams(int n, int[] nArray, Object[] objectArray) throws SQLException {
        int n2 = objectArray == null ? 0 : objectArray.length;
        Params.access$002(this.subParams, new Binder[n]);
        block11: for (int i = 0; i < n2; ++i) {
            if (objectArray[i] == null) {
                ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNullBinder();
                continue;
            }
            switch (nArray[i]) {
                case 1: {
                    if (this.subParams.paramBigDecimal == null) {
                        Params.access$102(this.subParams, new BigDecimal[n]);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBigDecimalBinder();
                    }
                    if (objectArray[i] instanceof Short) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Short)objectArray[i]).intValue());
                        continue block11;
                    }
                    if (objectArray[i] instanceof Integer) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Integer)objectArray[i]);
                        continue block11;
                    }
                    if (objectArray[i] instanceof Long) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Long)objectArray[i]);
                        continue block11;
                    }
                    if (objectArray[i] instanceof BigInteger) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((BigInteger)objectArray[i]);
                        continue block11;
                    }
                    if (objectArray[i] instanceof BigDecimal) {
                        ((Params)this.subParams).paramBigDecimal[i] = (BigDecimal)objectArray[i];
                        continue block11;
                    }
                    if (objectArray[i] instanceof Float) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal(((Float)objectArray[i]).floatValue());
                        continue block11;
                    }
                    if (objectArray[i] instanceof Double) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Double)objectArray[i]);
                        continue block11;
                    }
                    if (objectArray[i] instanceof String) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((String)objectArray[i]);
                        continue block11;
                    }
                    if (objectArray[i] instanceof Boolean) {
                        ((Params)this.subParams).paramBigDecimal[i] = new BigDecimal((Boolean)objectArray[i] != false ? 1.0 : 0.0);
                        continue block11;
                    }
                    Object object2 = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object2);
                }
                case 2: 
                case 3: 
                case 10: {
                    if (this.subParams.paramString == null) {
                        Params.access$202(this.subParams, new String[n]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStringBinder();
                    if (objectArray[i] instanceof Boolean) {
                        ((Params)this.subParams).paramString[i] = (Boolean)objectArray[i] != false ? "1" : "0";
                        continue block11;
                    }
                    if (objectArray[i] == null) {
                        ((Params)this.subParams).paramString[i] = null;
                        continue block11;
                    }
                    ((Params)this.subParams).paramString[i] = objectArray[i].toString();
                    continue block11;
                }
                case 18: 
                case 19: {
                    if (this.subParams.paramString == null) {
                        Params.access$202(this.subParams, new String[n]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNStringBinder();
                    ((Params)this.subParams).paramString[i] = objectArray[i] instanceof Boolean ? ((Boolean)objectArray[i] != false ? "1" : "0") : (objectArray[i] == null ? null : objectArray[i].toString());
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getNStringBinder();
                    continue block11;
                }
                case 4: {
                    if (this.subParams.paramBytes == null) {
                        Params.access$302(this.subParams, new byte[n][]);
                    }
                    ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                    if (objectArray[i] instanceof byte[]) {
                        ((Params)this.subParams).paramBytes[i] = (byte[])objectArray[i];
                        continue block11;
                    }
                    Object object2 = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object2);
                }
                case 5: {
                    Object object2;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$402(this.subParams, new Calendar[n]);
                        }
                        object2 = Calendar.getInstance(((TbTimestampTZ)objectArray[i]).getTimeZone());
                        ((Calendar)object2).setTime((TbTimestampTZ)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object2;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$502(this.subParams, new TbDate[n]);
                        }
                        object2 = (TbTimestamp)objectArray[i];
                        ((Params)this.subParams).paramTbDate[i] = new TbDate(((TbTimestamp)object2).getYear(), ((TbTimestamp)object2).getMonth(), ((TbTimestamp)object2).getDayOfMonth(), ((TbTimestamp)object2).getHourOfDay(), ((TbTimestamp)object2).getMinutes(), ((TbTimestamp)object2).getSeconds());
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof TbDate) {
                        if (this.subParams.paramTbDate == null) {
                            Params.access$502(this.subParams, new TbDate[n]);
                        }
                        ((Params)this.subParams).paramTbDate[i] = (TbDate)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$402(this.subParams, new Calendar[n]);
                        }
                        object2 = Calendar.getInstance();
                        ((Calendar)object2).setTime((Date)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object2;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Timestamp) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$402(this.subParams, new Calendar[n]);
                        }
                        object2 = Calendar.getInstance();
                        ((Calendar)object2).setTime((Timestamp)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object2;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof String) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$402(this.subParams, new Calendar[n]);
                        }
                        object2 = Calendar.getInstance();
                        ((Calendar)object2).setTime(Date.valueOf((String)objectArray[i]));
                        ((Params)this.subParams).paramCalendar[i] = object2;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    object2 = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object2);
                }
                case 7: {
                    Object object2;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$602(this.subParams, new Timestamp[n]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof TbTimestamp) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$702(this.subParams, new TbTimestamp[n]);
                        }
                        ((Params)this.subParams).paramTbTimestamp[i] = (TbTimestamp)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbTimestampBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof TbDate) {
                        if (this.subParams.paramTbTimestamp == null) {
                            Params.access$702(this.subParams, new TbTimestamp[n]);
                        }
                        object2 = (TbDate)objectArray[i];
                        ((Params)this.subParams).paramTbTimestamp[i] = new TbTimestamp(((TbDate)object2).getYear(), ((TbDate)object2).getMonth(), ((TbDate)object2).getDayOfMonth(), ((TbDate)object2).getHourOfDay(), ((TbDate)object2).getMinutes(), ((TbDate)object2).getSeconds(), 0);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTbTimestampBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Timestamp) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$602(this.subParams, new Timestamp[n]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = (Timestamp)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Date) {
                        if (this.subParams.paramCalendar == null) {
                            Params.access$402(this.subParams, new Calendar[n]);
                        }
                        object2 = Calendar.getInstance();
                        ((Calendar)object2).setTime((Date)objectArray[i]);
                        ((Params)this.subParams).paramCalendar[i] = object2;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof String) {
                        if (this.subParams.paramTimestamp == null) {
                            Params.access$602(this.subParams, new Timestamp[n]);
                        }
                        ((Params)this.subParams).paramTimestamp[i] = Timestamp.valueOf((String)objectArray[i]);
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getTimestampBinder();
                        continue block11;
                    }
                    object2 = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object2);
                }
                case 12: 
                case 13: 
                case 20: {
                    if (objectArray[i] instanceof TbLob) {
                        if (this.subParams.paramBytes == null) {
                            Params.access$302(this.subParams, new byte[n][]);
                        }
                        ((Params)this.subParams).paramBytes[i] = ((TbLob)objectArray[i]).getLocator();
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getBytesBinder();
                        continue block11;
                    }
                    Object object2 = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                    throw TbError.newSQLException(-90651, (String)object2);
                }
                case 29: 
                case 30: {
                    if (objectArray[i] instanceof Array) {
                        if (this.subParams.paramArray == null) {
                            Params.access$802(this.subParams, new Array[n]);
                        }
                        ((Params)this.subParams).paramArray[i] = (Array)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getArrayBinder();
                        continue block11;
                    }
                    Object object2 = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                    throw TbError.newSQLException(-90651, (String)object2);
                }
                case 28: 
                case 32: {
                    Object object;
                    Object object2;
                    if (objectArray[i] == null) {
                        // empty if block
                    }
                    if (objectArray[i] instanceof Struct) {
                        if (this.subParams.paramStruct == null) {
                            Params.access$902(this.subParams, new Struct[n]);
                        }
                        ((Params)this.subParams).paramStruct[i] = (Struct)objectArray[i];
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStructBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof SQLData && (object = this.conn.getDescriptor((object2 = (SQLData)objectArray[i]).getSQLTypeName())) instanceof TbStructDescriptor) {
                        TbSQLOutput tbSQLOutput = (TbSQLOutput)((TbStructDescriptor)object).toSQLOutput();
                        object2.writeSQL(tbSQLOutput);
                        TbStruct tbStruct = tbSQLOutput.getStruct();
                        if (this.subParams.paramStruct == null) {
                            Params.access$902(this.subParams, new Struct[n]);
                        }
                        ((Params)this.subParams).paramStruct[i] = tbStruct;
                        ((Params)this.subParams).attributeBinders[i] = StaticBinder.getStructBinder();
                        continue block11;
                    }
                    object2 = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                    throw TbError.newSQLException(-90651, (String)object2);
                }
                default: {
                    throw TbError.newSQLException(-590703, DataType.getDBTypeName(nArray[i]));
                }
            }
        }
    }

    public TbStructDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public int getNumOfFields() {
        return this.descriptor.getNumOfFields();
    }

    public static Object toStruct(Object object, Connection connection) throws SQLException {
        TbStruct tbStruct = null;
        if (object != null) {
            if (object instanceof TbStruct) {
                tbStruct = (TbStruct)object;
            } else if (object instanceof SQLData) {
                SQLData sQLData = (SQLData)object;
                TbStructDescriptor tbStructDescriptor = TbStructDescriptor.createDescriptor(sQLData.getSQLTypeName(), connection);
                SQLOutput sQLOutput = tbStructDescriptor.toSQLOutput();
                sQLData.writeSQL(sQLOutput);
                tbStruct = ((TbSQLOutput)sQLOutput).getStruct();
            } else {
                throw TbError.newSQLException(-90651, String.valueOf(object));
            }
        }
        return tbStruct;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.descriptor.getSQLTypeName();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    public Object toClass(Class<?> clazz, Map<String, Class<?>> map) throws SQLException {
        if (clazz == null) {
            return this;
        }
        Object var3_3 = null;
        try {
            var3_3 = clazz.newInstance();
            if (var3_3 instanceof SQLData) {
                ((SQLData)var3_3).readSQL(this.descriptor.toSQLInput(this, map), this.descriptor.getSQLTypeName());
            }
        }
        catch (InstantiationException instantiationException) {
            throw TbError.newSQLException(-90651, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw TbError.newSQLException(-90651, illegalAccessException);
        }
        return var3_3;
    }

    public Object toClass(Map<String, Class<?>> map) throws SQLException {
        Class<?> clazz;
        Object object = this;
        Map<String, Class<?>> map2 = map;
        if (map2 != null) {
            Class<?> clazz2 = this.descriptor.getClass(map2);
            if (clazz2 != null) {
                object = this.toClass(clazz2, map2);
            }
        } else if (this.conn != null && (clazz = this.descriptor.getClass(map2 = this.conn.getTypeMap())) != null) {
            object = this.toClass(clazz, map2);
        }
        return object;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    class Params
    implements ParamContainer {
        private Binder[] attributeBinders;
        private BigDecimal[] paramBigDecimal;
        private String[] paramString;
        private Timestamp[] paramTimestamp;
        private TbTimestampTZ[] paramTbTimestampTZ;
        private TbTimestamp[] paramTbTimestamp;
        private TbDate[] paramTbDate;
        private Calendar[] paramCalendar;
        private byte[][] paramBytes;
        private InputStream[] paramStream;
        private Reader[] paramReader;
        private Struct[] paramStruct;
        private Array[] paramArray;

        Params() {
        }

        @Override
        public BindData getBindData() {
            return null;
        }

        @Override
        public Binder[][] getBinder() {
            return null;
        }

        @Override
        public Binder getBinder(int n, int n2) {
            return this.attributeBinders[n2];
        }

        @Override
        public int getParameterCnt() {
            return 1;
        }

        @Override
        public byte getParamType(int n, int n2) {
            return 0;
        }

        @Override
        public byte[][] getParamTypes() {
            return null;
        }

        @Override
        public byte[] getParamTypesOfRow(int n) {
            return null;
        }

        @Override
        public Array getParamArray(int n, int n2) {
            return this.paramArray[n2];
        }

        @Override
        public Array[] getParamArrayOfRow(int n) {
            return null;
        }

        @Override
        public BigDecimal getParamBigDecimal(int n, int n2) {
            return this.paramBigDecimal[n2];
        }

        @Override
        public BigDecimal[] getParamBigDecimalOfRow(int n) {
            return null;
        }

        @Override
        public byte[] getParamBytes(int n, int n2) {
            return this.paramBytes[n2];
        }

        @Override
        public byte[][] getParamBytesOfRow(int n) {
            return null;
        }

        @Override
        public Calendar getParamCalendar(int n, int n2) {
            return this.paramCalendar[n2];
        }

        @Override
        public Calendar[] getParamCalendarOfRow(int n) {
            return null;
        }

        @Override
        public double getParamDouble(int n, int n2) {
            return 0.0;
        }

        @Override
        public double[] getParamDoubleOfRow(int n) {
            return null;
        }

        @Override
        public float getParamFloat(int n, int n2) {
            return 0.0f;
        }

        @Override
        public float[] getParamFloatOfRow(int n) {
            return null;
        }

        @Override
        public int getParamInt(int n, int n2) {
            return 0;
        }

        @Override
        public int[] getParamIntOfRow(int n) {
            return null;
        }

        @Override
        public long getParamLong(int n, int n2) {
            return 0L;
        }

        @Override
        public long[] getParamLongOfRow(int n) {
            return null;
        }

        @Override
        public Reader getParamReader(int n, int n2) {
            return this.paramReader[n2];
        }

        @Override
        public Reader[] getParamReaderOfRow(int n) {
            return null;
        }

        @Override
        public InputStream getParamStream(int n, int n2) {
            return this.paramStream[n2];
        }

        @Override
        public InputStream[] getParamStreamOfRow(int n) {
            return null;
        }

        @Override
        public String getParamString(int n, int n2) {
            return this.paramString[n2];
        }

        @Override
        public String[] getParamStringOfRow(int n) {
            return null;
        }

        @Override
        public Struct getParamStruct(int n, int n2) {
            return this.paramStruct[n2];
        }

        @Override
        public Struct[] getParamStructOfRow(int n) {
            return null;
        }

        @Override
        public TbDate getParamTbDate(int n, int n2) {
            return this.paramTbDate[n2];
        }

        @Override
        public TbDate[] getParamTbDateOfRow(int n) {
            return null;
        }

        @Override
        public TbTimestamp getParamTbTimestamp(int n, int n2) {
            return this.paramTbTimestamp[n2];
        }

        @Override
        public TbTimestamp[] getParamTbTimestampOfRow(int n) {
            return null;
        }

        @Override
        public TbTimestampTZ getParamTbTimestampTZ(int n, int n2) {
            return this.paramTbTimestampTZ[n2];
        }

        @Override
        public TbTimestampTZ[] getParamTbTimestampTZOfRow(int n) {
            return null;
        }

        @Override
        public Timestamp getParamTimestamp(int n, int n2) {
            return this.paramTimestamp[n2];
        }

        @Override
        public Timestamp[] getParamTimestampOfRow(int n) {
            return null;
        }

        static /* synthetic */ Binder[] access$002(Params params, Binder[] binderArray) {
            params.attributeBinders = binderArray;
            return binderArray;
        }

        static /* synthetic */ BigDecimal[] access$102(Params params, BigDecimal[] bigDecimalArray) {
            params.paramBigDecimal = bigDecimalArray;
            return bigDecimalArray;
        }

        static /* synthetic */ String[] access$202(Params params, String[] stringArray) {
            params.paramString = stringArray;
            return stringArray;
        }

        static /* synthetic */ byte[][] access$302(Params params, byte[][] byArray) {
            params.paramBytes = byArray;
            return byArray;
        }

        static /* synthetic */ Calendar[] access$402(Params params, Calendar[] calendarArray) {
            params.paramCalendar = calendarArray;
            return calendarArray;
        }

        static /* synthetic */ TbDate[] access$502(Params params, TbDate[] tbDateArray) {
            params.paramTbDate = tbDateArray;
            return tbDateArray;
        }

        static /* synthetic */ Timestamp[] access$602(Params params, Timestamp[] timestampArray) {
            params.paramTimestamp = timestampArray;
            return timestampArray;
        }

        static /* synthetic */ TbTimestamp[] access$702(Params params, TbTimestamp[] tbTimestampArray) {
            params.paramTbTimestamp = tbTimestampArray;
            return tbTimestampArray;
        }

        static /* synthetic */ Array[] access$802(Params params, Array[] arrayArray) {
            params.paramArray = arrayArray;
            return arrayArray;
        }

        static /* synthetic */ Struct[] access$902(Params params, Struct[] structArray) {
            params.paramStruct = structArray;
            return structArray;
        }
    }
}

