/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbKeepAlivePollingThread;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class TbKeepAlive {
    private static final int FIELD_OFFSET__MSG_TYPE = 0;
    private static final int FIELD_LEN__MSG_TYPE = 4;
    private static final int FIELD_OFFSET__BODY_SIZE = 4;
    private static final int FIELD_LEN__BODY_SIZE = 4;
    private static final int FIELD_OFFSET_FROM_END__MTHR_PID = 16;
    private static final int FIELD_LEN__MTHR_PID = 4;
    private static final int BUFFER_SIZE = 256;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_SVR_IS_ALIVE = 1;
    public static final int STATE_REPLY_NOT_FINISHED = 2;
    public static final int STATE_NO_REPLY = 3;
    public static final int STATE_REPLY_FROM_WRONG_SVR = 4;
    public static final int STATE_CHECK_FAILED = 5;
    private Socket socket;
    private int svrIntanceIdFromMthrPid;
    private SocketAddress address;
    private SocketChannel channel;
    private int replyMsgBodySize;
    private int tryCount;
    private long baseTime;
    private ByteBuffer buf;
    private int maxRetryCount;
    private long idleMillis;
    private long intervalMillis;
    private String connNameForLog;
    private boolean registered = false;
    private static final TbKeepAlivePollingThread pollingThread = new TbKeepAlivePollingThread();

    public static TbKeepAlive register(Socket socket, long l, long l2, int n, int n2, String string) {
        Debug.logMethod("TbKeepAlive.register", new String[]{"socket", "idleTimeMillis", "intervalTimeMillis", "maxRetryCount"}, new Object[]{socket, new Long(l), new Long(l2), new Integer(n)});
        TbKeepAlive tbKeepAlive = new TbKeepAlive(socket, l, l2, n, n2, string);
        pollingThread.add(tbKeepAlive);
        tbKeepAlive.registered = true;
        return tbKeepAlive;
    }

    public static void register(TbKeepAlive tbKeepAlive) {
        Debug.logMethod("TbKeepAlive.register", new String[]{"keepAlive"}, new Object[]{tbKeepAlive});
        pollingThread.add(tbKeepAlive);
        tbKeepAlive.registered = true;
    }

    public static void unregister(TbKeepAlive tbKeepAlive) {
        Debug.logMethod("TbKeepAlive.unregister", new String[]{"keepAlive"}, new Object[]{tbKeepAlive});
        pollingThread.remove(tbKeepAlive);
        tbKeepAlive.registered = false;
    }

    TbKeepAlive(Socket socket, long l, long l2, int n, int n2, String string) {
        this.socket = socket;
        this.address = socket.getRemoteSocketAddress();
        this.baseTime = System.currentTimeMillis();
        this.channel = null;
        this.replyMsgBodySize = -1;
        this.tryCount = 0;
        this.idleMillis = l;
        this.intervalMillis = l2;
        this.maxRetryCount = n;
        this.svrIntanceIdFromMthrPid = n2 >> 16;
        this.connNameForLog = string;
        this.buf = ByteBuffer.allocate(256);
    }

    void resetBaseTime() {
        this.baseTime = System.currentTimeMillis();
        this.tryCount = 0;
    }

    synchronized SocketChannel getChannel() {
        if (this.registered) {
            return this.channel;
        }
        return null;
    }

    synchronized void closeCheckChannel(int n) {
        Debug.logMethod("TbKeepAlive.closeCheckChannel", new String[]{"TbKeepAlive", "state"}, new Object[]{this, new Integer(n)});
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.channel = null;
        }
    }

    void closeOrgConnSocket(int n) {
        Debug.logMethod("TbKeepAlive.closeOrgConnSocket", new Object[]{this, new Integer(n), this.connNameForLog});
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void tryConnect() throws IOException {
        Debug.logMethod("TbKeepAlive.tryConnect", new Object[]{this, this.connNameForLog});
        if (this.registered && !this.socket.isClosed()) {
            ++this.tryCount;
            this.buf.position(0);
            this.replyMsgBodySize = -1;
            this.baseTime = System.currentTimeMillis();
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.connect(this.address);
        } else {
            Debug.log("Keep alive connection open failed. Socket is already closed.");
        }
    }

    synchronized int checkReply() throws IOException {
        if (!this.registered) {
            return 1;
        }
        this.channel.read(this.buf);
        if (this.replyMsgBodySize < 0) {
            if (this.buf.position() < 16) {
                return 2;
            }
            if (0 != TbCommon.bytes2Int(this.buf.array(), 0, 4)) {
                return 4;
            }
            this.replyMsgBodySize = TbCommon.bytes2Int(this.buf.array(), 4, 4);
        }
        if (this.replyMsgBodySize > 0 && this.buf.position() >= 16 + this.replyMsgBodySize - 16 + 4) {
            int n = TbCommon.bytes2Int(this.buf.array(), 16 + this.replyMsgBodySize - 16, 4) >> 16;
            Debug.log("svrMthrPid=" + this.svrIntanceIdFromMthrPid + ", instIdFromMthrPid=" + n);
            if (this.svrIntanceIdFromMthrPid == n) {
                return 1;
            }
            return 4;
        }
        return 2;
    }

    long getBaseTime() {
        return this.baseTime;
    }

    int getTryCount() {
        return this.tryCount;
    }

    long getIdleMillis() {
        return this.idleMillis;
    }

    long getIntervalMillis() {
        return this.intervalMillis;
    }

    int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    String getTargetAddressWithSvrInstId() {
        return String.valueOf(this.address) + ":" + this.svrIntanceIdFromMthrPid;
    }
}

