/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.driver.TbRSFwOnly;
import com.tmax.tibero.jdbc.driver.TbRSScrollable;
import com.tmax.tibero.jdbc.driver.TbRSSensitive;
import com.tmax.tibero.jdbc.driver.TbRSUpdatable;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class TbResultSetFactory {
    public static TbResultSet buildResultSet(TbStatement tbStatement, int n, int n2, int n3) throws SQLException {
        if (tbStatement == null) {
            throw TbError.newSQLException(-90608);
        }
        RsetType rsetType = tbStatement.getRealRsetType();
        Debug.logReturn("TbResultSetFactory.buildResultSet", rsetType);
        switch (rsetType.getRank()) {
            case 2: {
                TbRSFwOnly tbRSFwOnly = new TbRSFwOnly(tbStatement, n, n2, n3);
                return new TbRSUpdatable(tbRSFwOnly, RsetType.FWUP);
            }
            case 3: {
                return new TbRSScrollable(tbStatement, n, n2, n3);
            }
            case 4: {
                TbRSScrollable tbRSScrollable = new TbRSScrollable(tbStatement, n, n2, n3);
                return new TbRSUpdatable(tbRSScrollable, RsetType.SIUP);
            }
            case 5: {
                return new TbRSSensitive(tbStatement, n, n2, n3);
            }
            case 6: {
                TbRSSensitive tbRSSensitive = new TbRSSensitive(tbStatement, n, n2, n3);
                return new TbRSUpdatable(tbRSSensitive, RsetType.SSUP);
            }
        }
        return new TbRSFwOnly(tbStatement, n, n2, n3);
    }

    public static TbResultSet buildEmptyResultSet(TbStatement tbStatement, int n, int n2, int n3) throws SQLException {
        Debug.logMethod("TbResultSetFactory.buildEmptyResultSet", new Object[]{tbStatement, Integer.toString(n), Integer.toString(n2), Integer.toString(n3)});
        return new TbRSFwOnly(tbStatement, n, n2, n3);
    }

    private TbResultSetFactory() {
    }
}

