/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class CharToByteDoubleByte {
    protected static final char MIN_HIGH = '\ud800';
    protected static final char MAX_HIGH = '\udbff';
    protected static final char MIN_LOW = '\udc00';
    protected static final char MAX_LOW = '\udfff';
    protected static final char MIN = '\ud800';
    protected static final char MAX = '\udfff';
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    protected short[] index1;
    protected String[] index2;
    protected final int MAX_BYTE_SIZE = 2;

    public boolean canConvert(char c) throws SQLException {
        byte[] byArray = new byte[2];
        if (c == '\u0000' || this.convSingleByte(c, byArray) != 0) {
            return true;
        }
        return this.convDoubleByte(c) != 0;
    }

    private void checkOverflow(int n, int n2, int n3) throws SQLException {
        if (n + n2 > n3) {
            throw TbError.newSQLException(-590744, n + " + " + n2 + " > " + n3);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int convCharArr(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5;
        int n6 = 0;
        int n7 = 0;
        char c = '\u0000';
        byte[] byArray2 = new byte[2];
        n6 = n;
        n7 = n3;
        if (c != '\u0000') {
            c = '\u0000';
            if (cArray[n] < '\udc00' || cArray[n] > '\udfff') throw TbError.newSQLException(-590743, (int)cArray[n]);
            if (!this.subMode) throw TbError.newSQLException(-590742, (int)cArray[n]);
            n5 = this.subBytes.length;
            if (n7 + n5 > n4) {
                throw TbError.newSQLException(-590744, n7 + " + " + n5 + " > " + n4);
            }
            for (int i = 0; i < this.subBytes.length; ++i) {
                byArray[n7++] = this.subBytes[i];
            }
            ++n6;
        }
        while (n6 < n2) {
            int n8;
            int n9;
            n5 = 1;
            byte[] byArray3 = byArray2;
            char c2 = cArray[n6];
            if (c2 >= '\ud800' && c2 <= '\udbff') {
                if (n6 + 1 >= n2) {
                    c = c2;
                    return n7 - n3;
                }
                c2 = cArray[n6 + 1];
                if (c2 < '\udc00' || c2 > '\udfff') throw TbError.newSQLException(-590743, (int)c2);
                if (!this.subMode) throw TbError.newSQLException(-590742, (int)c2);
                byArray3 = this.subBytes;
                n9 = this.subBytes.length;
                n5 = 2;
            } else {
                if (c2 >= '\udc00' && c2 <= '\udfff') {
                    throw TbError.newSQLException(-590743, (int)c2);
                }
                n9 = this.convSingleByte(c2, byArray3);
                if (n9 == 0) {
                    n8 = this.convDoubleByte(c2);
                    if (n8 != 0) {
                        byArray3[0] = (byte)((n8 & 0xFF00) >> 8);
                        byArray3[1] = (byte)(n8 & 0xFF);
                        n9 = 2;
                    } else {
                        if (!this.subMode) throw TbError.newSQLException(-590742, (int)c2);
                        byArray3 = this.subBytes;
                        n9 = this.subBytes.length;
                    }
                }
            }
            if (n7 + n9 > n4) {
                throw TbError.newSQLException(-590744, n7 + " + " + n9 + " > " + n4);
            }
            for (n8 = 0; n8 < n9; ++n8) {
                byArray[n7++] = byArray3[n8];
            }
            n6 += n5;
        }
        return n7 - n3;
    }

    protected int convSingleByte(char c, byte[] byArray) {
        if (c < '\u0080') {
            byArray[0] = (byte)(c & 0x7F);
            return 1;
        }
        return 0;
    }

    protected int convSingleByte(char c) {
        return c < '\u0080' ? 1 : 0;
    }

    public int convString(String string, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.convCharArr(string.toCharArray(), n, n2, byArray, n3, n4);
    }

    public short[] getIndex1() {
        return this.index1;
    }

    public String[] getIndex2() {
        return this.index2;
    }

    public int getMaxBytesPerChar() {
        return 2;
    }

    protected int convDoubleByte(char c) throws SQLException {
        try {
            int n = this.index1[(c & 0xFF00) >> 8] << 8;
            return this.index2[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw TbError.newSQLException(-590743, arrayIndexOutOfBoundsException.getMessage());
        }
    }

    protected int parse(char c, char[] cArray, int n, int n2) throws SQLException {
        if (this.isHigh(c)) {
            if (n2 - n < 2) {
                throw TbError.newSQLException(-590714, "Malformed input");
            }
            char c2 = cArray[n + 1];
            if (this.isLow(c2)) {
                return this.toUCS4(c, c2);
            }
            throw TbError.newSQLException(-590714, "Malformed input");
        }
        if (this.isLow(c)) {
            throw TbError.newSQLException(-590714, "Malformed input");
        }
        return c;
    }

    private boolean isHigh(int n) {
        return 55296 <= n && n <= 56319;
    }

    private boolean isLow(int n) {
        return 56320 <= n && n <= 57343;
    }

    public int toUCS4(char c, char c2) {
        return ((c & 0x3FF) << 10 | c2 & 0x3FF) + 65536;
    }
}

