/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbArrayDescriptor;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.DummyArrayDescriptor;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbArray
implements Array,
ParamContainer {
    private TbConnection conn;
    private TbArrayDescriptor descriptor;
    private int baseType;
    private Object[] elements;
    private Binder[] elementBinders;
    private int[] paramInt;
    private long[] paramLong;
    private float[] paramFloat;
    private double[] paramDouble;
    private BigDecimal[] paramBigDecimal;
    private String[] paramString;
    private Timestamp[] paramTimestamp;
    private TbTimestampTZ[] paramTbTimestampTZ;
    private TbTimestamp[] paramTbTimestamp;
    private TbDate[] paramTbDate;
    private Calendar[] paramCalendar;
    private byte[][] paramBytes;
    private InputStream[] paramStream;
    private Reader[] paramReader;
    private Struct[] paramStruct;
    private Array[] paramArray;

    public TbArray(TbArrayDescriptor tbArrayDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        if (tbArrayDescriptor == null) {
            throw TbError.newSQLException(-90608, "desc=null");
        }
        if (connection == null) {
            throw TbError.newSQLException(-90608, "conn=null");
        }
        this.descriptor = tbArrayDescriptor;
        this.baseType = tbArrayDescriptor.getBaseType();
        this.conn = (TbConnection)connection;
        this.elements = objectArray;
        this.initSubParams(tbArrayDescriptor.getElementType(), objectArray);
    }

    private void initSubParams(int n, Object[] objectArray) throws SQLException {
        int n2 = objectArray == null ? 0 : objectArray.length;
        this.elementBinders = new Binder[n2];
        switch (n) {
            case 1: {
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof Short) {
                        if (this.paramInt == null) {
                            this.paramInt = new int[n2];
                        }
                        this.paramInt[i] = ((Short)objectArray[i]).intValue();
                        this.elementBinders[i] = StaticBinder.getIntBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof Integer) {
                        if (this.paramInt == null) {
                            this.paramInt = new int[n2];
                        }
                        this.paramInt[i] = (Integer)objectArray[i];
                        this.elementBinders[i] = StaticBinder.getIntBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof Long) {
                        if (this.paramLong == null) {
                            this.paramLong = new long[n2];
                        }
                        this.paramLong[i] = (Long)objectArray[i];
                        this.elementBinders[i] = StaticBinder.getLongBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof BigInteger) {
                        if (this.paramBigDecimal == null) {
                            this.paramBigDecimal = new BigDecimal[n2];
                        }
                        this.paramBigDecimal[i] = new BigDecimal((BigInteger)objectArray[i]);
                        this.elementBinders[i] = StaticBinder.getBigDecimalBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof BigDecimal) {
                        if (this.paramBigDecimal == null) {
                            this.paramBigDecimal = new BigDecimal[n2];
                        }
                        this.paramBigDecimal[i] = (BigDecimal)objectArray[i];
                        this.elementBinders[i] = StaticBinder.getBigDecimalBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof Float) {
                        if (this.paramFloat == null) {
                            this.paramFloat = new float[n2];
                        }
                        this.paramFloat[i] = ((Float)objectArray[i]).floatValue();
                        this.elementBinders[i] = StaticBinder.getFloatBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof Double) {
                        if (this.paramDouble == null) {
                            this.paramDouble = new double[n2];
                        }
                        this.paramDouble[i] = (Double)objectArray[i];
                        this.elementBinders[i] = StaticBinder.getDoubleBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof String) {
                        if (this.paramBigDecimal == null) {
                            this.paramBigDecimal = new BigDecimal[n2];
                        }
                        this.paramBigDecimal[i] = new BigDecimal((String)objectArray[i]);
                        this.elementBinders[i] = StaticBinder.getBigDecimalBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof Boolean) {
                        if (this.paramBigDecimal == null) {
                            this.paramBigDecimal = new BigDecimal[n2];
                        }
                        this.paramBigDecimal[i] = new BigDecimal((Boolean)objectArray[i] != false ? 1.0 : 0.0);
                        this.elementBinders[i] = StaticBinder.getBigDecimalBinder();
                        continue;
                    }
                    String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray[i];
                    throw TbError.newSQLException(-90651, string);
                }
                break;
            }
            case 2: 
            case 3: 
            case 10: {
                if (this.paramString == null) {
                    this.paramString = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.elementBinders[i] = StaticBinder.getStringBinder();
                    this.paramString[i] = objectArray[i] instanceof Boolean ? ((Boolean)objectArray[i] != false ? "1" : "0") : objectArray[i].toString();
                }
                break;
            }
            case 18: 
            case 19: {
                if (this.paramString == null) {
                    this.paramString = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.elementBinders[i] = StaticBinder.getNStringBinder();
                    this.paramString[i] = objectArray[i] instanceof Boolean ? ((Boolean)objectArray[i] != false ? "1" : "0") : objectArray[i].toString();
                }
                break;
            }
            case 4: {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[n2][];
                }
                for (int i = 0; i < n2; ++i) {
                    this.elementBinders[i] = StaticBinder.getBytesBinder();
                    if (!(objectArray[i] instanceof byte[])) {
                        String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray[i];
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.paramBytes[i] = (byte[])objectArray[i];
                }
                break;
            }
            case 5: {
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n2];
                        }
                        object = Calendar.getInstance(((TbTimestampTZ)objectArray[i]).getTimeZone());
                        ((Calendar)object).setTime((TbTimestampTZ)objectArray[i]);
                        this.paramCalendar[i] = object;
                        this.elementBinders[i] = StaticBinder.getDateBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof TbTimestamp) {
                        if (this.paramTbDate == null) {
                            this.paramTbDate = new TbDate[n2];
                        }
                        object = (TbTimestamp)objectArray[i];
                        this.paramTbDate[i] = new TbDate(((TbTimestamp)object).getYear(), ((TbTimestamp)object).getMonth(), ((TbTimestamp)object).getDayOfMonth(), ((TbTimestamp)object).getHourOfDay(), ((TbTimestamp)object).getMinutes(), ((TbTimestamp)object).getSeconds());
                        this.elementBinders[i] = StaticBinder.getTbDateBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof TbDate) {
                        if (this.paramTbDate == null) {
                            this.paramTbDate = new TbDate[n2];
                        }
                        this.paramTbDate[i] = (TbDate)objectArray[i];
                        this.elementBinders[i] = StaticBinder.getTbDateBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof Timestamp || objectArray[i] instanceof Date) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n2];
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        this.paramCalendar[i] = object;
                        this.elementBinders[i] = StaticBinder.getDateBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof String) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n2];
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime(Date.valueOf((String)objectArray[i]));
                        this.paramCalendar[i] = object;
                        this.elementBinders[i] = StaticBinder.getDateBinder();
                        continue;
                    }
                    object = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < n2; ++i) {
                    Object object;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.paramTimestamp == null) {
                            this.paramTimestamp = new Timestamp[n2];
                        }
                        this.paramTimestamp[i] = (Timestamp)objectArray[i];
                        this.elementBinders[i] = StaticBinder.getTimestampBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof TbTimestamp) {
                        if (this.paramTbTimestamp == null) {
                            this.paramTbTimestamp = new TbTimestamp[n2];
                        }
                        this.paramTbTimestamp[i] = (TbTimestamp)objectArray[i];
                        this.elementBinders[i] = StaticBinder.getTbTimestampBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof TbDate) {
                        if (this.paramTbTimestamp == null) {
                            this.paramTbTimestamp = new TbTimestamp[n2];
                        }
                        object = (TbDate)objectArray[i];
                        this.paramTbTimestamp[i] = new TbTimestamp(((TbDate)object).getYear(), ((TbDate)object).getMonth(), ((TbDate)object).getDayOfMonth(), ((TbDate)object).getHourOfDay(), ((TbDate)object).getMinutes(), ((TbDate)object).getSeconds(), 0);
                        this.elementBinders[i] = StaticBinder.getTbTimestampBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof Timestamp) {
                        if (this.paramTimestamp == null) {
                            this.paramTimestamp = new Timestamp[n2];
                        }
                        this.paramTimestamp[i] = (Timestamp)objectArray[i];
                        this.elementBinders[i] = StaticBinder.getTimestampBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof Date) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n2];
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        this.paramCalendar[i] = object;
                        this.elementBinders[i] = StaticBinder.getDateBinder();
                        continue;
                    }
                    if (objectArray[i] instanceof String) {
                        if (this.paramTimestamp == null) {
                            this.paramTimestamp = new Timestamp[n2];
                        }
                        this.paramTimestamp[i] = Timestamp.valueOf((String)objectArray[i]);
                        this.elementBinders[i] = StaticBinder.getTimestampBinder();
                        continue;
                    }
                    object = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object);
                }
                break;
            }
            case 12: 
            case 13: 
            case 20: {
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof TbLob) {
                        if (this.paramBytes == null) {
                            this.paramBytes = new byte[n2][];
                        }
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray;
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.paramBytes[i] = ((TbLob)objectArray[i]).getLocator();
                    this.elementBinders[i] = StaticBinder.getBytesBinder();
                }
                break;
            }
            case 29: 
            case 30: {
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof Array) {
                        if (this.paramArray == null) {
                            this.paramArray = new Array[n2];
                        }
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray;
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.paramArray[i] = (Array)objectArray[i];
                    this.elementBinders[i] = StaticBinder.getArrayBinder();
                }
                break;
            }
            case 28: 
            case 32: {
                for (int i = 0; i < n2; ++i) {
                    if (objectArray[i] instanceof Struct) {
                        if (this.paramStruct == null) {
                            this.paramStruct = new Struct[n2];
                        }
                    } else {
                        String string = "elementType=" + DataType.getDBTypeName(n) + ",element=" + objectArray;
                        throw TbError.newSQLException(-90651, string);
                    }
                    this.paramStruct[i] = (Struct)objectArray[i];
                    this.elementBinders[i] = StaticBinder.getStructBinder();
                }
                break;
            }
            default: {
                throw TbError.newSQLException(-590703, DataType.getDBTypeName(n));
            }
        }
    }

    public TbArrayDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void free() throws SQLException {
        this.descriptor = null;
    }

    public Object getArray() throws SQLException {
        Debug.logMethod("TbArray.getArray", new Object[0]);
        if (!(this.descriptor instanceof DummyArrayDescriptor)) {
            return this.elements;
        }
        int n = this.descriptor.getElementType();
        int n2 = this.elements == null ? 0 : this.elements.length;
        switch (n) {
            case 1: {
                BigDecimal[] bigDecimalArray = new BigDecimal[n2];
                for (int i = 0; i < n2; ++i) {
                    bigDecimalArray[i] = (BigDecimal)this.elements[i];
                }
                return bigDecimalArray;
            }
            case 2: 
            case 3: 
            case 10: 
            case 18: 
            case 19: {
                return this.paramString;
            }
            case 5: {
                if (!this.conn.info.getMapDateToTimestamp()) {
                    Date[] dateArray = new Date[n2];
                    for (int i = 0; i < n2; ++i) {
                        dateArray[i] = (Date)this.elements[i];
                    }
                    return dateArray;
                }
            }
            case 7: 
            case 21: 
            case 22: {
                Timestamp[] timestampArray = new Timestamp[n2];
                for (int i = 0; i < n2; ++i) {
                    timestampArray[i] = (Timestamp)this.elements[i];
                }
                return timestampArray;
            }
            case 4: {
                return this.paramBytes;
            }
            case 12: {
                Blob[] blobArray = new Blob[n2];
                for (int i = 0; i < n2; ++i) {
                    blobArray[i] = (Blob)this.elements[i];
                }
                return blobArray;
            }
            case 13: 
            case 20: {
                Clob[] clobArray = new Clob[n2];
                for (int i = 0; i < n2; ++i) {
                    clobArray[i] = (Clob)this.elements[i];
                }
                return clobArray;
            }
            case 32: {
                TbStruct[] tbStructArray = new TbStruct[n2];
                for (int i = 0; i < n2; ++i) {
                    tbStructArray[i] = (TbStruct)this.elements[i];
                }
                return tbStructArray;
            }
            case 29: 
            case 30: {
                TbArray[] tbArrayArray = new TbArray[n2];
                for (int i = 0; i < n2; ++i) {
                    tbArrayArray[i] = (TbArray)this.elements[i];
                }
                return tbArrayArray;
            }
        }
        return this.elements;
    }

    public Object getArray(long l, int n) throws SQLException {
        Debug.logMethod("TbArray.getArray", new Object[0]);
        throw TbError.newSQLException(-90201);
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        Debug.logMethod("TbArray.getArray", new Object[0]);
        throw TbError.newSQLException(-90201);
    }

    public Object getArray(Map map) throws SQLException {
        Debug.logMethod("TbArray.getArray", new Object[0]);
        throw TbError.newSQLException(-90201);
    }

    public int getBaseType() throws SQLException {
        return this.baseType;
    }

    public String getBaseTypeName() throws SQLException {
        return DataType.getDBTypeName(this.descriptor.getElementType());
    }

    public ResultSet getResultSet() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public int length() {
        return this.elements == null ? 0 : this.elements.length;
    }

    public BindData getBindData() {
        return null;
    }

    public Binder[][] getBinder() {
        return null;
    }

    public Binder getBinder(int n, int n2) {
        return this.elementBinders[n];
    }

    public int getParameterCnt() {
        return 1;
    }

    public byte getParamType(int n, int n2) {
        return 0;
    }

    public byte[][] getParamTypes() {
        return null;
    }

    public byte[] getParamTypesOfRow(int n) {
        return null;
    }

    public Array getParamArray(int n, int n2) {
        return this.paramArray[n];
    }

    public Array[] getParamArrayOfRow(int n) {
        return null;
    }

    public BigDecimal getParamBigDecimal(int n, int n2) {
        return this.paramBigDecimal[n];
    }

    public BigDecimal[] getParamBigDecimalOfRow(int n) {
        return null;
    }

    public byte[] getParamBytes(int n, int n2) {
        return this.paramBytes[n];
    }

    public byte[][] getParamBytesOfRow(int n) {
        return null;
    }

    public Calendar getParamCalendar(int n, int n2) {
        return this.paramCalendar[n];
    }

    public Calendar[] getParamCalendarOfRow(int n) {
        return null;
    }

    public double getParamDouble(int n, int n2) {
        return this.paramDouble[n];
    }

    public double[] getParamDoubleOfRow(int n) {
        return null;
    }

    public float getParamFloat(int n, int n2) {
        return this.paramFloat[n];
    }

    public float[] getParamFloatOfRow(int n) {
        return null;
    }

    public int getParamInt(int n, int n2) {
        return this.paramInt[n];
    }

    public int[] getParamIntOfRow(int n) {
        return null;
    }

    public long getParamLong(int n, int n2) {
        return this.paramLong[n];
    }

    public long[] getParamLongOfRow(int n) {
        return null;
    }

    public Reader getParamReader(int n, int n2) {
        return this.paramReader[n];
    }

    public Reader[] getParamReaderOfRow(int n) {
        return null;
    }

    public InputStream getParamStream(int n, int n2) {
        return this.paramStream[n];
    }

    public InputStream[] getParamStreamOfRow(int n) {
        return null;
    }

    public String getParamString(int n, int n2) {
        return this.paramString[n];
    }

    public String[] getParamStringOfRow(int n) {
        return null;
    }

    public Struct getParamStruct(int n, int n2) {
        return this.paramStruct[n];
    }

    public Struct[] getParamStructOfRow(int n) {
        return null;
    }

    public TbDate getParamTbDate(int n, int n2) {
        return this.paramTbDate[n];
    }

    public TbDate[] getParamTbDateOfRow(int n) {
        return null;
    }

    public TbTimestamp getParamTbTimestamp(int n, int n2) {
        return this.paramTbTimestamp[n];
    }

    public TbTimestamp[] getParamTbTimestampOfRow(int n) {
        return null;
    }

    public TbTimestampTZ getParamTbTimestampTZ(int n, int n2) {
        return this.paramTbTimestampTZ[n];
    }

    public TbTimestampTZ[] getParamTbTimestampTZOfRow(int n) {
        return null;
    }

    public Timestamp getParamTimestamp(int n, int n2) {
        return this.paramTimestamp[n];
    }

    public Timestamp[] getParamTimestampOfRow(int n) {
        return null;
    }
}

