/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLInfo2;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.TbStatement;
import com.tmax.tibero.jdbc.TbTypeDescriptor;
import com.tmax.tibero.jdbc.comm.TbBlobAccessor;
import com.tmax.tibero.jdbc.comm.TbClobAccessor;
import com.tmax.tibero.jdbc.comm.TbComm;
import com.tmax.tibero.jdbc.comm.TbCommType4;
import com.tmax.tibero.jdbc.comm.TbXAComm;
import com.tmax.tibero.jdbc.comm.TbXACommType4;
import com.tmax.tibero.jdbc.data.ConnectionInfo;
import com.tmax.tibero.jdbc.data.DataTypeConverter;
import com.tmax.tibero.jdbc.data.ExtFeatureInfo;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.driver.TbCallableStatement;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbSavepoint;
import com.tmax.tibero.jdbc.driver.TbTimeout;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbStatementCache;
import com.tmax.tibero.jdbc.util.TbDTFormat;
import com.tmax.tibero.jdbc.util.TbDTFormatParser;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class TbConnection
extends com.tmax.tibero.jdbc.TbConnection {
    public static final String CLIENT_INFO_IDENTIFIER = "client_identifier";
    public static final String[] CLIENT_INFO_KEYS = new String[]{"client_identifier"};
    private TbComm dbComm;
    public ConnectionInfo info;
    protected boolean isPooledConnection;
    public ServerInfo serverInfo;
    private String sessKey;
    protected DataTypeConverter typeConverter;
    protected SQLWarning warnings;
    protected boolean autoCommit;
    protected boolean connClosed;
    protected boolean sessionClosed;
    protected TbDatabaseMetaData dbMetaData = null;
    protected Map<String, Class<?>> typeMap;
    protected Map<String, TbTypeDescriptor> descriptorMap;
    private String nlsDate = null;
    private String nlsTimestamp = null;
    private boolean nlsWarning = false;
    private int sessionId;
    private int serialNo;
    private int mthrPid = -1;
    private int txnMode;
    private boolean readOnly;
    protected int isolationLevel = 2;
    private TbTimeout timeout;
    private int preFetchSize = 64000;
    private TbStatementCache stmtCache = null;
    public String[] clientInfo;
    private boolean middleOfFailover;
    private boolean reconnected;
    private long waitingTime;
    private boolean checkWaitingTimer = false;
    private int maxDFRCharCount = 0;
    private int maxDFRNCharCount = 0;
    private ExtFeatureInfo efInfo;
    private TbDTFormat parsedNlsDateFormat = null;
    private TbDTFormat parsedNlsTimestampFormat = null;

    public void activateTimer() {
        this.checkWaitingTimer = true;
    }

    public void addWaitingTime(long l) {
        this.waitingTime += l;
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings != null) {
            this.warnings.setNextWarning(sQLWarning);
        } else {
            this.warnings = sQLWarning;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            if (this.dbComm != null) {
                this.dbComm.close();
                this.dbComm = null;
            }
            this.connClosed = true;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public synchronized void closeCursor(TbResultSet tbResultSet, int n) throws SQLException {
        this.dbComm.closeCursor(tbResultSet, n);
    }

    @Deprecated
    public synchronized void closeSession() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized void commit() throws SQLException {
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw TbError.newSQLException(-90603);
        }
        this.dbComm.commit();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.createTbBlob();
    }

    @Override
    public TbBlob createTbBlob() throws SQLException {
        byte[] byArray = this.getBlobAccessor().createTemporaryBlob();
        return new TbBlob(this, byArray, false);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.createTbClob();
    }

    @Override
    public TbClob createTbClob() throws SQLException {
        byte[] byArray = this.getClobAccessor().createTemporaryClob();
        return new TbClob(this, byArray, false);
    }

    @Override
    public TbDirPathStream createDirPathStream(TbDirPathMetaData tbDirPathMetaData) throws SQLException {
        return new TbDirPathStream(this, tbDirPathMetaData);
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.createTbNClob();
    }

    @Override
    public TbNClob createTbNClob() throws SQLException {
        byte[] byArray = this.getClobAccessor().createTemporaryNClob();
        return new TbNClob(this, byArray, false);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return new TbSQLXML(this);
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        TbStatement tbStatement;
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (tbStatement = this.stmtCache.get(null, 0, RsetType.getRsetType(n, n2))) != null) {
            return tbStatement;
        }
        return new com.tmax.tibero.jdbc.driver.TbStatement(this, n, n2, this.preFetchSize);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        TbStatement tbStatement;
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (n3 != this.getHoldability()) {
            this.addWarning(new SQLWarning(TbError.getMsg(-90660), TbError.getSQLState(-90660)));
        }
        if (this.stmtCache != null && (tbStatement = this.stmtCache.get(null, 0, RsetType.getRsetType(n, n2))) != null) {
            return tbStatement;
        }
        tbStatement = new com.tmax.tibero.jdbc.driver.TbStatement(this, n, n2, this.preFetchSize);
        return tbStatement;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void disableStmtCache() {
        this.info.setStmtCache(false);
    }

    void disallowGlobalTxnMode(int n) throws SQLException {
        if (this.txnMode == 2) {
            throw TbError.newSQLException(n);
        }
    }

    public void enableStmtCache() {
        this.info.setStmtCache(true);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public TbBlobAccessor getBlobAccessor() {
        return (TbBlobAccessor)((Object)this.dbComm);
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    public boolean getIncludeSynonyms() {
        return this.info.getIncludeSynonyms();
    }

    public boolean getMapDateToTimestamp() {
        return this.info.getMapDateToTimestamp();
    }

    public void setIncludeSynonyms(boolean bl) {
        this.info.setIncludeSynonyms(bl);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.clientInfo == null) {
            return null;
        }
        Properties properties = new Properties();
        for (int i = 0; i < CLIENT_INFO_KEYS.length; ++i) {
            properties.put(CLIENT_INFO_KEYS[i], this.clientInfo[i]);
        }
        return properties;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (this.clientInfo == null) {
            return null;
        }
        for (int i = 0; i < CLIENT_INFO_KEYS.length; ++i) {
            if (!CLIENT_INFO_KEYS[i].equals(string)) continue;
            return this.clientInfo[i];
        }
        return null;
    }

    public TbClobAccessor getClobAccessor() {
        return (TbClobAccessor)((Object)this.dbComm);
    }

    public int getDefaultRowPrefetch() {
        return this.preFetchSize;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        return this.dbComm.getLastExecutedSqlinfo();
    }

    public TbSQLInfo2 getLastExecutedSqlinfo2() throws SQLException {
        return this.dbComm.getLastExecutedSqlinfo2();
    }

    public int getMaxDFRCharCount() {
        return this.maxDFRCharCount;
    }

    public int getMaxDFRNCharCount() {
        return this.maxDFRNCharCount;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        this.dbMetaData = new TbDatabaseMetaData(this);
        return this.dbMetaData;
    }

    public int getMthrPid() {
        return this.mthrPid;
    }

    @Override
    public String getNlsDate() {
        return this.nlsDate;
    }

    @Override
    public String getNlsTimestamp() {
        return this.nlsTimestamp;
    }

    @Override
    public int getSerialNo() {
        return this.serialNo;
    }

    @Override
    public int getServerCharSet() {
        return this.serverInfo.getServerCharSet();
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public String getSessKey() {
        return this.sessKey;
    }

    @Override
    public int getServerNCharSet() {
        return this.serverInfo.getServerNCharSet();
    }

    @Override
    public int getSessionId() {
        return this.sessionId;
    }

    public TbStatementCache getStmtCache() {
        return this.stmtCache;
    }

    public TbComm getTbComm() {
        return this.dbComm;
    }

    public TbXAComm getTbXAComm() {
        return (TbXAComm)((Object)this.dbComm);
    }

    public TbTimeout getTimeout() throws SQLException {
        if (this.timeout == null) {
            this.timeout = TbTimeout.newTimeout();
        }
        return this.timeout;
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        return this.isolationLevel;
    }

    public int getTxnMode() {
        return this.txnMode;
    }

    public DataTypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.typeMap;
    }

    public long getWaitingTime() {
        return this.waitingTime;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    public boolean isActivatedTimer() {
        return this.checkWaitingTimer;
    }

    @Override
    public boolean isClosed() {
        return this.connClosed;
    }

    public boolean isMiddleOfFailover() {
        return this.middleOfFailover;
    }

    @Override
    public boolean isPooledConnection() {
        return this.isPooledConnection;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public boolean isReconnected() {
        return this.reconnected;
    }

    @Override
    public boolean isSessionClosed() {
        return this.sessionClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int n) throws SQLException {
        if (this.isClosed()) {
            return false;
        }
        Statement statement = null;
        statement = this.createStatement();
        ((com.tmax.tibero.jdbc.driver.TbStatement)statement).setQueryTimeout(n);
        try {
            statement.execute("SELECT 1 FROM DUAL");
        }
        catch (SQLException sQLException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return true;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        return null;
    }

    public void openConnection(ConnectionInfo connectionInfo, boolean bl) throws SQLException {
        String string;
        this.reuse();
        this.typeMap = new HashMap();
        this.descriptorMap = new HashMap<String, TbTypeDescriptor>();
        this.info = (ConnectionInfo)connectionInfo.clone();
        this.typeConverter = new DataTypeConverter(this);
        if (this.info.isStmtCache()) {
            this.stmtCache = new TbStatementCache(this.info.getStmtCacheMaxSize());
        }
        if ((string = this.info.getDriverType()).equals("thin")) {
            this.dbComm = this.info.isXA() ? new TbXACommType4(this) : new TbCommType4(this);
        } else {
            throw TbError.newSQLException(-590723, string);
        }
        this.dbComm.createStream();
        this.dbComm.getStream().setSelfKeepAliveEnabled(false);
        if (this.info.isInternal()) {
            this.dbComm.describeConnectInfo();
            this.dbComm.describeSessInfo();
            this.setAutoCommit(false);
        } else {
            try {
                this.dbComm.logon(bl);
            }
            catch (SQLException sQLException) {
                if (!this.sessionClosed && !this.connClosed) {
                    return;
                }
                throw sQLException;
            }
        }
        this.dbComm.getStream().setSelfKeepAliveEnabled(this.info.useSelfKeepAlive());
        this.dbComm.getStream().setSoTimeout(this.info.getReadTimeout());
        this.sessionClosed = false;
        this.connClosed = false;
        this.efInfo = new ExtFeatureInfo(this);
        if (this.middleOfFailover) {
            this.reconnected = true;
        }
    }

    @Deprecated
    public void openSession() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        TbStatement tbStatement;
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (tbStatement = this.stmtCache.get(string, 2, RsetType.getRsetType(n, n2))) instanceof TbCallableStatement) {
            return (TbCallableStatement)tbStatement;
        }
        return new TbCallableStatement(this, string, n, n2, this.preFetchSize);
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        TbStatement tbStatement;
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (tbStatement = this.stmtCache.get(string, 2, RsetType.getRsetType(n, n2))) instanceof TbCallableStatement) {
            return (TbCallableStatement)tbStatement;
        }
        if (n3 != this.getHoldability()) {
            this.addWarning(new SQLWarning(TbError.getMsg(-90660), TbError.getSQLState(-90660)));
        }
        return new TbCallableStatement(this, string, n, n2, this.preFetchSize);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, false);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, bl);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        TbPreparedStatement tbPreparedStatement = (TbPreparedStatement)this.prepareStatement(string);
        if (36 == tbPreparedStatement.getSqlType()) {
            tbPreparedStatement.setReturnAutoGeneratedKeys(n == 1);
        }
        return tbPreparedStatement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, false);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, boolean bl) throws SQLException {
        TbStatement tbStatement;
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (tbStatement = this.stmtCache.get(string, 1, RsetType.getRsetType(n, n2))) instanceof TbPreparedStatement) {
            return (TbPreparedStatement)tbStatement;
        }
        return new TbPreparedStatement(this, string, n, n2, this.preFetchSize, bl);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        TbStatement tbStatement;
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        if (this.stmtCache != null && (tbStatement = this.stmtCache.get(string, 1, RsetType.getRsetType(n, n2))) instanceof TbPreparedStatement) {
            return (TbPreparedStatement)tbStatement;
        }
        if (n3 != this.getHoldability()) {
            this.addWarning(new SQLWarning(TbError.getMsg(-90660), TbError.getSQLState(-90660)));
        }
        return new TbPreparedStatement(this, string, n, n2, this.preFetchSize, false);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        TbPreparedStatement tbPreparedStatement;
        if (nArray == null || nArray.length == 0) {
            TbError.newSQLException(-590732);
        }
        if (36 == (tbPreparedStatement = (TbPreparedStatement)this.prepareStatement(string)).getSqlType()) {
            tbPreparedStatement.setReturnAutoGeneratedKeys(true);
            tbPreparedStatement.setAutoGenKeyArr(nArray);
        }
        return tbPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        TbPreparedStatement tbPreparedStatement;
        if (stringArray == null || stringArray.length == 0) {
            TbError.newSQLException(-590732);
        }
        if (36 == (tbPreparedStatement = (TbPreparedStatement)this.prepareStatement(string)).getSqlType()) {
            tbPreparedStatement.setReturnAutoGeneratedKeys(true);
            tbPreparedStatement.setAutoGenKeyArr(stringArray);
        }
        return tbPreparedStatement;
    }

    public void reconnect() {
        if (this.info.isFailOver()) {
            boolean bl = true;
            ConnectionInfo connectionInfo = this.info;
            this.setMiddleOfFailover(true);
            try {
                bl = this.getAutoCommit();
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                this.openConnection(connectionInfo, false);
                this.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                if (!this.isReconnected()) {
                    try {
                        this.close();
                    }
                    catch (SQLException sQLException2) {}
                }
                try {
                    this.setAutoCommit(bl);
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
                this.setReconnected(false);
            }
            this.setMiddleOfFailover(false);
        } else {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void reset() {
        this.info = null;
        this.serverInfo = null;
        this.sessKey = null;
        this.warnings = null;
        this.dbMetaData = null;
        this.typeMap = null;
        this.descriptorMap = null;
        this.autoCommit = true;
        this.sessionClosed = true;
        this.txnMode = 0;
        this.readOnly = false;
        this.isolationLevel = 2;
        this.nlsDate = null;
        this.nlsTimestamp = null;
        this.preFetchSize = 64000;
        this.clientInfo = null;
        this.reconnected = false;
        this.efInfo = null;
        if (this.typeConverter != null) {
            this.typeConverter.reset();
            this.typeConverter = null;
        }
        if (this.stmtCache != null) {
            this.stmtCache.clear();
            this.stmtCache = null;
        }
    }

    @Override
    public synchronized void resetSession() throws SQLException {
        if (this.serverInfo != null) {
            int n = this.serverInfo.getProtocolMajorVersion();
            int n2 = this.serverInfo.getProtocolMinorVersion();
            if (n > 2 || n == 2 && n2 > 1) {
                this.dbComm.resetSession();
            }
        }
    }

    public void reuse() {
        this.warnings = null;
        this.autoCommit = true;
        this.sessionClosed = true;
        this.txnMode = 0;
        this.readOnly = false;
        this.isolationLevel = 2;
        this.preFetchSize = 64000;
        this.clientInfo = null;
        this.reconnected = false;
        if (this.typeMap != null) {
            this.typeMap.clear();
        }
        if (this.descriptorMap != null) {
            this.descriptorMap.clear();
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw TbError.newSQLException(-90603);
        }
        this.dbComm.rollback();
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        if (this.connClosed || this.dbComm.getStream() == null) {
            throw TbError.newSQLException(-90603);
        }
        if (this.autoCommit) {
            throw TbError.newSQLException(-90601);
        }
        this.dbComm.rollback((TbSavepoint)savepoint);
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        this.autoCommit = this.info.isInternal() ? false : bl;
    }

    @Override
    public void setCatalog(String string) throws SQLException {
    }

    @Override
    public synchronized void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.clientInfo == null) {
            this.clientInfo = new String[CLIENT_INFO_KEYS.length];
        }
        for (int i = 0; i < CLIENT_INFO_KEYS.length; ++i) {
            this.clientInfo[i] = (String)properties.get(CLIENT_INFO_KEYS[i]);
        }
        this.dbComm.setClientInfo(this.clientInfo);
    }

    @Override
    public synchronized void setClientInfo(String string, String string2) throws SQLClientInfoException {
        if (this.clientInfo == null) {
            this.clientInfo = new String[CLIENT_INFO_KEYS.length];
        }
        for (int i = 0; i < CLIENT_INFO_KEYS.length; ++i) {
            if (!CLIENT_INFO_KEYS[i].equals(string)) continue;
            this.clientInfo[i] = string2;
        }
        this.dbComm.setClientInfo(this.clientInfo);
    }

    public void setClosed(boolean bl) {
        this.connClosed = bl;
    }

    public void setDefaultRowPrefetch(int n) {
        this.preFetchSize = n;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        switch (n) {
            case 1: {
                return;
            }
            case 2: {
                throw TbError.newSQLException(-90660);
            }
        }
        throw TbError.newSQLException(-90608);
    }

    public void setMaxDFRCharCount() {
        int n = this.typeConverter.getMaxBytesPerChar();
        if (n == 1) {
            n = 2;
        }
        this.maxDFRCharCount = 65532 / n;
        int n2 = this.typeConverter.getMaxBytesPerNChar();
        if (n2 == 1) {
            n2 = 2;
        }
        this.maxDFRNCharCount = 65532 / n2;
    }

    public void setMiddleOfFailover(boolean bl) {
        this.middleOfFailover = bl;
    }

    public void setMthrPid(int n) {
        this.mthrPid = n;
    }

    public void setNLSDate(String string) {
        this.nlsDate = string;
        try {
            this.parsedNlsDateFormat = TbDTFormatParser.parse(this.nlsDate);
        }
        catch (SQLWarning sQLWarning) {
            this.addWarning(sQLWarning);
            this.parsedNlsDateFormat = null;
        }
    }

    public void setNLSTimestamp(String string) {
        this.nlsTimestamp = string;
        try {
            this.parsedNlsTimestampFormat = TbDTFormatParser.parse(this.nlsTimestamp);
        }
        catch (SQLWarning sQLWarning) {
            this.addWarning(sQLWarning);
            this.parsedNlsTimestampFormat = null;
        }
    }

    public boolean isNLSWarning() {
        return this.nlsWarning;
    }

    public void setNLSWarning(boolean bl) {
        this.nlsWarning = bl;
    }

    public void setPooledConnection(boolean bl) {
        this.isPooledConnection = bl;
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public void setReconnected(boolean bl) {
        this.reconnected = bl;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        TbSavepoint tbSavepoint = new TbSavepoint();
        this.dbComm.setSavePoint(tbSavepoint);
        return tbSavepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        TbSavepoint tbSavepoint = new TbSavepoint(string);
        this.dbComm.setSavePoint(tbSavepoint);
        return tbSavepoint;
    }

    public void setSerialNo(int n) {
        this.serialNo = n;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setSessKey(String string) {
        this.sessKey = string;
    }

    public void setSessionId(int n) {
        this.sessionId = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (n != 2 && n != 8) {
            throw TbError.newSQLException(-590722);
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            if (n == 8) {
                statement.execute("alter session set isolation_level=serializable");
            } else {
                statement.execute("alter session set isolation_level=read committed");
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        this.isolationLevel = n;
    }

    public void setTxnMode(int n) {
        this.txnMode = n;
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.typeMap = map;
    }

    public void switchTxnMode(int n, int n2) {
        if (this.txnMode == n) {
            this.txnMode = n2;
        }
    }

    public synchronized void putDescriptor(String string, TbTypeDescriptor tbTypeDescriptor) throws SQLException {
        if (string == null || tbTypeDescriptor == null) {
            throw TbError.newSQLException(-590713);
        }
        if (this.descriptorMap == null) {
            this.descriptorMap = new HashMap<String, TbTypeDescriptor>();
        }
        this.descriptorMap.put(string, tbTypeDescriptor);
    }

    public synchronized Object getDescriptor(String string) throws SQLException {
        if (string == null) {
            throw TbError.newSQLException(-590713);
        }
        if (this.descriptorMap == null) {
            throw TbError.newSQLException(-590700);
        }
        return this.descriptorMap.get(string);
    }

    public ExtFeatureInfo getExtFeatureInfo() throws SQLException {
        if (this.connClosed) {
            throw TbError.newSQLException(-90603);
        }
        return this.efInfo;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }

    public TbDTFormat getParsedNlsDateFormat() {
        return this.parsedNlsDateFormat;
    }

    public TbDTFormat getParsedNlsTimestampFormat() {
        return this.parsedNlsTimestampFormat;
    }
}

