/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data;

import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbCommon;
import java.sql.SQLException;

public class TbNrowId {
    static final int NROWID_BYTE_CNT = 8;
    static final int NEROWID_LEN = 11;
    static final int NEROWID_VAL_LAST = 10;
    static final int NEROWID_REMAINDER_BIT = 63;
    static final int NEROWID_DIVISION_SHIFT = 6;
    byte[] nrowid = new byte[8];
    static final byte[] nrowid_encoding = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private TbConnection conn = null;

    public TbNrowId(TbConnection tbConnection) {
        this.conn = tbConnection;
    }

    public String toString() {
        int n = 0;
        int n2 = this.conn == null ? 0 : this.conn.getServerInfo().getServerEndian();
        long l = n2 == 1 ? TbCommon.bytes2Long(this.nrowid, n, 8) : TbCommon.bytes2LongR(this.nrowid, n, 8);
        byte[] byArray = new byte[11];
        for (int i = 10; i >= 0; --i) {
            byArray[i] = nrowid_encoding[(int)l & 0x3F];
            l >>= 6;
        }
        return new String(byArray);
    }

    public byte[] getServerBytes(int n, String string) throws SQLException {
        int n2 = 0;
        long l = 0L;
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[8];
        n2 = 1;
        int n3 = 10;
        while (n3 > 0) {
            int n4 = TbNrowId.makeRowIdToInt(byArray[n3]);
            if (n4 < 0) {
                throw TbError.newSQLException(-590753, n4);
            }
            if (Long.MAX_VALUE - l < (long)(n2 * n4)) {
                throw TbError.newSQLException(-590753, "9223372036854775807 - " + l + " < " + n2 + " * " + n4);
            }
            l += (long)(n2 * n4);
            --n3;
            n2 <<= 6;
        }
        if (n == 1) {
            TbCommon.long2Bytes(l, byArray2, 0, 8);
        } else {
            TbCommon.long2BytesR(l, byArray2, 0, 8);
        }
        return byArray2;
    }

    public int getServerBytes(byte[] byArray, int n, int n2, String string) throws SQLException {
        int n3 = 0;
        long l = 0L;
        byte[] byArray2 = string.getBytes();
        n3 = 1;
        int n4 = 10;
        while (n4 > 0) {
            int n5 = TbNrowId.makeRowIdToInt(byArray2[n4]);
            if (n5 < 0) {
                throw TbError.newSQLException(-590753, n5);
            }
            if (Long.MAX_VALUE - l < (long)(n3 * n5)) {
                throw TbError.newSQLException(-590753, "9223372036854775807 - " + l + " < " + n3 + " * " + n5);
            }
            l += (long)(n3 * n5);
            --n4;
            n3 <<= 6;
        }
        if (n2 == 1) {
            TbCommon.long2Bytes(l, byArray, n, 8);
        } else {
            TbCommon.long2BytesR(l, byArray, n, 8);
        }
        return 8;
    }

    private static int makeRowIdToInt(byte by) {
        return 65 <= by && by <= 90 ? by - 65 + 0 : (97 <= by && by <= 122 ? by - 97 + 26 : (48 <= by && by <= 57 ? by - 48 + 52 : (43 == by ? 62 : (47 == by ? 63 : -1))));
    }
}

