/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.driver.TbKeepAlive;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TbKeepAlivePollingThread
extends Thread {
    private HashMap<String, HashSet<TbKeepAlive>> keepAliveSetMap;
    private long sleepMillis;

    public TbKeepAlivePollingThread() {
        super("TbKeepAlivePollingThread");
        this.setDaemon(true);
        this.sleepMillis = 1000L;
        this.keepAliveSetMap = new HashMap();
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.poll();
        }
    }

    private void poll() {
        block6: for (Map.Entry<String, HashSet<TbKeepAlive>> entry : this.keepAliveSetMap.entrySet()) {
            HashSet<TbKeepAlive> hashSet = entry.getValue();
            if (hashSet == null || hashSet.isEmpty()) continue;
            for (TbKeepAlive tbKeepAlive : entry.getValue()) {
                long l = System.currentTimeMillis();
                try {
                    SocketChannel socketChannel = tbKeepAlive.getChannel();
                    if (socketChannel != null) {
                        int n;
                        if (socketChannel.finishConnect()) {
                            n = tbKeepAlive.checkReply();
                            switch (n) {
                                case 1: {
                                    tbKeepAlive.closeCheckChannel(n);
                                    tbKeepAlive.resetBaseTime();
                                    break;
                                }
                                case 4: {
                                    for (TbKeepAlive tbKeepAlive2 : this.keepAliveSetMap.get(entry.getKey())) {
                                        tbKeepAlive2.closeCheckChannel(n);
                                        tbKeepAlive2.closeOrgConnSocket(n);
                                    }
                                    continue block6;
                                }
                            }
                            continue;
                        }
                        if (l - tbKeepAlive.getBaseTime() <= tbKeepAlive.getIntervalMillis()) continue;
                        n = 3;
                        if (tbKeepAlive.getTryCount() >= tbKeepAlive.getMaxRetryCount()) {
                            for (TbKeepAlive tbKeepAlive2 : this.keepAliveSetMap.get(entry.getKey())) {
                                tbKeepAlive2.closeCheckChannel(n);
                                tbKeepAlive2.closeOrgConnSocket(n);
                            }
                            continue block6;
                        }
                        tbKeepAlive.closeCheckChannel(n);
                        tbKeepAlive.tryConnect();
                        continue;
                    }
                    if (l - tbKeepAlive.getBaseTime() <= tbKeepAlive.getIdleMillis()) continue;
                    tbKeepAlive.tryConnect();
                }
                catch (Throwable throwable) {
                    tbKeepAlive.closeCheckChannel(5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TbKeepAlive tbKeepAlive) {
        HashMap<String, HashSet<TbKeepAlive>> hashMap = this.keepAliveSetMap;
        synchronized (hashMap) {
            String string = tbKeepAlive.getTargetAddressWithSvrInstId();
            HashSet<TbKeepAlive> hashSet = this.keepAliveSetMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.keepAliveSetMap.put(string, hashSet);
            }
            hashSet.add(tbKeepAlive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TbKeepAlive tbKeepAlive) {
        HashMap<String, HashSet<TbKeepAlive>> hashMap = this.keepAliveSetMap;
        synchronized (hashMap) {
            String string = tbKeepAlive.getTargetAddressWithSvrInstId();
            if (string == null) {
                return;
            }
            HashSet<TbKeepAlive> hashSet = this.keepAliveSetMap.get(string);
            if (hashSet != null) {
                hashSet.remove(tbKeepAlive);
            }
        }
    }
}

