/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

public class HKSCS2001CharToByteConverter {
    private static final char[] HKSCS2001_TO_CHARSET = new char[]{'\u8c4b', '\u8c56', '\u8c44', '\u8caa', '\u8c5d', '\u8cc3', '\u8c60', '\u8ccb', '\u8cc4', '\u8c58', '\u8c49', '\u8cd2', '\u8c72', '\u8c6f', '\u8c73', '\u8c70', '\u8c40', '\u8c71', '\u8c5b', '\u8c68', '\u8c75', '\u8ccc', '\u8c77', '\u8c78', '\u8cc5', '\u8cac', '\u8cd9', '\u8c48', '\u8cd4', '\u8c7a', '\u8c7b', '\u8c7c', '\u8c4d', '\u8c7e', '\u8c52', '\u8cca', '\u8ca2', '\u8ca3', '\u8c5e', '\u8ca5', '\u8c41', '\u8c67', '\u8c47', '\u8c51', '\u8ca7', '\u8ca9', '\u8c53', '\u8c5a', '\u8cad', '\u8c6b', '\u8c6e', '\u8c59', '\u8c63', '\u8cb1', '\u8cb2', '\u8cb3', '\u8c76', '\u8cdc', '\u8cb4', '\u8cd0', '\u8cb5', '\u8cbd', '\u8cb6', '\u8cce', '\u8c61', '\u8c45', '\u8cb8', '\u8cae', '\u8cba', '\u8c4f', '\u8cbc', '\u8c50', '\u8cbf', '\u8c6a', '\u8c66', '\u8cc9', '\u8cbe', '\u8c43', '\u8c6d', '\u8c74', '\u8cb7', '\u8cb9', '\u8cbb', '\u8cc0', '\u8cd7', '\u8cd8', '\u8cda', '\u8cc2', '\u8c57', '\u8c79', '\u8c69', '\u8c7d', '\u8c54', '\u8ca1', '\u8ca4', '\u8c46', '\u8ca8', '\u8ccf', '\u8cab', '\u8c4a', '\u8cb0', '\u8caf', '\u8c4c', '\u8cd5', '\u8cd3', '\u8cd6', '\u8cd1', '\u8c5c', '\u8c6c', '\u8c4e', '\u8c65', '\u8cc1', '\u8c64', '\u8c42', '\u8c55', '\u8c5f'};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE35 = new char[][]{{'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0000'}, {'\u0000', '\u0200'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE3C = new char[][]{{'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0000'}, {'\u0001', '\u0800'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0000'}, {'\u0002', '\u0200'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0000'}, {'\u0003', '\u0800'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE40 = new char[][]{{'\u0004', '\u0200'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0000'}, {'\u0005', '\u0002'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE42 = new char[][]{{'\u0006', '\u0000'}, {'\u0006', '\u0000'}, {'\u0006', '\b'}, {'\u0007', '\u0000'}, {'\u0007', '\u0000'}, {'\u0007', '\u0000'}, {'\u0007', '\u0000'}, {'\u0007', '@'}, {'\b', '\u0000'}, {'\b', '\u0000'}, {'\b', '\u0004'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE4B = new char[][]{{'\t', '\u0000'}, {'\t', '\u0001'}, {'\n', '\u0001'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0000'}, {'\u000b', '\u0002'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE4E = new char[][]{{'\f', '\u0000'}, {'\f', '\u0000'}, {'\f', '\u8000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\u0000'}, {'\r', '\b'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0000'}, {'\u000e', '\u0080'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0000'}, {'\u000f', '\u0001'}, {'\u0010', '\u0000'}, {'\u0010', '\u0000'}, {'\u0010', '\u0000'}, {'\u0010', '\u0800'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u0000'}, {'\u0011', '\u1000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u0000'}, {'\u0012', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE53 = new char[][]{{'\u0013', '\u0000'}, {'\u0013', '\u0000'}, {'\u0013', '\u0010'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0000'}, {'\u0014', '\u0010'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE57 = new char[][]{{'\u0015', '\u0000'}, {'\u0015', '\u0000'}, {'\u0015', '\u0000'}, {'\u0015', '\u2000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0000'}, {'\u0016', '\u0004'}, {'\u0017', '\u0000'}, {'\u0017', '\u0000'}, {'\u0017', '\u0000'}, {'\u0017', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE5A = new char[][]{{'\u0018', '\u0000'}, {'\u0018', '\u0400'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', '\u0000'}, {'\u0019', ' '}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '\u0000'}, {'\u001a', '@'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', '\u0000'}, {'\u001b', ' '}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0000'}, {'\u001c', '\u0800'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0000'}, {'\u001d', '\u0204'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0000'}, {'\u001f', '\u0004'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE61 = new char[][]{{' ', '\u0000'}, {' ', '\u0000'}, {' ', '\u0004'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE65 = new char[][]{{'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0000'}, {'!', '\u0800'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE67 = new char[][]{{'\"', '\u0000'}, {'\"', '\u0200'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0000'}, {'#', '\u0800'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE69 = new char[][]{{'$', '\u0000'}, {'$', '\u0200'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\u0000'}, {'%', '\b'}, {'&', '\u0000'}, {'&', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE6C = new char[][]{{'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u0000'}, {'\'', '\u8000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u0000'}, {'(', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE70 = new char[][]{{')', '\u0000'}, {')', '\u0000'}, {')', '\u0000'}, {')', '\u0000'}, {')', '\u2000'}, {'*', '\u0000'}, {'*', '\u0000'}, {'*', '\u0080'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0000'}, {'+', '\u0002'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0000'}, {',', '\u0001'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u0000'}, {'-', '\u1000'}, {'.', '\u0000'}, {'.', '\u0000'}, {'.', '\u0400'}, {'/', '\u0000'}, {'/', '\u0000'}, {'/', '\u0000'}, {'/', '\u0000'}, {'/', '\u0004'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0000'}, {'0', '\u0200'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE76 = new char[][]{{'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0000'}, {'1', '\u0200'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u0000'}, {'2', '\u2000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0000'}, {'3', '\u0010'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE7A = new char[][]{{'4', '\u0000'}, {'4', '\u0000'}, {'4', '\u0400'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\u0000'}, {'5', '\b'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u0000'}, {'6', '\u1000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\u0000'}, {'7', '\b'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0000'}, {'8', '\u0800'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0000'}, {'9', '\u0800'}, {':', '\u1000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE82 = new char[][]{{';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u0000'}, {';', '\u8000'}, {'<', '\u0000'}, {'<', '\u0000'}, {'<', '\u0000'}, {'<', '\u0100'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE85 = new char[][]{{'=', '\u0000'}, {'=', '\u0000'}, {'=', '\u0000'}, {'=', '\u0000'}, {'=', '\u0000'}, {'=', '\u8000'}, {'>', '\u0000'}, {'>', '\u0000'}, {'>', '\u0000'}, {'>', '\u0080'}, {'?', '\u0000'}, {'?', '\u0000'}, {'?', '\u0000'}, {'?', '@'}, {'@', '\u0000'}, {'@', '\u0000'}, {'@', '\u8000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE88 = new char[][]{{'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u0000'}, {'A', '\u8000'}, {'B', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE8B = new char[][]{{'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\u0000'}, {'C', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE8E = new char[][]{{'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0000'}, {'D', '\u0200'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0000'}, {'E', '\u0080'}, {'F', '\u0000'}, {'F', '\u8000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE91 = new char[][]{{'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '\u0000'}, {'G', '@'}, {'H', '\u0000'}, {'H', '\u0000'}, {'H', '\u0002'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0000'}, {'I', '\u0010'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE97 = new char[][]{{'J', '\u0000'}, {'J', '\u0000'}, {'J', '\u0000'}, {'J', '\u0000'}, {'J', '\u0000'}, {'J', ' '}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0000'}, {'K', '\u0100'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0000'}, {'L', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE9F = new char[][]{{'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\u0000'}, {'M', '\uffc0'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE214 = new char[][]{{'W', '\u0000'}, {'W', '\u0000'}, {'W', '\u0000'}, {'W', '\u8000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE219 = new char[][]{{'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0000'}, {'X', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE21D = new char[][]{{'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '\u0000'}, {'Y', '@'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE220 = new char[][]{{'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u0000'}, {'Z', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE227 = new char[][]{{'[', '\u0000'}, {'[', '\u0004'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE232 = new char[][]{{'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0000'}, {'\\', '\u0002'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0000'}, {']', '\u0200'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE23C = new char[][]{{'^', '\u0000'}, {'^', '\u0000'}, {'^', '\u0000'}, {'^', '\u0000'}, {'^', '\u0000'}, {'^', '\u0000'}, {'^', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE241 = new char[][]{{'_', '\u0000'}, {'_', '\u0000'}, {'_', '\u0000'}, {'_', '\u0000'}, {'_', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE245 = new char[][]{{'`', ' '}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE249 = new char[][]{{'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0000'}, {'a', '\u0800'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\u0000'}, {'b', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE251 = new char[][]{{'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u0000'}, {'c', '\u2000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE256 = new char[][]{{'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', '\u0000'}, {'d', ' '}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE25C = new char[][]{{'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0000'}, {'e', '\u0010'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0000'}, {'f', '\u0001'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE26B = new char[][]{{'g', '\u0000'}, {'g', ' '}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE26D = new char[][]{{'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0000'}, {'h', '\u0010'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE26F = new char[][]{{'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u0000'}, {'i', '\u4000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE271 = new char[][]{{'j', '\u2000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE287 = new char[][]{{'k', '\u8000'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE289 = new char[][]{{'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\u0000'}, {'l', '\b'}, {'m', '\u0000'}, {'m', '\u0000'}, {'m', '\u0000'}, {'m', '\u0000'}, {'m', '\u0004'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0000'}, {'n', '\u0400'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE28D = new char[][]{{'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0000'}, {'o', '\u0200'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE299 = new char[][]{{'p', '\u0000'}, {'p', '\u0000'}, {'p', '\u0000'}, {'p', '\u0000'}, {'p', '\u0080'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE29C = new char[][]{{'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\u0000'}, {'q', '\b'}};
    private static final char[][] HKSCS2001_TO_UNICODE_PAGE2A1 = new char[][]{{'r', '\u0080'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0000'}, {'s', '\u0400'}};
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public int getMaxBytesPerChar() {
        return 2;
    }

    public int convert(int n, byte[] byArray, int n2) {
        int n3;
        int n4;
        char[] cArray = null;
        if (n < 40704) {
            if (n < 26880) {
                if (n >= 13568 && n < 13664) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE35[(n >> 4) - 848];
                } else if (n >= 15360 && n < 16096) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE3C[(n >> 4) - 960];
                } else if (n >= 16384 && n < 16512) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE40[(n >> 4) - 1024];
                } else if (n >= 16896 && n < 17072) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE42[(n >> 4) - 1056];
                } else if (n >= 19200 && n < 19600) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE4B[(n >> 4) - 1200];
                } else if (n >= 19968 && n < 20912) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE4E[(n >> 4) - 1248];
                } else if (n >= 21248 && n < 21568) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE53[(n >> 4) - 1328];
                } else if (n >= 22272 && n < 22752) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE57[(n >> 4) - 1392];
                } else if (n >= 23040 && n < 24528) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE5A[(n >> 4) - 1440];
                } else if (n >= 24832 && n < 24880) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE61[(n >> 4) - 1552];
                } else if (n >= 25856 && n < 26000) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE65[(n >> 4) - 1616];
                } else if (n >= 26368 && n < 26480) {
                    cArray = HKSCS2001_TO_UNICODE_PAGE67[(n >> 4) - 1648];
                }
            } else if (n >= 26880 && n < 27248) {
                cArray = HKSCS2001_TO_UNICODE_PAGE69[(n >> 4) - 1680];
            } else if (n >= 27648 && n < 28160) {
                cArray = HKSCS2001_TO_UNICODE_PAGE6C[(n >> 4) - 1728];
            } else if (n >= 28672 && n < 29888) {
                cArray = HKSCS2001_TO_UNICODE_PAGE70[(n >> 4) - 1792];
            } else if (n >= 30208 && n < 30960) {
                cArray = HKSCS2001_TO_UNICODE_PAGE76[(n >> 4) - 1888];
            } else if (n >= 31232 && n < 32368) {
                cArray = HKSCS2001_TO_UNICODE_PAGE7A[(n >> 4) - 1952];
            } else if (n >= 33280 && n < 33536) {
                cArray = HKSCS2001_TO_UNICODE_PAGE82[(n >> 4) - 2080];
            } else if (n >= 34048 && n < 34320) {
                cArray = HKSCS2001_TO_UNICODE_PAGE85[(n >> 4) - 2128];
            } else if (n >= 34816 && n < 34976) {
                cArray = HKSCS2001_TO_UNICODE_PAGE88[(n >> 4) - 2176];
            } else if (n >= 35584 && n < 35728) {
                cArray = HKSCS2001_TO_UNICODE_PAGE8B[(n >> 4) - 2224];
            } else if (n >= 36352 && n < 36816) {
                cArray = HKSCS2001_TO_UNICODE_PAGE8E[(n >> 4) - 2272];
            } else if (n >= 37120 && n < 37888) {
                cArray = HKSCS2001_TO_UNICODE_PAGE91[(n >> 4) - 2320];
            } else if (n >= 38656 && n < 39408) {
                cArray = HKSCS2001_TO_UNICODE_PAGE97[(n >> 4) - 2416];
            }
        } else if (n < 153088) {
            if (n >= 40704 && n < 40880) {
                cArray = HKSCS2001_TO_UNICODE_PAGE9F[(n >> 4) - 2544];
            } else if (n >= 136192 && n < 136256) {
                cArray = HKSCS2001_TO_UNICODE_PAGE214[(n >> 4) - 8512];
            } else if (n >= 137472 && n < 137616) {
                cArray = HKSCS2001_TO_UNICODE_PAGE219[(n >> 4) - 8592];
            } else if (n >= 138496 && n < 138688) {
                cArray = HKSCS2001_TO_UNICODE_PAGE21D[(n >> 4) - 8656];
            } else if (n >= 139264 && n < 139392) {
                cArray = HKSCS2001_TO_UNICODE_PAGE220[(n >> 4) - 8704];
            } else if (n >= 141056 && n < 141088) {
                cArray = HKSCS2001_TO_UNICODE_PAGE227[(n >> 4) - 8816];
            } else if (n >= 143872 && n < 144384) {
                cArray = HKSCS2001_TO_UNICODE_PAGE232[(n >> 4) - 8992];
            } else if (n >= 146432 && n < 146544) {
                cArray = HKSCS2001_TO_UNICODE_PAGE23C[(n >> 4) - 9152];
            } else if (n >= 147712 && n < 147792) {
                cArray = HKSCS2001_TO_UNICODE_PAGE241[(n >> 4) - 9232];
            } else if (n >= 148736 && n < 148752) {
                cArray = HKSCS2001_TO_UNICODE_PAGE245[(n >> 4) - 9296];
            } else if (n >= 149760 && n < 150048) {
                cArray = HKSCS2001_TO_UNICODE_PAGE249[(n >> 4) - 9360];
            } else if (n >= 151808 && n < 152016) {
                cArray = HKSCS2001_TO_UNICODE_PAGE251[(n >> 4) - 9488];
            }
        } else if (n >= 153088 && n < 153248) {
            cArray = HKSCS2001_TO_UNICODE_PAGE256[(n >> 4) - 9568];
        } else if (n >= 154624 && n < 154944) {
            cArray = HKSCS2001_TO_UNICODE_PAGE25C[(n >> 4) - 9664];
        } else if (n >= 158464 && n < 158496) {
            cArray = HKSCS2001_TO_UNICODE_PAGE26B[(n >> 4) - 9904];
        } else if (n >= 158976 && n < 159104) {
            cArray = HKSCS2001_TO_UNICODE_PAGE26D[(n >> 4) - 9936];
        } else if (n >= 159488 && n < 159680) {
            cArray = HKSCS2001_TO_UNICODE_PAGE26F[(n >> 4) - 9968];
        } else if (n >= 160000 && n < 160016) {
            cArray = HKSCS2001_TO_UNICODE_PAGE271[(n >> 4) - 10000];
        } else if (n >= 165632 && n < 165648) {
            cArray = HKSCS2001_TO_UNICODE_PAGE287[(n >> 4) - 10352];
        } else if (n >= 166144 && n < 166640) {
            cArray = HKSCS2001_TO_UNICODE_PAGE289[(n >> 4) - 10384];
        } else if (n >= 167168 && n < 167360) {
            cArray = HKSCS2001_TO_UNICODE_PAGE28D[(n >> 4) - 10448];
        } else if (n >= 170240 && n < 170320) {
            cArray = HKSCS2001_TO_UNICODE_PAGE299[(n >> 4) - 10640];
        } else if (n >= 171008 && n < 171136) {
            cArray = HKSCS2001_TO_UNICODE_PAGE29C[(n >> 4) - 10688];
        } else if (n >= 172288 && n < 172736) {
            cArray = HKSCS2001_TO_UNICODE_PAGE2A1[(n >> 4) - 10768];
        }
        if (cArray != null && ((n4 = cArray[1]) & 1 << (n3 = n & 0xF)) != 0) {
            n4 &= (1 << n3) - 1;
            n4 = (n4 & 0x5555) + ((n4 & 0xAAAA) >> 1);
            n4 = (n4 & 0x3333) + ((n4 & 0xCCCC) >> 2);
            n4 = (n4 & 0xF0F) + ((n4 & 0xF0F0) >> 4);
            n4 = (n4 & 0xFF) + (n4 >> 8);
            char c = HKSCS2001_TO_CHARSET[cArray[0] + n4];
            byArray[n2] = (byte)(c >> 8);
            byArray[n2 + 1] = (byte)(c & 0xFF);
            return 0;
        }
        return -1;
    }
}

