/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbSQLOutput;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbStruct
implements Struct,
ParamContainer {
    private TbStructDescriptor descriptor;
    private TbConnection conn;
    private Object[] attributes;
    private Binder[] attributeBinders;
    private int[] paramInt;
    private long[] paramLong;
    private float[] paramFloat;
    private double[] paramDouble;
    private BigDecimal[] paramBigDecimal;
    private String[] paramString;
    private Timestamp[] paramTimestamp;
    private TbTimestampTZ[] paramTbTimestampTZ;
    private TbTimestamp[] paramTbTimestamp;
    private TbDate[] paramTbDate;
    private Calendar[] paramCalendar;
    private byte[][] paramBytes;
    private InputStream[] paramStream;
    private Reader[] paramReader;
    private Struct[] paramStruct;
    private Array[] paramArray;

    public TbStruct(TbStructDescriptor tbStructDescriptor, Connection connection, Object[] objectArray) throws SQLException {
        if (tbStructDescriptor == null) {
            throw TbError.newSQLException(-90608, "desc=null");
        }
        if (connection == null) {
            throw TbError.newSQLException(-90608, "conn=null");
        }
        this.descriptor = tbStructDescriptor;
        this.conn = (TbConnection)connection;
        this.attributes = objectArray;
        int n = tbStructDescriptor.getNumOfFields();
        int[] nArray = tbStructDescriptor.getAttributeTypes();
        this.initSubParams(n, nArray, objectArray);
    }

    private void initSubParams(int n, int[] nArray, Object[] objectArray) throws SQLException {
        int n2 = objectArray == null ? 0 : objectArray.length;
        this.attributeBinders = new Binder[n];
        block11: for (int i = 0; i < n2; ++i) {
            switch (nArray[i]) {
                case 1: {
                    if (objectArray[i] instanceof Short) {
                        if (this.paramInt == null) {
                            this.paramInt = new int[n];
                        }
                        this.paramInt[i] = ((Short)objectArray[i]).intValue();
                        this.attributeBinders[i] = StaticBinder.getIntBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Integer) {
                        if (this.paramInt == null) {
                            this.paramInt = new int[n];
                        }
                        this.paramInt[i] = (Integer)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getIntBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Long) {
                        if (this.paramLong == null) {
                            this.paramLong = new long[n];
                        }
                        this.paramLong[i] = (Long)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getLongBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof BigInteger) {
                        if (this.paramBigDecimal == null) {
                            this.paramBigDecimal = new BigDecimal[n];
                        }
                        this.paramBigDecimal[i] = new BigDecimal((BigInteger)objectArray[i]);
                        this.attributeBinders[i] = StaticBinder.getBigDecimalBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof BigDecimal) {
                        if (this.paramBigDecimal == null) {
                            this.paramBigDecimal = new BigDecimal[n];
                        }
                        this.paramBigDecimal[i] = (BigDecimal)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getBigDecimalBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Float) {
                        if (this.paramFloat == null) {
                            this.paramFloat = new float[n];
                        }
                        this.paramFloat[i] = ((Float)objectArray[i]).floatValue();
                        this.attributeBinders[i] = StaticBinder.getFloatBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Double) {
                        if (this.paramDouble == null) {
                            this.paramDouble = new double[n];
                        }
                        this.paramDouble[i] = (Double)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getDoubleBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof String) {
                        if (this.paramBigDecimal == null) {
                            this.paramBigDecimal = new BigDecimal[n];
                        }
                        this.paramBigDecimal[i] = new BigDecimal((String)objectArray[i]);
                        this.attributeBinders[i] = StaticBinder.getBigDecimalBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Boolean) {
                        if (this.paramBigDecimal == null) {
                            this.paramBigDecimal = new BigDecimal[n];
                        }
                        this.paramBigDecimal[i] = new BigDecimal((Boolean)objectArray[i] != false ? 1.0 : 0.0);
                        this.attributeBinders[i] = StaticBinder.getBigDecimalBinder();
                        continue block11;
                    }
                    Object object = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object);
                }
                case 2: 
                case 3: 
                case 10: {
                    if (this.paramString == null) {
                        this.paramString = new String[n];
                    }
                    this.attributeBinders[i] = StaticBinder.getStringBinder();
                    if (objectArray[i] instanceof Boolean) {
                        this.paramString[i] = (Boolean)objectArray[i] != false ? "1" : "0";
                        continue block11;
                    }
                    this.paramString[i] = objectArray[i].toString();
                    continue block11;
                }
                case 18: 
                case 19: {
                    if (this.paramString == null) {
                        this.paramString = new String[n];
                    }
                    this.attributeBinders[i] = StaticBinder.getNStringBinder();
                    if (objectArray[i] instanceof Boolean) {
                        this.paramString[i] = (Boolean)objectArray[i] != false ? "1" : "0";
                        continue block11;
                    }
                    this.paramString[i] = objectArray[i].toString();
                    continue block11;
                }
                case 4: {
                    if (this.paramBytes == null) {
                        this.paramBytes = new byte[n][];
                    }
                    this.attributeBinders[i] = StaticBinder.getBytesBinder();
                    if (objectArray[i] instanceof byte[]) {
                        this.paramBytes[i] = (byte[])objectArray[i];
                        continue block11;
                    }
                    Object object = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object);
                }
                case 5: {
                    Object object;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n];
                        }
                        object = Calendar.getInstance(((TbTimestampTZ)objectArray[i]).getTimeZone());
                        ((Calendar)object).setTime((TbTimestampTZ)objectArray[i]);
                        this.paramCalendar[i] = object;
                        this.attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof TbTimestamp) {
                        if (this.paramTbDate == null) {
                            this.paramTbDate = new TbDate[n];
                        }
                        object = (TbTimestamp)objectArray[i];
                        this.paramTbDate[i] = new TbDate(((TbTimestamp)object).getYear(), ((TbTimestamp)object).getMonth(), ((TbTimestamp)object).getDayOfMonth(), ((TbTimestamp)object).getHourOfDay(), ((TbTimestamp)object).getMinutes(), ((TbTimestamp)object).getSeconds());
                        this.attributeBinders[i] = StaticBinder.getTbDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof TbDate) {
                        if (this.paramTbDate == null) {
                            this.paramTbDate = new TbDate[n];
                        }
                        this.paramTbDate[i] = (TbDate)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getTbDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Date) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n];
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        this.paramCalendar[i] = object;
                        this.attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Timestamp) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n];
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Timestamp)objectArray[i]);
                        this.paramCalendar[i] = object;
                        this.attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof String) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n];
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime(Date.valueOf((String)objectArray[i]));
                        this.paramCalendar[i] = object;
                        this.attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    object = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object);
                }
                case 7: {
                    Object object;
                    if (objectArray[i] instanceof TbTimestampTZ) {
                        if (this.paramTimestamp == null) {
                            this.paramTimestamp = new Timestamp[n];
                        }
                        this.paramTimestamp[i] = (Timestamp)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getTimestampBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof TbTimestamp) {
                        if (this.paramTbTimestamp == null) {
                            this.paramTbTimestamp = new TbTimestamp[n];
                        }
                        this.paramTbTimestamp[i] = (TbTimestamp)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getTbTimestampBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof TbDate) {
                        if (this.paramTbTimestamp == null) {
                            this.paramTbTimestamp = new TbTimestamp[n];
                        }
                        object = (TbDate)objectArray[i];
                        this.paramTbTimestamp[i] = new TbTimestamp(((TbDate)object).getYear(), ((TbDate)object).getMonth(), ((TbDate)object).getDayOfMonth(), ((TbDate)object).getHourOfDay(), ((TbDate)object).getMinutes(), ((TbDate)object).getSeconds(), 0);
                        this.attributeBinders[i] = StaticBinder.getTbTimestampBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Timestamp) {
                        if (this.paramTimestamp == null) {
                            this.paramTimestamp = new Timestamp[n];
                        }
                        this.paramTimestamp[i] = (Timestamp)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getTimestampBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof Date) {
                        if (this.paramCalendar == null) {
                            this.paramCalendar = new Calendar[n];
                        }
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime((Date)objectArray[i]);
                        this.paramCalendar[i] = object;
                        this.attributeBinders[i] = StaticBinder.getDateBinder();
                        continue block11;
                    }
                    if (objectArray[i] instanceof String) {
                        if (this.paramTimestamp == null) {
                            this.paramTimestamp = new Timestamp[n];
                        }
                        this.paramTimestamp[i] = Timestamp.valueOf((String)objectArray[i]);
                        this.attributeBinders[i] = StaticBinder.getTimestampBinder();
                        continue block11;
                    }
                    object = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray[i];
                    throw TbError.newSQLException(-90651, (String)object);
                }
                case 12: 
                case 13: 
                case 20: {
                    if (objectArray[i] instanceof TbLob) {
                        if (this.paramBytes == null) {
                            this.paramBytes = new byte[n][];
                        }
                        this.paramBytes[i] = ((TbLob)objectArray[i]).getLocator();
                        this.attributeBinders[i] = StaticBinder.getBytesBinder();
                        continue block11;
                    }
                    Object object = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                    throw TbError.newSQLException(-90651, (String)object);
                }
                case 29: 
                case 30: {
                    if (objectArray[i] instanceof Array) {
                        if (this.paramArray == null) {
                            this.paramArray = new Array[n];
                        }
                        this.paramArray[i] = (Array)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getArrayBinder();
                        continue block11;
                    }
                    Object object = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                    throw TbError.newSQLException(-90651, (String)object);
                }
                case 28: 
                case 32: {
                    if (objectArray[i] instanceof Struct) {
                        if (this.paramStruct == null) {
                            this.paramStruct = new Struct[n];
                        }
                        this.paramStruct[i] = (Struct)objectArray[i];
                        this.attributeBinders[i] = StaticBinder.getStructBinder();
                        continue block11;
                    }
                    Object object = "elementType=" + DataType.getDBTypeName(nArray[i]) + ",attribute=" + objectArray;
                    throw TbError.newSQLException(-90651, (String)object);
                }
                default: {
                    throw TbError.newSQLException(-590703, DataType.getDBTypeName(nArray[i]));
                }
            }
        }
    }

    public TbStructDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public int getNumOfFields() {
        return this.descriptor.getNumOfFields();
    }

    public static Object toStruct(Object object, Connection connection) throws SQLException {
        TbStruct tbStruct = null;
        if (object != null) {
            if (object instanceof TbStruct) {
                tbStruct = (TbStruct)object;
            } else if (object instanceof SQLData) {
                SQLData sQLData = (SQLData)object;
                TbStructDescriptor tbStructDescriptor = TbStructDescriptor.createDescriptor(sQLData.getSQLTypeName(), connection);
                SQLOutput sQLOutput = tbStructDescriptor.toSQLOutput();
                sQLData.writeSQL(sQLOutput);
                tbStruct = ((TbSQLOutput)sQLOutput).getStruct();
            }
        }
        return tbStruct;
    }

    public String getSQLTypeName() throws SQLException {
        if (this.descriptor == null) {
            throw new SQLException("invalid descriptor");
        }
        return this.descriptor.getSQLTypeName();
    }

    public Object[] getAttributes() throws SQLException {
        Debug.logMethod("TbArray.getAttributes", new Object[0]);
        return this.attributes;
    }

    public Object toClass(Class clazz, Map map) throws SQLException {
        Object var3_3 = null;
        try {
            var3_3 = clazz.newInstance();
            if (var3_3 instanceof SQLData) {
                ((SQLData)var3_3).readSQL(this.descriptor.toSQLInput(this, map), this.descriptor.getSQLTypeName());
            }
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException.getMessage());
        }
        return var3_3;
    }

    public Object toClass(Map map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.descriptor.getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    public Object[] getAttributes(Map map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public BindData getBindData() {
        return null;
    }

    public Binder[][] getBinder() {
        return null;
    }

    public Binder getBinder(int n, int n2) {
        return this.attributeBinders[n2];
    }

    public int getParameterCnt() {
        return 1;
    }

    public byte getParamType(int n, int n2) {
        return 0;
    }

    public byte[][] getParamTypes() {
        return null;
    }

    public byte[] getParamTypesOfRow(int n) {
        return null;
    }

    public Array getParamArray(int n, int n2) {
        return this.paramArray[n2];
    }

    public Array[] getParamArrayOfRow(int n) {
        return null;
    }

    public BigDecimal getParamBigDecimal(int n, int n2) {
        return this.paramBigDecimal[n2];
    }

    public BigDecimal[] getParamBigDecimalOfRow(int n) {
        return null;
    }

    public byte[] getParamBytes(int n, int n2) {
        return this.paramBytes[n2];
    }

    public byte[][] getParamBytesOfRow(int n) {
        return null;
    }

    public Calendar getParamCalendar(int n, int n2) {
        return this.paramCalendar[n2];
    }

    public Calendar[] getParamCalendarOfRow(int n) {
        return null;
    }

    public double getParamDouble(int n, int n2) {
        return this.paramDouble[n2];
    }

    public double[] getParamDoubleOfRow(int n) {
        return null;
    }

    public float getParamFloat(int n, int n2) {
        return this.paramFloat[n2];
    }

    public float[] getParamFloatOfRow(int n) {
        return null;
    }

    public int getParamInt(int n, int n2) {
        return this.paramInt[n2];
    }

    public int[] getParamIntOfRow(int n) {
        return null;
    }

    public long getParamLong(int n, int n2) {
        return this.paramLong[n2];
    }

    public long[] getParamLongOfRow(int n) {
        return null;
    }

    public Reader getParamReader(int n, int n2) {
        return this.paramReader[n2];
    }

    public Reader[] getParamReaderOfRow(int n) {
        return null;
    }

    public InputStream getParamStream(int n, int n2) {
        return this.paramStream[n2];
    }

    public InputStream[] getParamStreamOfRow(int n) {
        return null;
    }

    public String getParamString(int n, int n2) {
        return this.paramString[n2];
    }

    public String[] getParamStringOfRow(int n) {
        return null;
    }

    public Struct getParamStruct(int n, int n2) {
        return this.paramStruct[n2];
    }

    public Struct[] getParamStructOfRow(int n) {
        return null;
    }

    public TbDate getParamTbDate(int n, int n2) {
        return this.paramTbDate[n2];
    }

    public TbDate[] getParamTbDateOfRow(int n) {
        return null;
    }

    public TbTimestamp getParamTbTimestamp(int n, int n2) {
        return this.paramTbTimestamp[n2];
    }

    public TbTimestamp[] getParamTbTimestampOfRow(int n) {
        return null;
    }

    public TbTimestampTZ getParamTbTimestampTZ(int n, int n2) {
        return this.paramTbTimestampTZ[n2];
    }

    public TbTimestampTZ[] getParamTbTimestampTZOfRow(int n) {
        return null;
    }

    public Timestamp getParamTimestamp(int n, int n2) {
        return this.paramTimestamp[n2];
    }

    public Timestamp[] getParamTimestampOfRow(int n) {
        return null;
    }
}

