/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbLogicalConnection;
import com.tmax.tibero.jdbc.ext.TbStatementEventHandler;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

class TbLogicalPreparedStatement
extends TbPreparedStatement
implements TbStatementEventHandler {
    private TbLogicalConnection logicalConn = null;
    private boolean closed = true;
    protected TbPreparedStatement physicalStmt = null;

    public TbLogicalPreparedStatement(TbLogicalConnection tbLogicalConnection, TbPreparedStatement tbPreparedStatement) throws SQLException {
        super(tbLogicalConnection.getPhysicalConnection(), tbPreparedStatement.getOriginalSql());
        Debug.logMethod("TbLogicalStatement", new Object[]{this, tbLogicalConnection, tbPreparedStatement});
        this.logicalConn = tbLogicalConnection;
        this.physicalStmt = tbPreparedStatement;
        if (tbPreparedStatement.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90658);
        }
        this.closed = false;
    }

    public void addBatch(String string) throws SQLException {
        Debug.logMethod("TbLogicalStatement.addBatch", new Object[]{this, this.physicalStmt, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void cancel() throws SQLException {
        Debug.logMethod("TbLogicalStatement.cancel", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.cancel();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void clearBatch() throws SQLException {
        Debug.logMethod("TbLogicalStatement.clearBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        this.physicalStmt.clearBatch();
    }

    public void clearWarnings() throws SQLException {
        Debug.logMethod("TbLogicalStatement.clearWarnings", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        Debug.logMethod("TbLogicalStatement.close", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.physicalStmt.resetForCache();
        this.notifyClosedEvent();
    }

    public boolean execute(String string) throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public boolean execute(String string, int n) throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt, string, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt, string, nArray});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt, string, stringArray});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int[] executeBatch() throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeBatch();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeQuery", new Object[]{this, this.physicalStmt, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate(String string) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate(String string, int n) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt, string, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt, string, nArray});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt, string, stringArray});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public Connection getConnection() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getConnection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.logicalConn;
    }

    public int getFetchDirection() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getFetchDirection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int getFetchSize() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getFetchDirection", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getFetchDirection();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getGeneratedKeys", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMaxFieldSize", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxFieldSize();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int getMaxRows() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMaxRows", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMaxRows();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public boolean getMoreResults() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMoreResults", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMoreResults", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMoreResults();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int getQueryTimeout() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getQueryTimeout", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getQueryTimeout();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getResultSet", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSet();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getResultSetConcurrency", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.physicalStmt.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getResultSetHoldability", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int getResultSetType() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getResultSetType", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getResultSetType();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int getUpdateCount() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getUpdateCount", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getUpdateCount();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getWarnings", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isPoolable() throws SQLException {
        Debug.logMethod("TbLogicalStatement.isPoolable", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.isPoolable();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setCursorName(String string) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setCursorName", new Object[]{this, this.physicalStmt, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCursorName(string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setEscapeProcessing", new Object[]{this, this.physicalStmt, new Boolean(bl)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setEscapeProcessing(bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setFetchDirection", new Object[]{this, this.physicalStmt, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchDirection(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setFetchSize(int n) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setFetchSize", new Object[]{this, this.physicalStmt, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFetchSize(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setMaxFieldSize", new Object[]{this, this.physicalStmt, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxFieldSize(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setMaxRows(int n) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setMaxRows", new Object[]{this, this.physicalStmt, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setMaxRows(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setQueryTimeout", new Object[]{this, this.physicalStmt, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setQueryTimeout(n);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void addBatch() throws SQLException {
        Debug.logMethod("TbLogicalStatement.addBatch", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.addBatch();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void clearParameters() throws SQLException {
        Debug.logMethod("TbLogicalStatement.clearParameters", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.clearParameters();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public boolean execute() throws SQLException {
        Debug.logMethod("TbLogicalStatement.execute", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.execute();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public ResultSet executeQuery() throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeQuery", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeQuery();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public int executeUpdate() throws SQLException {
        Debug.logMethod("TbLogicalStatement.executeUpdate", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.executeUpdate();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getMetaData", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        Debug.logMethod("TbLogicalStatement.getParameterMetaData", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            return this.physicalStmt.getParameterMetaData();
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setArray", new Object[]{this, this.physicalStmt});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setArray(n, array);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setAsciiStream", new Object[]{this, this.physicalStmt, inputStream, Integer.toString(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setAsciiStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBigDecimal", new Object[]{this, this.physicalStmt, bigDecimal});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBigDecimal(n, bigDecimal);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBinaryStream", new Object[]{this, this.physicalStmt, inputStream, Integer.toString(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBinaryStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBlob", new Object[]{this, this.physicalStmt, blob});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBlob(n, blob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBoolean", new Object[]{this, this.physicalStmt, new Boolean(bl)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBoolean(n, bl);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setByte", new Object[]{this, this.physicalStmt, Byte.toString(by)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setByte(n, by);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setBytes", new Object[]{this, this.physicalStmt, byArray});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setBytes(n, byArray);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setCharacterStream", new Object[]{this, this.physicalStmt, reader, Integer.toString(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setCharacterStream(n, reader, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setClob", new Object[]{this, this.physicalStmt, clob});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setClob(n, clob);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setDate", new Object[]{this, this.physicalStmt, date});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(n, date);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setDate", new Object[]{this, this.physicalStmt, date, calendar});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDate(n, date, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setDouble", new Object[]{this, this.physicalStmt, Double.toString(d)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setDouble(n, d);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setFixedCHAR(int n, String string) throws SQLException {
        Debug.logMethod("TbPreparedStatement.setFixedCHAR", new Object[]{this, Integer.toString(n), string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFixedCHAR(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setFloat(int n, float f) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setFloat", new Object[]{this, this.physicalStmt, Float.toString(f)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setFloat(n, f);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setInt", new Object[]{this, this.physicalStmt, Integer.toString(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setInt(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setLong(int n, long l) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setLong", new Object[]{this, this.physicalStmt, Long.toString(l)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setLong(n, l);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setNString(int n, String string) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNString", new Object[]{this, this.physicalStmt, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNString(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNull", new Object[]{this, this.physicalStmt, Integer.toString(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setNull", new Object[]{this, this.physicalStmt, Integer.toString(n2), string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setNull(n, n2, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setObject", new Object[]{this, this.physicalStmt, object});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setObject", new Object[]{this, this.physicalStmt, object, Integer.toString(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setObject", new Object[]{this, this.physicalStmt, object, Integer.toString(n2), Integer.toString(n3)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setObject(n, object, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setRef", new Object[]{this, this.physicalStmt, ref});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setRef(n, ref);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setShort(int n, short s) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setShort", new Object[]{this, this.physicalStmt, Short.toString(s)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setShort(n, s);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setString(int n, String string) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setString", new Object[]{this, this.physicalStmt, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setString(n, string);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTime", new Object[]{this, this.physicalStmt, time});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(n, time);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTime", new Object[]{this, this.physicalStmt, time, calendar});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTime(n, time, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTimestamp", new Object[]{this, this.physicalStmt, timestamp});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(n, timestamp);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setTimestamp", new Object[]{this, this.physicalStmt, timestamp, calendar});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setTimestamp(n, timestamp, calendar);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setURL(int n, URL uRL) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setURL", new Object[]{this, this.physicalStmt, uRL});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setURL(n, uRL);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        Debug.logMethod("TbLogicalStatement.setUnicodeStream", new Object[]{this, this.physicalStmt, inputStream, Integer.toString(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        try {
            this.physicalStmt.setUnicodeStream(n, inputStream, n2);
        }
        catch (SQLException sQLException) {
            this.notifyExceptionEvent(this.physicalStmt, sQLException);
            throw sQLException;
        }
    }

    public void notifyClosedEvent() {
    }

    public void notifyExceptionEvent(PreparedStatement preparedStatement, Exception exception) {
    }
}

