/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLInfo2;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.driver.TbCallableStatement;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbConnectionEventHandler;
import com.tmax.tibero.jdbc.ext.TbXAException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TbLogicalConnection
implements TbConnection {
    private TbConnectionEventHandler eventHandler = null;
    private com.tmax.tibero.jdbc.driver.TbConnection physicalConn = null;
    private boolean closed = true;
    private boolean useXA = false;
    private boolean reseted = true;

    public TbLogicalConnection(TbConnectionEventHandler tbConnectionEventHandler, com.tmax.tibero.jdbc.driver.TbConnection tbConnection, boolean bl) throws SQLException {
        Debug.logMethod("TbLogicalConnection", new Object[]{this, tbConnectionEventHandler, tbConnection, new Boolean(bl)});
        this.eventHandler = tbConnectionEventHandler;
        this.physicalConn = tbConnection;
        this.useXA = bl;
        if (tbConnection.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90643);
        }
        this.closed = false;
        if (!this.physicalConn.isSessionClosed()) {
            this.physicalConn.resetSession();
            this.physicalConn.reuse();
            this.eventHandler.notifyClosedEvent();
        }
    }

    public void clearWarnings() throws SQLException {
        Debug.logMethod("TbLogicalConnection.clearWarnings", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        Debug.logMethod("TbLogicalConnection.close", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            return;
        }
        if (this.physicalConn.getAutoCommit()) {
            this.physicalConn.commit();
        }
        this.closed = true;
        this.physicalConn.resetSession();
        this.physicalConn.reuse();
        this.eventHandler.notifyClosedEvent();
    }

    public void commit() throws SQLException {
        Debug.logMethod("TbLogicalConnection.commit", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.commit();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        Debug.logMethod("TbLogicalConnection.commit", new Object[]{this, this.physicalConn, xid, new Boolean(bl)});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).commit(xid, bl);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public Statement createStatement() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createStatement", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        Debug.logMethod("TbLogicalConnection.createStatement", new Object[]{this, this.physicalConn, Integer.toString(n), Integer.toString(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void end(Xid xid, int n) throws XAException {
        Debug.logMethod("TbLogicalConnection.end", new Object[]{this, this.physicalConn, xid, Integer.toString(n)});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).end(xid, n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public void forget(Xid xid) throws TbXAException {
        Debug.logMethod("TbLogicalConnection.forget", new Object[]{this, this.physicalConn, xid});
    }

    public boolean getAutoCommit() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getAutoCommit", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getCatalog", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getCatalog();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getLastExecutedSqlinfo", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getLastExecutedSqlinfo();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public TbSQLInfo2 getLastExecutedSqlinfo2() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getLastExecutedSqlinfo2", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getLastExecutedSqlinfo2();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getMetaData", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getMetaData();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    com.tmax.tibero.jdbc.driver.TbConnection getPhysicalConnection() {
        return this.physicalConn;
    }

    public int getTransactionIsolation() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getTransactionIsolation", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public int getTxnMode() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getTxnMode", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.getTxnMode();
    }

    public Map getTypeMap() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getTypeMap", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        Debug.logMethod("TbLogicalConnection.getWarnings", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getWarnings();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPhysConnClosed() throws SQLException {
        return this.physicalConn.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        Debug.logMethod("TbLogicalConnection.isReadOnly", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean isUseXA() {
        return this.useXA;
    }

    public String nativeSQL(String string) throws SQLException {
        Debug.logMethod("TbLogicalConnection.nativeSQL", new Object[]{this, this.physicalConn, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public int prepare(Xid xid) throws XAException {
        Debug.logMethod("TbLogicalConnection.prepare", new Object[]{this, this.physicalConn, xid});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                return ((XAResource)((Object)this.physicalConn)).prepare(xid);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException("prepare failed " + sQLException.getMessage());
        }
        throw new TbXAException("prepare failed");
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareCall", new Object[]{this, this.physicalConn, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbCallableStatement tbCallableStatement;
            TbCallableStatement tbCallableStatement2 = null;
            tbCallableStatement2 = tbCallableStatement = (TbCallableStatement)this.physicalConn.prepareCall(string);
            return tbCallableStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareCall", new Object[]{this, this.physicalConn, string, new Integer(n), new Integer(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbCallableStatement tbCallableStatement;
            TbCallableStatement tbCallableStatement2 = null;
            tbCallableStatement2 = tbCallableStatement = (TbCallableStatement)this.physicalConn.prepareCall(string, n, n2);
            return tbCallableStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, string, new Boolean(bl)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, bl);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, n);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, string, new Integer(n), new Integer(n2)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, n, n2);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, nArray);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        Debug.logMethod("TbLogicalConnection.prepareStatement", new Object[]{this, this.physicalConn, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, stringArray);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Xid[] recover(int n) throws XAException {
        Debug.logMethod("TbLogicalConnection.recover", new Object[]{this, this.physicalConn, Integer.toString(n)});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                return ((XAResource)((Object)this.physicalConn)).recover(n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException("recover failed " + sQLException.getMessage());
        }
        throw new TbXAException("recover failed");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void reset() {
        this.eventHandler = null;
        this.physicalConn = null;
    }

    public void rollback() throws SQLException {
        Debug.logMethod("TbLogicalConnection.rollback", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.rollback();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        Debug.logMethod("TbLogicalConnection.rollback", new Object[]{this, this.physicalConn, savepoint});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void rollback(Xid xid) throws XAException {
        Debug.logMethod("TbLogicalConnection.rollback", new Object[]{this, this.physicalConn, xid});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).rollback(xid);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setAutoCommit", new Object[]{this, this.physicalConn, new Boolean(bl)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            if (bl) {
                throw TbError.newSQLException(-90602);
            }
        } else {
            try {
                this.physicalConn.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                this.eventHandler.notifyExceptionEvent(sQLException);
                throw sQLException;
            }
        }
    }

    public void setCatalog(String string) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setCatalog", new Object[]{this, this.physicalConn, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void setHoldability(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setReadOnly", new Object[]{this, this.physicalConn, new Boolean(bl)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        Debug.logMethod("TbLogicalConnection.setSavepoint", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        return this.physicalConn.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setSavepoint", new Object[]{this, this.physicalConn, string});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        return this.physicalConn.setSavepoint(string);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setTransactionIsolation", new Object[]{this, this.physicalConn, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void setTxnMode(int n) {
        Debug.logMethod("TbLogicalConnection.setTxnMode", new Object[]{this, this.physicalConn, Integer.toString(n)});
        this.physicalConn.setTxnMode(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        Debug.logMethod("TbLogicalConnection.setTypeMap", new Object[]{this, this.physicalConn, map});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void start(Xid xid, int n) throws XAException {
        Debug.logMethod("TbLogicalConnection.start", new Object[]{this, this.physicalConn, xid, Integer.toString(n)});
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).start(xid, n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public void addWarning(SQLWarning sQLWarning) {
        Debug.logMethod("TbLogicalConnection.addWarning", new Object[]{this, this.physicalConn, sQLWarning});
        this.physicalConn.addWarning(sQLWarning);
    }

    public void closeCursor(TbResultSet tbResultSet, int n) throws SQLException {
        Debug.logMethod("TbLogicalConnection.closeCursor", new Object[]{this, this.physicalConn, tbResultSet, Integer.toString(n)});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.physicalConn.closeCursor(tbResultSet, n);
    }

    public TbBlob createTbBlob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createTbBlob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbBlob();
    }

    public TbClob createTbClob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createTbClob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbClob();
    }

    public TbDirPathStream createDirPathStream(TbDirPathMetaData tbDirPathMetaData) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public TbNClob createTbNClob() throws SQLException {
        Debug.logMethod("TbLogicalConnection.createTbNClob", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbNClob();
    }

    public String getNlsDate() {
        Debug.logMethod("TbLogicalConnection.getNlsDate", new Object[]{this, this.physicalConn});
        return this.physicalConn.getNlsDate();
    }

    public String getNlsTimestamp() {
        Debug.logMethod("TbLogicalConnection.getNlsTimestamp", new Object[]{this, this.physicalConn});
        return this.physicalConn.getNlsTimestamp();
    }

    public int getSerialNo() {
        Debug.logMethod("TbLogicalConnection.getSerialNo", new Object[]{this, this.physicalConn});
        return this.physicalConn.getSerialNo();
    }

    public int getServerCharSet() {
        Debug.logMethod("TbLogicalConnection.getServerCharSet", new Object[]{this, this.physicalConn});
        return this.physicalConn.getServerCharSet();
    }

    public ServerInfo getServerInfo() {
        Debug.logMethod("TbLogicalConnection.getServerInfo", new Object[]{this, this.physicalConn});
        return this.physicalConn.getServerInfo();
    }

    public int getServerNCharSet() {
        Debug.logMethod("TbLogicalConnection.getServerNCharSet", new Object[]{this, this.physicalConn});
        return this.physicalConn.getServerNCharSet();
    }

    public int getSessionId() {
        Debug.logMethod("TbLogicalConnection.getSessionId", new Object[]{this, this.physicalConn});
        return this.physicalConn.getSessionId();
    }

    public boolean isPooledConnection() {
        Debug.logMethod("TbLogicalConnection.isPooledConnection", new Object[]{this, this.physicalConn});
        return false;
    }

    public boolean isSessionClosed() {
        Debug.logMethod("TbLogicalConnection.isSessionClosed", new Object[]{this, this.physicalConn});
        return this.physicalConn.isSessionClosed();
    }

    public void resetSession() throws SQLException {
        Debug.logMethod("TbLogicalConnection.resetSession", new Object[]{this, this.physicalConn});
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.physicalConn.resetSession();
    }
}

