/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class TbResultSetMetaData
implements ResultSetMetaData {
    private Column[] columnInfoArr = null;

    public TbResultSetMetaData(Column[] columnArray, int n) {
        Debug.logMethod("TbResultSetMetaData", new Object[]{this, columnArray, Integer.toString(n)});
        if (columnArray != null) {
            int n2 = columnArray.length - n;
            this.columnInfoArr = new Column[n2];
            for (int i = 0; i < n2; ++i) {
                this.columnInfoArr[i] = new Column(columnArray[i + n]);
            }
        }
    }

    public TbResultSetMetaData(TbColumnDesc[] tbColumnDescArray, int n, boolean bl) throws SQLException {
        Debug.logMethod("TbResultSetMetaData", new Object[]{this, tbColumnDescArray, Integer.toString(n), Boolean.toString(bl)});
        if (tbColumnDescArray != null) {
            int n2 = tbColumnDescArray.length - n;
            this.columnInfoArr = new Column[n2];
            for (int i = 0; i < n2; ++i) {
                this.columnInfoArr[i] = new Column(bl);
                this.columnInfoArr[i].set(i, tbColumnDescArray[i + n]);
            }
        }
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public String getColumnClassName(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnClassName", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        return DataType.getDataTypeClassName(this.getColumnDataType(n));
    }

    public int getColumnCount() throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnCount", new Object[]{this});
        if (this.columnInfoArr != null) {
            return this.columnInfoArr.length;
        }
        throw TbError.newSQLException(-590784);
    }

    private int getColumnDataType(int n) throws SQLException {
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[n - 1].getDataType();
        }
        throw TbError.newSQLException(-590784);
    }

    private int getColumnMaxLength(int n) throws SQLException {
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[n - 1].getMaxLength();
        }
        throw TbError.newSQLException(-590784);
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnDisplaySize", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        int n3 = this.getColumnMaxLength(n);
        if (n3 > 0) {
            return n3;
        }
        switch (n2) {
            case 2: 
            case 3: {
                int n4 = this.getColumnName(n).length();
                if (n4 == 0) {
                    return 1;
                }
                return n4;
            }
            case 1: {
                return 45;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return 24;
            }
            case 15: {
                return 14;
            }
            case 12: 
            case 13: {
                return 400000000;
            }
        }
        return 65535;
    }

    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnName(n);
    }

    public String getColumnName(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnName", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[n - 1].getName();
        }
        throw TbError.newSQLException(-590784);
    }

    public int getColumnType(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnType", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[n - 1].getSqlType();
        }
        throw TbError.newSQLException(-590784);
    }

    public String getColumnTypeName(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getColumnTypeName", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        return DataType.getDBTypeName(this.getColumnDataType(n), this.getColumnPrecision(n));
    }

    private int getColumnPrecision(int n) throws SQLException {
        if (this.columnInfoArr != null) {
            return this.columnInfoArr[n - 1].getPrecision();
        }
        throw TbError.newSQLException(-590784);
    }

    public int getPrecision(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getPrecision", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        int n2 = this.getColumnPrecision(n);
        int n3 = this.getColumnDataType(n);
        switch (n3) {
            case 2: 
            case 3: {
                return this.getColumnMaxLength(n);
            }
            case 12: 
            case 13: {
                return -1;
            }
            case 10: 
            case 11: {
                return Integer.MAX_VALUE;
            }
        }
        return n2 < 0 ? 0 : n2;
    }

    public int getScale(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.getScale", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        int n2 = 0;
        if (this.columnInfoArr == null) {
            throw TbError.newSQLException(-590784);
        }
        n2 = this.columnInfoArr[n - 1].getScale();
        return n2 < 0 ? 0 : n2;
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (this.columnInfoArr != null) {
            int n2 = this.columnInfoArr.length;
            if (n2 < 0) {
                throw TbError.newSQLException(-90607);
            }
            if (n <= 0 || n > n2) {
                throw TbError.newSQLException(-90609);
            }
        } else {
            throw TbError.newSQLException(-590784);
        }
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public String getTableName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isCaseSensitive", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        return DataType.isCharacterCategory(n2) || n2 == 13 || n2 == 10;
    }

    public boolean isCurrency(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isCurrency", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        return n2 == 1;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public int isNullable(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isNullable", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        if (this.columnInfoArr == null) {
            throw TbError.newSQLException(-590784);
        }
        boolean bl = this.columnInfoArr[n - 1].isNullable();
        return bl ? 1 : 0;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isSearchable", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        int n2 = this.getColumnDataType(n);
        return n2 != 11 && n2 != 10 && n2 != 12 && n2 != 13;
    }

    public boolean isSigned(int n) throws SQLException {
        Debug.logMethod("TbResultSetMetaData.isSigned", new Object[]{this, Integer.toString(n)});
        this.checkColumnIndex(n);
        return DataType.isNumberCategory(this.getColumnDataType(n));
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    public void reset() {
        this.columnInfoArr = null;
    }
}

