/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.driver.TbKeepAlive;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class TbKeepAlivePollingThread
extends Thread {
    private HashMap keepAliveSetMap;
    private long sleepMillis;

    public TbKeepAlivePollingThread() {
        super("TbKeepAlivePollingThread");
        Debug.logMethod("TbKeepAlivePollingThread", new String[]{"TbKeepAlivePollingThread"}, new Object[]{this});
        this.setDaemon(true);
        this.sleepMillis = 1000L;
        this.keepAliveSetMap = new HashMap();
        this.start();
    }

    public void run() {
        Debug.logMethod("TbKeepAlivePollingThread.run", new String[]{"TbKeepAlivePollingThread"}, new Object[]{this});
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.poll();
        }
    }

    private void poll() {
        Debug.logMethod("TbKeepAlivePollingThread.poll", new String[]{"TbKeepAlivePollingThread"}, new Object[]{this});
        Iterator iterator = this.keepAliveSetMap.entrySet().iterator();
        block6: while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            HashSet hashSet = (HashSet)entry.getValue();
            if (hashSet == null || hashSet.isEmpty()) continue;
            Iterator iterator2 = ((HashSet)entry.getValue()).iterator();
            while (iterator2.hasNext()) {
                TbKeepAlive tbKeepAlive = (TbKeepAlive)iterator2.next();
                long l = System.currentTimeMillis();
                try {
                    SocketChannel socketChannel = tbKeepAlive.getChannel();
                    if (socketChannel != null) {
                        TbKeepAlive tbKeepAlive2;
                        Iterator iterator3;
                        int n;
                        if (socketChannel.finishConnect()) {
                            n = tbKeepAlive.checkReply();
                            switch (n) {
                                case 1: {
                                    tbKeepAlive.closeCheckChannel(n);
                                    tbKeepAlive.resetBaseTime();
                                    break;
                                }
                                case 4: {
                                    Debug.log("reply from wrong server[" + entry.getKey() + "]");
                                    iterator3 = ((HashSet)this.keepAliveSetMap.get(entry.getKey())).iterator();
                                    while (iterator3.hasNext()) {
                                        tbKeepAlive2 = (TbKeepAlive)iterator3.next();
                                        tbKeepAlive2.closeCheckChannel(n);
                                        tbKeepAlive2.closeOrgConnSocket(n);
                                    }
                                    continue block6;
                                }
                            }
                            continue;
                        }
                        if (l - tbKeepAlive.getBaseTime() <= tbKeepAlive.getIntervalMillis()) continue;
                        n = 3;
                        if (tbKeepAlive.getTryCount() >= tbKeepAlive.getMaxRetryCount()) {
                            Debug.log("no reply[" + entry.getKey() + "]");
                            iterator3 = ((HashSet)this.keepAliveSetMap.get(entry.getKey())).iterator();
                            while (iterator3.hasNext()) {
                                tbKeepAlive2 = (TbKeepAlive)iterator3.next();
                                tbKeepAlive2.closeCheckChannel(n);
                                tbKeepAlive2.closeOrgConnSocket(n);
                            }
                            continue block6;
                        }
                        tbKeepAlive.closeCheckChannel(n);
                        tbKeepAlive.tryConnect();
                        continue;
                    }
                    if (l - tbKeepAlive.getBaseTime() <= tbKeepAlive.getIdleMillis()) continue;
                    tbKeepAlive.tryConnect();
                }
                catch (Throwable throwable) {
                    Debug.log("Exception occurred during keep alive check processing. Addr=" + tbKeepAlive.toString() + ", Exception=" + throwable.toString());
                    tbKeepAlive.closeCheckChannel(5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TbKeepAlive tbKeepAlive) {
        Debug.logMethod("TbKeepAlivePollingThread.remove", new String[]{"keepAlive"}, new Object[]{tbKeepAlive});
        HashMap hashMap = this.keepAliveSetMap;
        synchronized (hashMap) {
            String string = tbKeepAlive.getTargetAddressWithSvrInstId();
            HashSet<TbKeepAlive> hashSet = (HashSet<TbKeepAlive>)this.keepAliveSetMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<TbKeepAlive>();
                this.keepAliveSetMap.put(string, hashSet);
            }
            hashSet.add(tbKeepAlive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TbKeepAlive tbKeepAlive) {
        Debug.logMethod("TbKeepAlivePollingThread.remove", new String[]{"keepAlive"}, new Object[]{tbKeepAlive});
        HashMap hashMap = this.keepAliveSetMap;
        synchronized (hashMap) {
            String string = tbKeepAlive.getTargetAddressWithSvrInstId();
            if (string == null) {
                return;
            }
            HashSet hashSet = (HashSet)this.keepAliveSetMap.get(string);
            if (hashSet != null) {
                hashSet.remove(tbKeepAlive);
            }
        }
    }
}

