/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import java.sql.SQLException;

public class TCVN3CharToByteConverter {
    private static final short[] UNICODE_TO_TCVN3_IDX_PAGE1 = new short[]{63, 63, 162, 63, 63, 63, 63, 63, 63, 63, 163, 63, 63, 63, 63, 63, 63, 63, 63, 63, 164, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 181, 184, 169, 183, 63, 63, 63, 63, 204, 208, 170, 63, 215, 221, 63, 63, 63, 63, 223, 227, 171, 226, 63, 63, 63, 239, 243, 63, 63, 253, 63, 63};
    private static final char[] UNICODE_TO_TCVN3_IDX_PAGE2 = new char[]{'?', '?', '\u00a1', '\u00a8', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '\u00a7', '\u00ae', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '\u00dc', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '\u00f2', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '\u00a5', '\u00ac', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '\u00a6', '\u00ad', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?', '?'};
    private static final char[] UNICODE_TO_TCVN3_IDX_PAGE3 = new char[]{'?', '\u00b9', '?', '\u00b6', '?', '\u00ca', '?', '\u00c7', '?', '\u00c8', '?', '\u00c9', '?', '\u00cb', '?', '\u00be', '?', '\u00bb', '?', '\u00bc', '?', '\u00bd', '?', '\u00c6', '?', '\u00d1', '?', '\u00ce', '?', '\u00cf', '?', '\u00d5', '?', '\u00d2', '?', '\u00d3', '?', '\u00d4', '?', '\u00d6', '?', '\u00d8', '?', '\u00de', '?', '\u00e4', '?', '\u00e1', '?', '\u00e8', '?', '\u00e5', '?', '\u00e6', '?', '\u00e7', '?', '\u00e9', '?', '\u00ed', '?', '\u00ea', '?', '\u00eb', '?', '\u00ec', '?', '\u00ee', '?', '\u00f4', '?', '\u00f1', '?', '\u00f8', '?', '\u00f5', '?', '\u00f6', '?', '\u00f7', '?', '\u00f9', '?', '\u00fa', '?', '\u00fe', '?', '\u00fb', '?', '\u00fc', '?', '?', '?', '?', '?', '?'};
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};

    public boolean canConvert(char c) {
        return c < '\u0080' || c >= '\u00c0' && c < '\u00ff' || c >= '\u0100' && c < '\u01bf' || c >= '\u1ea0' && c < '\u1eff';
    }

    protected int convSingleByte(char c, byte[] byArray) {
        if (c < '\u0080') {
            byArray[0] = (byte)(c & 0x7F);
            return 1;
        }
        return 0;
    }

    public int convCharArr(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5 = n3;
        for (int i = n; i < n2 && n5 < n4; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                byArray[n5++] = (byte)c;
                continue;
            }
            int n6 = (short)c >= 192 && c < '\u00ff' ? (int)((char)UNICODE_TO_TCVN3_IDX_PAGE1[c - 192]) : (c >= '\u0100' && c < '\u01bf' ? UNICODE_TO_TCVN3_IDX_PAGE2[c - 256] : (c >= '\u1ea0' && c < '\u1eff' ? UNICODE_TO_TCVN3_IDX_PAGE3[c - 7840] : 63));
            byArray[n5++] = (byte)n6;
        }
        return n5 - n3;
    }

    public int convString(String string, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        return this.convCharArr(string.toCharArray(), n, n2, byArray, n3, n4);
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

