/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

import com.tmax.tibero.jdbc.data.charset.EUCJPCharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0201CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0208CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0212CharToByteConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0213ByteToCharConverter;
import com.tmax.tibero.jdbc.data.charset.JIS0213CharToByteConverter;
import com.tmax.tibero.jdbc.err.TbError;
import java.sql.SQLException;

public class EUCJPTILDECharToByteConverter
extends JIS0208CharToByteConverter {
    private JIS0201CharToByteConverter JIS0201cb = new JIS0201CharToByteConverter();
    private JIS0212CharToByteConverter JIS0212cb = new JIS0212CharToByteConverter();
    short[] JIS0208Index1 = super.getIndex1();
    String[] JIS0208Index2 = super.getIndex2();
    final int MAX_BYTE_SIZE = 3;
    static final int[][] EUC_JISX0213__COMP_TABLE_DATA = EUCJPCharToByteConverter.EUC_JISX0213__COMP_TABLE_DATA;
    static final int[] EUC_JISX0213__COMBINED_UNICODE_TABLE = EUCJPCharToByteConverter.EUC_JISX0213__COMBINED_UNICODE_TABLE;

    public boolean canConvert(char c) throws SQLException {
        byte[] byArray = new byte[3];
        return this.convSingleByte(c, byArray) != 0 || this.convDoubleByte(c) != 0;
    }

    protected int convDoubleByte(char c) throws SQLException {
        if (c == '\u301c' || c == '\uff5e') {
            int n = 161;
            int n2 = 193;
            return n << 8 | n2;
        }
        if (c == '\u2015') {
            c = (char)8212;
        }
        try {
            int n = this.JIS0208Index1[(c & 0xFF00) >> 8] << 8;
            int n3 = this.JIS0208Index2[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
            if (n3 != 0) {
                return n3 + 32896;
            }
            n3 = this.JIS0212cb.convDoubleByte(c);
            if (n3 == 0) {
                return n3;
            }
            return n3 + 0x8F8080;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw TbError.newSQLException(-590743, arrayIndexOutOfBoundsException.getMessage());
        }
    }

    public int getMaxBytesPerChar() {
        return 3;
    }

    protected int convSingleByte(char c, byte[] byArray) {
        if (c == '\u0000') {
            byArray[0] = 0;
            return 1;
        }
        byte by = this.JIS0201cb.getNative(c);
        if (by == 0) {
            return 0;
        }
        if (by > 0 && by < 128) {
            byArray[0] = by;
            return 1;
        }
        byArray[0] = -114;
        byArray[1] = by;
        return 2;
    }

    public int convCharArr(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws SQLException {
        int n5 = 0;
        int n6 = 0;
        byte[] byArray2 = new byte[3];
        n6 = n3;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int[] nArray = JIS0213CharToByteConverter.JISX0213__CJK_EXT_B_DATA;
        for (n5 = n; n5 < n2; ++n5) {
            int n10;
            int n11;
            char c = cArray[n5];
            int n12 = this.convSingleByte(c, byArray2);
            n7 = n8;
            n8 = this.parse(c, cArray, n5, n2);
            if ((n8 & 0xFFFF0000) >> 16 == 2) {
                for (n11 = 0; n11 < nArray.length; ++n11) {
                    if (nArray[n11] != n8) continue;
                    n10 = EUCJPCharToByteConverter.EUC_JISX0213__CJK_EXT_B_TABLE[n11];
                    if (n10 > 65535) {
                        byArray2[0] = (byte)((n10 & 0xFF0000) >> 16);
                        byArray2[1] = (byte)((n10 & 0xFF00) >> 8);
                        byArray2[2] = (byte)(n10 & 0xFF);
                        n12 = 3;
                    } else {
                        byArray2[0] = (byte)((n10 & 0xFF00) >> 8);
                        byArray2[1] = (byte)(n10 & 0xFF);
                        n12 = 2;
                    }
                    ++n5;
                }
            }
            if (n12 == 0) {
                n11 = this.convDoubleByte(c);
                if (n11 != 0) {
                    if (n11 == 9415105 && n2 - n5 > 1 && cArray[n5 + 1] == '\u0300') {
                        byArray2[0] = -85;
                        byArray2[1] = -60;
                        n12 = 2;
                        ++n5;
                    } else if ((n11 & 0xFF0000) == 0) {
                        byArray2[0] = (byte)((n11 & 0xFF00) >> 8);
                        byArray2[1] = (byte)(n11 & 0xFF);
                        n12 = 2;
                    } else {
                        byArray2[0] = -113;
                        byArray2[1] = (byte)((n11 & 0xFF00) >> 8);
                        byArray2[2] = (byte)(n11 & 0xFF);
                        n12 = 3;
                    }
                } else {
                    int n13;
                    if (n7 > 0) {
                        n10 = 0;
                        n13 = n7 << 16 | n8;
                        int[][] nArray2 = JIS0213ByteToCharConverter.JISX0213_TO_UCS__COMBINING;
                        for (int i = 0; i < nArray2.length; ++i) {
                            if (n13 != (nArray2[i][0] << 16 | nArray2[i][1])) continue;
                            n10 = EUC_JISX0213__COMBINED_UNICODE_TABLE[i];
                            break;
                        }
                        if (n10 > 0) {
                            byArray[n6 - n9] = (byte)(n10 >> 8 & 0xFF | 0x80);
                            byArray[n6 - n9 + 1] = (byte)(n10 & 0xFF | 0x80);
                            n6 -= n9 - 2;
                            continue;
                        }
                    }
                    if ((n11 = JIS0213CharToByteConverter.convFromUCS4(n8)) != 0) {
                        if (n11 == 741) {
                            n10 = 1;
                            n13 = 0;
                        } else if (n11 == 745) {
                            n10 = 1;
                            n13 = 1;
                        } else if (n11 == 768) {
                            n10 = 2;
                            n13 = 5;
                        } else if (n11 == 769) {
                            n10 = 7;
                            n13 = 4;
                        } else if (n11 == 12442) {
                            n10 = 11;
                            n13 = 14;
                        } else {
                            n10 = 0;
                            n13 = -1;
                        }
                        int n14 = n11 | 0x8080;
                        while (n13 > 0 && EUC_JISX0213__COMP_TABLE_DATA[n10][0] != n14) {
                            ++n10;
                            --n13;
                        }
                        if (n13 > 0) {
                            n14 = EUC_JISX0213__COMP_TABLE_DATA[n10][1];
                            byArray2[0] = (byte)(n14 >> 8 & 0xFF);
                            byArray2[1] = (byte)(n14 & 0xFF);
                            n12 += 2;
                        } else if ((n11 & 0x8000) != 0) {
                            byArray2[0] = -113;
                            byArray2[1] = (byte)(n11 >> 8 & 0xFF | 0x80);
                            byArray2[2] = (byte)(n11 & 0xFF | 0x80);
                            n12 = 3;
                        } else {
                            byArray2[0] = (byte)(n11 >> 8 & 0xFF | 0x80);
                            byArray2[1] = (byte)(n11 & 0xFF | 0x80);
                            n12 = 2;
                        }
                    } else {
                        throw TbError.newSQLException(-590714, "unknown character");
                    }
                }
            }
            n9 = n12;
            if (n4 - n6 < n12) {
                throw TbError.newSQLException(-590714, "Conversion buffer overflow");
            }
            for (n11 = 0; n11 < n12; ++n11) {
                byArray[n6++] = byArray2[n11];
            }
        }
        return n6 - n3;
    }
}

