/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbStruct;
import com.tmax.tibero.jdbc.TbStructDescriptor;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbSQLInput
implements SQLInput {
    private Map map;
    private Object[] attributes;
    private int[] attributeTypes;
    private int index;
    private TbStruct struct;
    private TbStructDescriptor descriptor;

    public TbSQLInput(Object[] objectArray, Map map) {
        this.map = map;
        this.attributes = objectArray;
        this.index = 0;
    }

    public TbSQLInput(TbStruct tbStruct, TbStructDescriptor tbStructDescriptor, Map map) throws SQLException {
        this.struct = tbStruct;
        this.descriptor = tbStructDescriptor;
        this.map = map;
        this.attributes = tbStruct.getAttributes();
        this.attributeTypes = tbStructDescriptor.getAttributeTypes();
        this.index = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readString() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("Invalid attributes");
            if (this.attributes[this.index] instanceof String) {
                String string;
                String string2 = string = (String)this.attributes[this.index];
                return string2;
            }
            if (this.attributes[this.index] instanceof Date) {
                Date date = (Date)this.attributes[this.index];
                String string = date.toString();
                return string;
            }
            if (this.attributes[this.index] instanceof Time) {
                Time time = (Time)this.attributes[this.index];
                String string = time.toString();
                return string;
            }
            if (this.attributes[this.index] instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)this.attributes[this.index];
                String string = timestamp.toString();
                return string;
            }
            if (this.attributes[this.index] instanceof Clob) {
                Clob clob = (Clob)this.attributes[this.index];
                String string = clob.getSubString(1L, (int)clob.length());
                return string;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readBoolean() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                boolean bl = string.equals("1");
                return bl;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer n = (Integer)this.attributes[this.index];
                boolean bl = n == 1;
                return bl;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long l = (Long)this.attributes[this.index];
                boolean bl = l.intValue() == 1;
                return bl;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float f = (Float)this.attributes[this.index];
                boolean bl = f.intValue() == 1;
                return bl;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double d = (Double)this.attributes[this.index];
                boolean bl = d.intValue() == 1;
                return bl;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte readByte() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)this.attributes[this.index];
                byte by = bigDecimal.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer n = (Integer)this.attributes[this.index];
                byte by = n.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long l = (Long)this.attributes[this.index];
                byte by = l.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float f = (Float)this.attributes[this.index];
                byte by = f.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double d = (Double)this.attributes[this.index];
                byte by = d.byteValue();
                return by;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                byte by = Byte.parseByte(string);
                return by;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public short readShort() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)this.attributes[this.index];
                short s = bigDecimal.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer n = (Integer)this.attributes[this.index];
                short s = n.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long l = (Long)this.attributes[this.index];
                short s = l.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float f = (Float)this.attributes[this.index];
                short s = f.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double d = (Double)this.attributes[this.index];
                short s = d.shortValue();
                return s;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                short s = Short.parseShort(string);
                return s;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int readInt() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)this.attributes[this.index];
                int n = bigDecimal.intValue();
                return n;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer n = (Integer)this.attributes[this.index];
                int n2 = n;
                return n2;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long l = (Long)this.attributes[this.index];
                int n = l.intValue();
                return n;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float f = (Float)this.attributes[this.index];
                int n = f.intValue();
                return n;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double d = (Double)this.attributes[this.index];
                int n = d.intValue();
                return n;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                int n = Integer.parseInt(string);
                return n;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long readLong() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)this.attributes[this.index];
                long l = bigDecimal.longValue();
                return l;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer n = (Integer)this.attributes[this.index];
                long l = n.longValue();
                return l;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long l = (Long)this.attributes[this.index];
                long l2 = l;
                return l2;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float f = (Float)this.attributes[this.index];
                long l = f.longValue();
                return l;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double d = (Double)this.attributes[this.index];
                long l = d.longValue();
                return l;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                long l = Long.parseLong(string);
                return l;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float readFloat() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)this.attributes[this.index];
                float f = bigDecimal.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer n = (Integer)this.attributes[this.index];
                float f = n.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long l = (Long)this.attributes[this.index];
                float f = l.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float f = (Float)this.attributes[this.index];
                float f2 = f.floatValue();
                return f2;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double d = (Double)this.attributes[this.index];
                float f = d.floatValue();
                return f;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                float f = Float.parseFloat(string);
                return f;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double readDouble() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)this.attributes[this.index];
                double d = bigDecimal.doubleValue();
                return d;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer n = (Integer)this.attributes[this.index];
                double d = n.doubleValue();
                return d;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long l = (Long)this.attributes[this.index];
                double d = l.doubleValue();
                return d;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float f = (Float)this.attributes[this.index];
                double d = f.doubleValue();
                return d;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double d = (Double)this.attributes[this.index];
                double d2 = d;
                return d2;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                double d = Double.parseDouble(string);
                return d;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BigDecimal readBigDecimal() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof BigDecimal) {
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2 = bigDecimal = (BigDecimal)this.attributes[this.index];
                return bigDecimal2;
            }
            if (this.attributes[this.index] instanceof Integer) {
                Integer n = (Integer)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal((double)n.intValue());
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof Long) {
                Long l = (Long)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(l.doubleValue());
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof Float) {
                Float f = (Float)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(f.doubleValue());
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof Double) {
                Double d = (Double)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(d);
                return bigDecimal;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                BigDecimal bigDecimal = new BigDecimal(string);
                return bigDecimal;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] readBytes() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof byte[]) {
                byte[] byArray = (byte[])this.attributes[this.index];
                return byArray;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                byte[] byArray = string.getBytes();
                return byArray;
            }
            if (this.attributes[this.index] instanceof Blob) {
                Blob blob = (Blob)this.attributes[this.index];
                byte[] byArray = blob.getBytes(1L, (int)blob.length());
                return byArray;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date readDate() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof Date) {
                Date date = (Date)this.attributes[this.index];
                return date;
            }
            if (this.attributes[this.index] instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)this.attributes[this.index];
                Date date = new Date(timestamp.getTime());
                return date;
            }
            if (this.attributes[this.index] instanceof TbDate) {
                TbDate tbDate = (TbDate)this.attributes[this.index];
                Calendar calendar = Calendar.getInstance();
                calendar.set(tbDate.getYear(), tbDate.getMonth(), tbDate.getDayOfMonth(), tbDate.getHourOfDay(), tbDate.getMinutes(), tbDate.getSeconds());
                Date date = new Date(calendar.getTimeInMillis());
                return date;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Time readTime() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof Time) {
                Time time = (Time)this.attributes[this.index];
                return time;
            }
            if (this.attributes[this.index] instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)this.attributes[this.index];
                Time time = new Time(timestamp.getTime());
                return time;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Timestamp readTimestamp() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)this.attributes[this.index];
                return timestamp;
            }
            if (this.attributes[this.index] instanceof Date) {
                Date date = (Date)this.attributes[this.index];
                Timestamp timestamp = new Timestamp(date.getTime());
                return timestamp;
            }
            if (this.attributes[this.index] instanceof Time) {
                Time time = (Time)this.attributes[this.index];
                Timestamp timestamp = new Timestamp(time.getTime());
                return timestamp;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Reader readCharacterStream() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof Clob) {
                Clob clob = (Clob)this.attributes[this.index];
                Reader reader = clob.getCharacterStream();
                return reader;
            }
            if (this.attributes[this.index] instanceof String) {
                String string = (String)this.attributes[this.index];
                StringReader stringReader = new StringReader(string);
                return stringReader;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream readAsciiStream() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof Clob) {
                Clob clob = (Clob)this.attributes[this.index];
                InputStream inputStream = clob.getAsciiStream();
                return inputStream;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputStream readBinaryStream() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof Blob) {
                Blob blob = (Blob)this.attributes[this.index];
                InputStream inputStream = blob.getBinaryStream();
                return inputStream;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    public Object readObject() throws SQLException {
        Object object = null;
        try {
            if (this.attributes[this.index] != null && this.attributes[this.index] instanceof TbStruct) {
                TbStructDescriptor[] tbStructDescriptorArray = this.descriptor.getSubStructDescriptor();
                object = tbStructDescriptorArray != null && tbStructDescriptorArray[this.index] != null ? ((TbStruct)this.attributes[this.index]).toClass(tbStructDescriptorArray[this.index].getClass(this.map), this.map) : ((TbStruct)this.attributes[this.index]).toClass(this.map);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception.getMessage());
        }
        finally {
            ++this.index;
        }
        return object;
    }

    public Ref readRef() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Blob readBlob() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof Blob) {
                Blob blob = (Blob)this.attributes[this.index];
                return blob;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Clob readClob() throws SQLException {
        try {
            if (this.attributes[this.index] == null) throw new SQLException("invalid attribute");
            if (this.attributes[this.index] instanceof Clob) {
                Clob clob = (Clob)this.attributes[this.index];
                return clob;
            }
            try {
                throw new SQLException("Can't convert to type");
            }
            catch (Exception exception) {
                throw new SQLException(exception.getMessage());
            }
        }
        finally {
            ++this.index;
        }
    }

    public Array readArray() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public boolean wasNull() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public URL readURL() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public String readNString() throws SQLException {
        throw TbError.newSQLException(-90201);
    }
}

