/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class TbLobInputStream
extends InputStream {
    private TbLob lob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private int fetchedSize = 0;
    private long totalSize = 0L;
    private long totalFetchedSize = 0L;
    private char[] charBuf = null;
    private byte[] byteBuf = null;
    private boolean isBlob = false;
    private boolean opened = false;

    public TbLobInputStream(TbLob tbLob, long l, long l2) throws SQLException {
        Debug.logMethod("TbLobInputStream", new Object[]{this, tbLob, Long.toString(l), Long.toString(l2)});
        if (tbLob == null) {
            throw TbError.newSQLException(-590767);
        }
        this.lob = tbLob;
        this.bufOffset = 0;
        this.lobOffset = l - 1L;
        this.fetchedSize = 0;
        this.totalSize = l2;
        this.totalFetchedSize = 0L;
        this.opened = true;
        if (tbLob instanceof TbClobBase) {
            this.charBuf = new char[TbLob.getMaxChunkSize()];
            this.isBlob = false;
        } else if (tbLob instanceof TbBlob) {
            this.byteBuf = new byte[TbLob.getMaxChunkSize()];
            this.isBlob = true;
        } else {
            throw TbError.newSQLException(-590770, tbLob.toString());
        }
    }

    void checkClosed() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    public void close() throws IOException {
        Debug.logMethod("TbLobInputStream.close", new Object[]{this, this.lob});
        this.opened = false;
    }

    private int getRemainedBufferSize() {
        return this.fetchedSize - this.bufOffset;
    }

    public char[] getCharBuf() {
        return this.charBuf;
    }

    public int read() throws IOException {
        Debug.logMethod("TbLobInputStream.read", new Object[]{this, this.lob});
        int n = 0;
        this.checkClosed();
        if (this.getRemainedBufferSize() == 0) {
            if (this.lob.isEndOfStream()) {
                return -1;
            }
            try {
                this.readNextBuffer();
                return this.read();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
        n = this.isBlob ? this.byteBuf[this.bufOffset++] : this.charBuf[this.bufOffset++];
        if (n < 0) {
            n += 256;
        }
        return n;
    }

    private void readNextBuffer() throws SQLException {
        long l = 0L;
        long l2 = this.totalSize - this.totalFetchedSize;
        if (this.isBlob) {
            if ((long)this.byteBuf.length < l2) {
                l = ((TbBlob)this.lob).getBytes(this.lobOffset + 1L, this.byteBuf);
            } else {
                l = ((TbBlob)this.lob).getBytes(this.lobOffset + 1L, this.byteBuf, 0L, l2);
                this.lob.setEndOfStream(true);
            }
        } else {
            l = ((TbClob)this.lob).getChars(this.lobOffset + 1L, this.charBuf);
        }
        this.totalFetchedSize += l;
        this.fetchedSize = (int)l;
        this.lobOffset += l;
        this.bufOffset = 0;
    }
}

