/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.Debug;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;

public class TbClobWriter
extends Writer {
    private TbClobBase clob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private boolean opened = false;
    private char[] charBuf = null;

    public TbClobWriter(TbClobBase tbClobBase, long l) throws SQLException {
        Debug.logMethod("TbClobWriter", new Object[]{this, tbClobBase, Long.toString(l)});
        if (tbClobBase == null) {
            throw TbError.newSQLException(-590767);
        }
        if (l < 1L) {
            throw TbError.newSQLException(-590764, l);
        }
        this.clob = tbClobBase;
        this.lobOffset = l;
        this.bufOffset = 0;
        this.opened = true;
        this.charBuf = new char[TbLob.getMaxChunkSize()];
    }

    private void checkClosed() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    public void close() throws IOException {
        Debug.logMethod("TbClobWriter.close", new Object[]{this, this.clob});
        this.checkClosed();
        try {
            this.flushBuffer();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        this.opened = false;
    }

    public void flush() throws IOException {
        Debug.logMethod("TbClobWriter.flush", new Object[]{this, this.clob});
        this.checkClosed();
        try {
            this.flushBuffer();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    private void flushBuffer() throws SQLException {
        if (this.bufOffset > 0) {
            int n = this.clob.putChars(this.lobOffset, this.charBuf, 0L, this.bufOffset);
            this.lobOffset += (long)n;
            this.bufOffset = 0;
        }
    }

    private int getRemainedInBuffer() {
        return TbLob.getMaxChunkSize() - this.bufOffset;
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3;
        Debug.logMethod("TbClobWriter.write", new Object[]{this, this.clob, cArray, Integer.toString(n), Integer.toString(n2)});
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.checkClosed();
        int n4 = this.getRemainedInBuffer();
        int n5 = n;
        for (int i = n2; i > 0; i -= n3) {
            n3 = n4 > i ? i : n4;
            System.arraycopy(cArray, n5, this.charBuf, this.bufOffset, n3);
            n5 += n3;
            this.bufOffset += n3;
            if ((n4 -= n3) != 0) continue;
            try {
                this.flushBuffer();
                n4 = this.getRemainedInBuffer();
                continue;
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
    }
}

