/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.util.TbDatabaseMetaQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public class TbArrayDescriptor {
    private String owner;
    private String packageName;
    private String typeName;
    private TbConnection conn;
    private String udtTypeName;
    private int packageId;
    private int packgeMemberNo;
    private int kind;
    private int elementType;
    private int elementsLimit;
    private boolean initialized;

    public TbArrayDescriptor(String string, String string2, String string3, Connection connection) throws SQLException {
        this.conn = (TbConnection)connection;
        if (string != null) {
            this.owner = string.toUpperCase();
        }
        if (string3 != null) {
            this.typeName = string3.toUpperCase();
        }
        if (string2 != null) {
            this.packageName = string2.toUpperCase();
        }
        this.udtTypeName = TbArrayDescriptor.makeUdtName(string, string2, string3);
        if (!this.initialized) {
            this.initPsmUdtInfo();
        }
    }

    public TbArrayDescriptor(String string, Connection connection) throws SQLException {
        this.conn = (TbConnection)connection;
        this.udtTypeName = string.toUpperCase();
        this.parseSQLTypeName(string);
        if (!this.initialized) {
            this.initPsmUdtInfo();
        }
    }

    protected TbArrayDescriptor(int n, int n2, int n3) {
        this.kind = n;
        this.elementType = n2;
        this.elementsLimit = n3;
    }

    public static TbArrayDescriptor createDescriptor(String string, String string2, String string3, Connection connection) throws SQLException {
        if (string == null || string.length() == 0 || string3 == null || string3.length() == 0 || string3 == null || string3.length() == 0 || connection == null) {
            throw new IllegalArgumentException();
        }
        String string4 = TbArrayDescriptor.makeUdtName(string, string2, string3).toUpperCase();
        TbArrayDescriptor tbArrayDescriptor = (TbArrayDescriptor)((TbConnection)connection).getDescriptor(string4);
        if (tbArrayDescriptor == null) {
            tbArrayDescriptor = new TbArrayDescriptor(string4, connection);
            ((TbConnection)connection).putDescriptor(string4, tbArrayDescriptor);
        }
        return tbArrayDescriptor;
    }

    public static TbArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            throw new IllegalArgumentException();
        }
        String string2 = string.toUpperCase();
        TbArrayDescriptor tbArrayDescriptor = (TbArrayDescriptor)((TbConnection)connection).getDescriptor(string2);
        if (tbArrayDescriptor == null) {
            tbArrayDescriptor = new TbArrayDescriptor(string2, connection);
            ((TbConnection)connection).putDescriptor(string2, tbArrayDescriptor);
        }
        return tbArrayDescriptor;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPsmUdtInfo() throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String string = this.getPackageName();
            String string2 = this.getTypeName();
            String string3 = this.getOwner();
            statement = this.conn.prepareStatement(TbDatabaseMetaQuery.QUERY_UDT_PSMDEF);
            statement.setString(1, string2);
            statement.setString(2, string);
            statement.setString(3, string3);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                this.kind = resultSet.getInt(1);
                if (this.kind != 29 && this.kind != 30) {
                    throw TbError.newSQLException(-590703, "PSM_MEMBER_KIND=" + resultSet.getInt(2));
                }
            } else {
                throw TbError.newSQLException(-590703, "Type does not exist : " + this.udtTypeName);
            }
            this.elementsLimit = resultSet.getInt(3);
            this.elementType = resultSet.getInt(5);
            this.packgeMemberNo = resultSet.getInt(8);
            this.packageId = resultSet.getInt(9);
            this.initialized = true;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int getKind() {
        return this.kind;
    }

    public int getBaseType() throws SQLException {
        return DataType.getSqlType(this.elementType);
    }

    public int getElementType() {
        return this.elementType;
    }

    public int getElementsLimit() {
        return this.elementsLimit;
    }

    public int getPackageId() {
        return this.packageId;
    }

    public int getPackageMemberNo() {
        return this.packgeMemberNo;
    }

    public String getUDTTypeName() {
        return this.udtTypeName;
    }

    private static String makeUdtName(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(".");
        if (string2 != null) {
            stringBuffer.append(string2).append(".");
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    private int parseSQLTypeName(String string) throws SQLException {
        String string2 = ".";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n == 2) {
            this.owner = stringTokenizer.nextToken().toUpperCase();
            this.typeName = stringTokenizer.nextToken().toUpperCase();
            this.packageName = null;
        } else if (n == 3) {
            this.owner = stringTokenizer.nextToken().toUpperCase();
            this.packageName = stringTokenizer.nextToken().toUpperCase();
            this.typeName = stringTokenizer.nextToken().toUpperCase();
        } else {
            throw new SQLException("Invalid type name : " + string);
        }
        return n;
    }
}

