/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbRowId;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.Row;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbRSSensitive;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.driver.TbResultSetBase;
import com.tmax.tibero.jdbc.driver.TbResultSetMetaData;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class TbRSUpdatable
extends TbResultSet {
    private TbResultSetBase rset = null;
    private boolean onInserting = false;
    private boolean onUpdating = false;
    private Object[] columnBuffer = null;
    private int[] columnLength = null;
    private boolean[] hasChanged = null;
    private int columnCount = 0;
    private int beginColumnIndex = 0;
    private boolean lastColumnWasNull = false;

    protected TbRSUpdatable(TbResultSetBase tbResultSetBase, RsetType rsetType) throws SQLException {
        super(rsetType);
        if (tbResultSetBase == null) {
            throw TbError.newSQLException(-90607);
        }
        this.rset = tbResultSetBase;
        this.beginColumnIndex = tbResultSetBase.getBeginColumnIndex();
        this.columnCount = tbResultSetBase.getColumnCount() + this.beginColumnIndex;
        this.rsetType = rsetType;
    }

    @Override
    public synchronized boolean absolute(int n) throws SQLException {
        this.cancelChanges();
        return this.rset.absolute(n);
    }

    @Override
    public synchronized void afterLast() throws SQLException {
        this.cancelChanges();
        this.rset.afterLast();
    }

    @Override
    public synchronized void beforeFirst() throws SQLException {
        this.cancelChanges();
        this.rset.beforeFirst();
    }

    private void bindInsertRowChangedData(TbPreparedStatement tbPreparedStatement) throws SQLException {
        int n = this.hasChanged.length;
        int n2 = 1;
        if (this.rset.stmt instanceof ParamContainer) {
            n2 = ((ParamContainer)((Object)this.rset.stmt)).getParameterCnt() + 1;
        }
        for (int i = this.beginColumnIndex; i < n; ++i) {
            if (this.hasChanged[i]) {
                Object object = this.columnBuffer[i];
                if (object instanceof Clob) {
                    tbPreparedStatement.setClob(n2, (Clob)object);
                } else if (object instanceof Blob) {
                    tbPreparedStatement.setBlob(n2, (Blob)object);
                } else if (object instanceof Reader) {
                    tbPreparedStatement.setCharacterStream(n2, (Reader)object, this.columnLength[i]);
                } else if (object instanceof InputStream) {
                    tbPreparedStatement.setBinaryStream(n2, (InputStream)object, this.columnLength[i]);
                } else if (object instanceof byte[]) {
                    int n3 = this.rset.getColumnDataType(this.getRevisedColumnIndex(i));
                    if (this.columnLength[i] == 0) {
                        tbPreparedStatement.setBytes(n2, n3, null);
                    } else {
                        tbPreparedStatement.setBytes(n2, n3, (byte[])object);
                    }
                }
                ++n2;
                continue;
            }
            tbPreparedStatement.setBytes(n2, this.rset.getColumnDataType(n2), null);
        }
    }

    private void bindUpdateRowChangedData(TbPreparedStatement tbPreparedStatement) throws SQLException {
        int n = this.hasChanged.length;
        int n2 = 1;
        if (this.rset.stmt instanceof ParamContainer) {
            n2 = ((ParamContainer)((Object)this.rset.stmt)).getParameterCnt() + 1;
        }
        for (int i = this.beginColumnIndex; i < n; ++i) {
            if (this.hasChanged[i]) {
                Object object = this.columnBuffer[i];
                if (object instanceof Clob) {
                    tbPreparedStatement.setClob(n2, (Clob)object);
                } else if (object instanceof Blob) {
                    tbPreparedStatement.setBlob(n2, (Blob)object);
                } else if (object instanceof Reader) {
                    tbPreparedStatement.setCharacterStream(n2, (Reader)object, this.columnLength[i]);
                } else if (object instanceof InputStream) {
                    tbPreparedStatement.setBinaryStream(n2, (InputStream)object, this.columnLength[i]);
                } else if (object instanceof byte[]) {
                    int n3 = this.rset.getColumnDataType(this.getRevisedColumnIndex(i));
                    if (this.columnLength[i] == 0) {
                        tbPreparedStatement.setBytes(n2, n3, null);
                    } else {
                        tbPreparedStatement.setBytes(n2, n3, (byte[])object);
                    }
                }
                ++n2;
                continue;
            }
            tbPreparedStatement.setBytes(n2, this.rset.getColumnDataType(n2), null);
        }
        tbPreparedStatement.setBytes(n2, 3, this.rset.getColumnRawData(0));
    }

    @Override
    public void buildRowTable(int n, byte[] byArray) throws SQLException {
        this.rset.buildRowTable(n, byArray);
    }

    protected void cancelChanges() throws SQLException {
        if (this.onInserting) {
            this.cancelRowInserts();
        }
        if (this.onUpdating) {
            this.cancelRowUpdates();
        }
    }

    protected void cancelRowInserts() throws SQLException {
        this.onInserting = false;
        this.resetBuffer();
    }

    @Override
    public synchronized void cancelRowUpdates() throws SQLException {
        this.onUpdating = false;
        this.resetBuffer();
    }

    void checkColumnIndex(int n) throws SQLException {
        int n2 = this.getColumnCount();
        if (n2 < 0) {
            throw TbError.newSQLException(-90607);
        }
        if (n <= 0 || n > n2) {
            throw TbError.newSQLException(-90609);
        }
    }

    protected void checkUpdateCursorPosition() throws SQLException {
        if (this.isBeforeFirst() || this.isAfterLast()) {
            throw TbError.newSQLException(-90624);
        }
        this.onUpdating = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            if (this.rset != null) {
                this.rset.close();
            }
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteRow() throws SQLException {
        if (this.onInserting) {
            throw TbError.newSQLException(-590773);
        }
        TbPreparedStatement tbPreparedStatement = null;
        try {
            tbPreparedStatement = this.getDeleteRowStatement();
            int n = tbPreparedStatement.executeUpdate();
            if (n <= 0) {
                throw TbError.newSQLException(-590777, n);
            }
            if (n > 1) {
                throw TbError.newSQLException(-590778, n);
            }
            this.rset.removeCurrentRow();
        }
        finally {
            if (tbPreparedStatement != null) {
                try {
                    tbPreparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized int findColumn(String string) throws SQLException {
        return this.rset.findColumn(string);
    }

    @Override
    public synchronized boolean first() throws SQLException {
        this.cancelChanges();
        return this.rset.first();
    }

    private int getRevisedColumnIndex(int n) throws SQLException {
        int n2 = n + this.beginColumnIndex - 1;
        this.checkColumnIndex(n2);
        return n2;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw TbError.newSQLException(-590726);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.getBigDecimal(n, 0);
    }

    @Override
    @Deprecated
    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toBigDecimal(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            if (object instanceof Blob) {
                return ((TbBlob)object).getBinaryStream();
            }
            throw TbError.newSQLException(-590705, object.toString());
        }
        return this.rset.getBinaryStream(n);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof Blob) {
                return (Blob)object;
            }
            throw TbError.newSQLException(-590705, object.toString());
        }
        return this.rset.getBlob(n);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public synchronized boolean getBoolean(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return false;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toBoolean(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getBoolean(n);
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public synchronized byte getByte(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return 0;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toByte(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getByte(n);
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public synchronized byte[] getBytes(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toBytes(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n), false);
        }
        return this.rset.getBytes(n);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public synchronized Reader getCharacterStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof Reader) {
                return (Reader)object;
            }
            if (object instanceof Clob) {
                return ((TbClob)object).getCharacterStream();
            }
            throw TbError.newSQLException(-590705, object.toString());
        }
        return this.rset.getCharacterStream(n);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof Clob) {
                return (Clob)object;
            }
            throw TbError.newSQLException(-590705, object.toString());
        }
        return this.rset.getClob(n);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Column[] getCols() {
        return this.rset.getCols();
    }

    public int getColumnCount() {
        return this.rset.getColumnCount();
    }

    @Override
    protected int getColumnDataType(int n) throws SQLException {
        return this.rset.getColumnDataType(n);
    }

    @Override
    protected int getColumnMaxLength(int n) throws SQLException {
        return this.rset.getColumnMaxLength(n);
    }

    @Override
    protected String getColumnName(int n) throws SQLException {
        return this.rset.getColumnName(n);
    }

    @Override
    protected boolean getColumnNullable(int n) throws SQLException {
        return this.rset.getColumnNullable(n);
    }

    @Override
    protected int getColumnPrecision(int n) throws SQLException {
        return this.rset.getColumnPrecision(n);
    }

    @Override
    protected int getColumnScale(int n) throws SQLException {
        return this.rset.getColumnScale(n);
    }

    @Override
    protected int getColumnSqlType(int n) throws SQLException {
        return this.rset.getColumnSqlType(n);
    }

    protected Row getCurrentRow() throws SQLException {
        return this.rset.getCurrentRow();
    }

    private int getColumnOffset(Row row, int n) {
        return row.getColumnOffset(n + this.beginColumnIndex);
    }

    private int getColumnLength(Row row, int n) {
        return row.getColumnLength(n + this.beginColumnIndex);
    }

    @Override
    public String getCursorName() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized Date getDate(int n) throws SQLException {
        return this.getDateInternal(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDateInternal(n);
        if (calendar != null) {
            calendar.setTime(date);
            date = (Date)calendar.getTime();
        }
        return date;
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    private Date getDateInternal(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toDate(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getDate(n);
    }

    @Override
    public TbDate getTbDate(int n) throws SQLException {
        return this.getTbDateInternal(n);
    }

    private TbDate getTbDateInternal(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Row row = this.getCurrentRow();
            return this.rset.typeConverter.toTbDate(this.getRowChunk(n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
        }
        return this.rset.getTbDate(n);
    }

    private TbPreparedStatement getDeleteRowStatement() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DELETE FROM ( ");
        stringBuffer.append(this.rset.stmt.getOriginalSql());
        stringBuffer.append(" ) WHERE ROWIDTOCHAR(ROWID) = ? ");
        TbPreparedStatement tbPreparedStatement = new TbPreparedStatement(this.rset.stmt.conn, stringBuffer.toString());
        if (this.rset.stmt instanceof ParamContainer) {
            tbPreparedStatement.impl().copyBindParamInfo((ParamContainer)((Object)this.rset.stmt));
            tbPreparedStatement.setBytes(((ParamContainer)((Object)this.rset.stmt)).getParameterCnt() + 1, 3, this.rset.getColumnRawData(0));
        } else {
            tbPreparedStatement.setBytes(1, 3, this.rset.getColumnRawData(0));
        }
        return tbPreparedStatement;
    }

    @Override
    public synchronized double getDouble(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return 0.0;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toDouble(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getDouble(n);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        return this.rset.getFetchDirection();
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        return this.rset.getFetchSize();
    }

    @Override
    public synchronized float getFloat(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return 0.0f;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toFloat(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getFloat(n);
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    private TbPreparedStatement getInsertRowStatement() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ( ");
        stringBuffer.append(this.rset.stmt.getOriginalSql());
        stringBuffer.append(" ) VALUES ( ");
        int n = this.hasChanged.length;
        for (int i = this.beginColumnIndex; i < n; ++i) {
            if (i != this.beginColumnIndex) {
                stringBuffer.append(" , ");
            }
            stringBuffer.append("?");
        }
        stringBuffer.append(" ) ");
        TbPreparedStatement tbPreparedStatement = new TbPreparedStatement(this.rset.stmt.conn, stringBuffer.toString());
        if (this.rset.stmt instanceof ParamContainer) {
            tbPreparedStatement.impl().copyBindParamInfo((ParamContainer)((Object)this.rset.stmt));
        }
        return tbPreparedStatement;
    }

    @Override
    public synchronized int getInt(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return 0;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toInt(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getInt(n);
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public synchronized long getLong(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return 0L;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toLong(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getLong(n);
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TbResultSetMetaData(this.rset.cols, this.rset.beginColumnIndex);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof Reader) {
                return (Reader)object;
            }
            if (object instanceof NClob) {
                return ((TbNClob)object).getCharacterStream();
            }
            throw TbError.newSQLException(-590705, object.toString());
        }
        return this.rset.getNCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof NClob) {
                return (NClob)object;
            }
            throw TbError.newSQLException(-590705, object.toString());
        }
        return this.rset.getNClob(n);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof TbNClob) {
                long l = ((TbNClob)object).length();
                return ((TbNClob)object).getSubString(1L, (int)l);
            }
            return this.rset.typeConverter.toString(object, 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.rset.getRsetType().isScrollable());
        }
        return this.rset.getNString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public synchronized Object getObject(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            this.rset.checkRsetAndConnClosed();
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof byte[]) {
                return this.rset.typeConverter.toObject(object, 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n), this.getColumnSqlType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.rset.getRsetType().isScrollable(), null, null, this.rset.stmt.conn.typeMap);
            }
            return object;
        }
        return this.rset.getObject(n);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public synchronized int getRow() throws SQLException {
        return this.rset.getRow();
    }

    @Override
    public byte[] getRowChunk(int n) {
        return this.rset.getRowChunk(n);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toRowId(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getRowId(n);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public synchronized short getShort(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return 0;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toShort(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getShort(n);
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toSQLXML(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n), false);
        }
        return this.rset.getSQLXML(n);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.rset.getStatement();
    }

    @Override
    public synchronized String getString(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof TbClobBase) {
                long l = ((TbClobBase)object).length();
                return ((TbClobBase)object).getSubString(1L, (int)l);
            }
            return this.rset.typeConverter.toString(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n), this.getColumnPrecision(n), this.getColumnScale(n), !this.rset.getRsetType().isScrollable());
        }
        return this.rset.getString(n);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public synchronized Time getTime(int n) throws SQLException {
        return this.getTimeInternal(n);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTimeInternal(n);
        if (calendar != null) {
            calendar.setTime(time);
            time = (Time)calendar.getTime();
        }
        return time;
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    private Time getTimeInternal(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toTime(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getTime(n);
    }

    @Override
    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestampInternal(n);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestampInternal(n);
        if (calendar != null) {
            calendar.setTime(timestamp);
            timestamp = (Timestamp)calendar.getTime();
        }
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    private Timestamp getTimestampInternal(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            return this.rset.typeConverter.toTimestamp(this.columnBuffer[this.getRevisedColumnIndex(n)], 0, this.columnLength[this.getRevisedColumnIndex(n)], this.getColumnDataType(n));
        }
        return this.rset.getTimestamp(n);
    }

    @Override
    public TbTimestamp getTbTimestamp(int n) throws SQLException {
        return this.getTbTimestampInternal(n);
    }

    private TbTimestamp getTbTimestampInternal(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Row row = this.getCurrentRow();
            return this.rset.typeConverter.toTbTimestamp(this.getRowChunk(n), this.getColumnOffset(row, n), this.getColumnLength(row, n), this.getColumnDataType(n));
        }
        return this.rset.getTbTimestamp(n);
    }

    @Override
    @Deprecated
    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        this.checkColumnIndex(n);
        if (this.setLastColumnWasNull(n)) {
            return null;
        }
        if (this.hasBufferChanged(n)) {
            Object object = this.columnBuffer[this.getRevisedColumnIndex(n)];
            if (object instanceof InputStream) {
                return (InputStream)object;
            }
            if (object instanceof byte[]) {
                return new ByteArrayInputStream((byte[])object);
            }
            throw TbError.newSQLException(-590705);
        }
        return this.rset.getAsciiStream(n);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    private TbPreparedStatement getUpdateRowStatement() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UPDATE ( ");
        stringBuffer.append(this.rset.stmt.getOriginalSql());
        stringBuffer.append(" ) SET ");
        int n = this.hasChanged.length;
        for (int i = 0; i < n; ++i) {
            if (!this.hasChanged[i]) continue;
            if (i != 0 && this.hasChanged[i - 1]) {
                stringBuffer.append(" , ");
            }
            stringBuffer.append(this.rset.getColumnName(i)).append(" = ? ");
        }
        stringBuffer.append(" WHERE ROWIDTOCHAR(ROWID) = ? ");
        TbPreparedStatement tbPreparedStatement = new TbPreparedStatement(this.rset.stmt.conn, stringBuffer.toString());
        if (this.rset.stmt instanceof ParamContainer) {
            tbPreparedStatement.impl().copyBindParamInfo((ParamContainer)((Object)this.rset.stmt));
        }
        return tbPreparedStatement;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    protected boolean hasBufferChanged(int n) throws SQLException {
        int n2 = n + this.beginColumnIndex - 1;
        this.checkColumnIndex(n2);
        return (this.onInserting || this.onUpdating) && this.hasChanged[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void insertRow() throws SQLException {
        if (!this.onInserting) {
            throw TbError.newSQLException(-590774);
        }
        TbPreparedStatement tbPreparedStatement = null;
        try {
            tbPreparedStatement = this.getInsertRowStatement();
            this.bindInsertRowChangedData(tbPreparedStatement);
            int n = tbPreparedStatement.executeUpdate();
            if (n <= 0) {
                throw TbError.newSQLException(-590779, n);
            }
            if (n > 1) {
                throw TbError.newSQLException(-590780, n);
            }
        }
        finally {
            if (tbPreparedStatement != null) {
                try {
                    tbPreparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized boolean isAfterLast() throws SQLException {
        if (this.onInserting) {
            return false;
        }
        return this.rset.isAfterLast();
    }

    @Override
    public synchronized boolean isBeforeFirst() throws SQLException {
        if (this.onInserting) {
            return false;
        }
        return this.rset.isBeforeFirst();
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public synchronized boolean isFirst() throws SQLException {
        if (this.onInserting) {
            return false;
        }
        return this.rset.isFirst();
    }

    @Override
    public synchronized boolean isLast() throws SQLException {
        if (this.onInserting) {
            return false;
        }
        return this.rset.isLast();
    }

    @Override
    public synchronized boolean last() throws SQLException {
        this.cancelChanges();
        return this.rset.last();
    }

    @Override
    public synchronized void moveToCurrentRow() throws SQLException {
        this.cancelRowInserts();
    }

    @Override
    public synchronized void moveToInsertRow() throws SQLException {
        if (this.onInserting) {
            return;
        }
        this.onInserting = true;
        if (this.columnBuffer == null) {
            this.columnBuffer = new Object[this.columnCount];
            this.columnLength = new int[this.columnCount];
            this.hasChanged = new boolean[this.columnCount];
        } else {
            this.resetBuffer();
        }
    }

    @Override
    public synchronized boolean next() throws SQLException {
        this.cancelChanges();
        return this.rset.next();
    }

    @Override
    public synchronized boolean previous() throws SQLException {
        this.cancelChanges();
        return this.rset.previous();
    }

    @Override
    public synchronized void refreshRow() throws SQLException {
        if (this.onInserting) {
            throw TbError.newSQLException(-590775);
        }
        this.rset.refreshRow();
    }

    @Override
    public synchronized boolean relative(int n) throws SQLException {
        this.cancelChanges();
        return this.rset.relative(n);
    }

    @Override
    public void reset() {
        super.reset();
        this.rset = null;
        this.columnBuffer = null;
        this.columnLength = null;
        this.hasChanged = null;
        this.lastColumnWasNull = false;
    }

    protected void resetBuffer() {
        if (this.columnBuffer != null) {
            for (int i = 0; i < this.columnCount - this.beginColumnIndex; ++i) {
                this.columnBuffer[i] = null;
                this.columnLength[i] = 0;
                this.hasChanged[i] = false;
            }
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    protected void setColumnBuffer(int n, int n2, Object object) throws SQLException {
        this.checkColumnIndex(n);
        if (this.columnBuffer == null) {
            this.columnBuffer = new Object[this.columnCount];
        }
        if (this.columnLength == null) {
            this.columnLength = new int[this.columnCount];
        }
        if (this.hasChanged == null) {
            this.hasChanged = new boolean[this.columnCount];
        }
        int n3 = this.getRevisedColumnIndex(n);
        this.hasChanged[n3] = true;
        this.columnLength[n3] = n2;
        this.columnBuffer[n3] = object;
    }

    @Override
    public synchronized void setFetchCompleted(int n) {
        this.rset.setFetchCompleted(n);
    }

    @Override
    public synchronized void setFetchDirection(int n) throws SQLException {
        this.rset.setFetchDirection(n);
    }

    @Override
    public synchronized void setFetchSize(int n) throws SQLException {
        this.rset.setFetchSize(n);
    }

    private boolean setLastColumnWasNull(int n) throws SQLException {
        this.lastColumnWasNull = this.getCurrentRow().isNull(n + this.beginColumnIndex);
        return this.lastColumnWasNull;
    }

    private void storeUpdatedRowChunk() throws SQLException {
        int n = this.hasChanged.length;
        Row row = this.rset.getCurrentRow();
        for (int i = 0; i < n; ++i) {
            if (!this.hasChanged[i]) continue;
            row.setUpdatedColumn(i + 1, this.columnLength[i], this.columnBuffer[i]);
        }
    }

    @Override
    public synchronized void updateArray(int n, Array array) throws SQLException {
        throw TbError.newSQLException(-590725);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(n, inputStream, n2);
    }

    @Override
    public synchronized void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, l);
        }
        this.updateBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkUpdateCursorPosition();
        if (bigDecimal == null) {
            this.updateNull(n);
            return;
        }
        byte[] byArray = this.rset.typeConverter.castFromBigDecimal(bigDecimal, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, inputStream);
        }
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null || n2 <= 0) {
            this.updateNull(n);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, n2, inputStream);
        }
    }

    @Override
    public synchronized void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (inputStream == null || l <= 0L) {
            this.updateNull(n);
        } else {
            if (l > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(l));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, (int)l, inputStream);
        }
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public synchronized void updateBlob(int n, Blob blob) throws SQLException {
        if (blob == null) {
            this.updateNull(n);
        } else {
            if (!(blob instanceof TbBlob)) {
                throw TbError.newSQLException(-590702, blob.toString());
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, blob);
        }
    }

    @Override
    public synchronized void updateBlob(int n, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.updateNull(n);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, inputStream);
        }
    }

    @Override
    public synchronized void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (inputStream == null || l <= 0L) {
            this.updateNull(n);
        } else {
            if (l > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(l));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, (int)l, inputStream);
        }
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromBoolean(bl, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public synchronized void updateByte(int n, byte by) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromByte(by, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        this.checkUpdateCursorPosition();
        if (byArray == null) {
            this.updateNull(n);
            return;
        }
        byte[] byArray2 = this.rset.typeConverter.castFromBytes(byArray, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray2.length, byArray2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader) throws SQLException {
        if (reader == null) {
            this.updateNull(n);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, reader);
        }
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null || n2 <= 0) {
            this.updateNull(n);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, reader);
        }
    }

    @Override
    public synchronized void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (reader == null || l <= 0L) {
            this.updateNull(n);
        } else {
            if (l > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(l));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, (int)l, reader);
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateClob(int n, Clob clob) throws SQLException {
        if (clob == null) {
            this.updateNull(n);
        } else {
            if (!(clob instanceof TbClobBase)) {
                throw TbError.newSQLException(-590702, clob.toString());
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, clob);
        }
    }

    @Override
    public synchronized void updateClob(int n, Reader reader) throws SQLException {
        if (reader == null) {
            this.updateNull(n);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, reader);
        }
    }

    @Override
    public synchronized void updateClob(int n, Reader reader, long l) throws SQLException {
        if (reader == null || l <= 0L) {
            this.updateNull(n);
        } else {
            if (l > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(l));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, (int)l, reader);
        }
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateDate(int n, Date date) throws SQLException {
        this.checkUpdateCursorPosition();
        if (date == null) {
            this.updateNull(n);
            return;
        }
        byte[] byArray = this.rset.typeConverter.castFromDate(date, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public synchronized void updateDouble(int n, double d) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromDouble(d, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public synchronized void updateFloat(int n, float f) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromFloat(f, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public synchronized void updateInt(int n, int n2) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromInt(n2, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public synchronized void updateLong(int n, long l) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromLong(l, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public synchronized void updateNCharacterStream(int n, Reader reader) throws SQLException {
        if (reader == null) {
            this.updateNull(n);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, reader);
        }
    }

    @Override
    public synchronized void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (reader == null || l <= 0L) {
            this.updateNull(n);
        } else {
            if (l > Integer.MAX_VALUE) {
                throw TbError.newSQLException(-90656, Long.toString(l));
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, (int)l, reader);
        }
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateNClob(int n, NClob nClob) throws SQLException {
        if (nClob == null) {
            this.updateNull(n);
        } else {
            if (!(nClob instanceof TbNClob)) {
                throw TbError.newSQLException(-590702, nClob.toString());
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, nClob);
        }
    }

    @Override
    public synchronized void updateNClob(int n, Reader reader) throws SQLException {
        this.updateNClob(n, reader, Integer.MAX_VALUE);
    }

    @Override
    public synchronized void updateNClob(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        if (reader == null || l <= 0L) {
            this.updateNull(n);
        } else {
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, reader);
        }
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(string), reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public synchronized void updateNString(int n, String string) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromString(string, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public synchronized void updateNull(int n) throws SQLException {
        this.checkUpdateCursorPosition();
        this.setColumnBuffer(n, 0, new byte[0]);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public synchronized void updateObject(int n, Object object) throws SQLException {
        this.updateObject(n, object, 0);
    }

    @Override
    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.updateNull(n);
            return;
        }
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromObject(object, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public synchronized void updateRef(int n, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateRow() throws SQLException {
        if (this.onInserting) {
            throw TbError.newSQLException(-590776);
        }
        TbPreparedStatement tbPreparedStatement = null;
        try {
            tbPreparedStatement = this.getUpdateRowStatement();
            this.bindUpdateRowChangedData(tbPreparedStatement);
            int n = tbPreparedStatement.executeUpdate();
            if (n <= 0) {
                throw TbError.newSQLException(-590781, n);
            }
            if (n > 1) {
                throw TbError.newSQLException(-590782, n);
            }
            if (this.rset instanceof TbRSSensitive) {
                ((TbRSSensitive)this.rset).refreshRowForced(1);
            }
            this.storeUpdatedRowChunk();
        }
        finally {
            if (tbPreparedStatement != null) {
                try {
                    tbPreparedStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized void updateRowId(int n, RowId rowId) throws SQLException {
        this.checkUpdateCursorPosition();
        if (!(rowId instanceof TbRowId)) {
            throw TbError.newSQLException(-590771, ((Object)rowId).toString());
        }
        byte[] byArray = rowId.getBytes();
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public synchronized void updateShort(int n, short s) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromShort(s, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public synchronized void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (sQLXML == null) {
            this.updateNull(n);
        } else {
            if (!(sQLXML instanceof TbSQLXML)) {
                throw TbError.newSQLException(-590702, sQLXML.toString());
            }
            this.checkUpdateCursorPosition();
            this.setColumnBuffer(n, Integer.MAX_VALUE, sQLXML);
        }
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public synchronized void updateString(int n, String string) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromString(string, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public synchronized void updateTime(int n, Time time) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromTime(time, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkUpdateCursorPosition();
        byte[] byArray = this.rset.typeConverter.castFromTimestamp(timestamp, this.rset.getColumnDataType(n));
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public synchronized void updateTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        this.checkUpdateCursorPosition();
        TbTimestamp tbTimestamp2 = new TbTimestamp(tbTimestamp.getBytes());
        byte[] byArray = tbTimestamp2.getBytes();
        this.setColumnBuffer(n, byArray.length, byArray);
    }

    @Override
    public void updateTbTimestamp(String string, TbTimestamp tbTimestamp) throws SQLException {
        this.updateTbTimestamp(this.findColumn(string), tbTimestamp);
    }

    @Override
    public synchronized boolean wasNull() throws SQLException {
        return this.lastColumnWasNull;
    }
}

