/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.driver;

import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbDatabaseMetaData;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbRowId;
import com.tmax.tibero.jdbc.TbSQLXML;
import com.tmax.tibero.jdbc.data.BatchInfo;
import com.tmax.tibero.jdbc.data.BatchUpdateInfo;
import com.tmax.tibero.jdbc.data.BigLiteral;
import com.tmax.tibero.jdbc.data.BindData;
import com.tmax.tibero.jdbc.data.BindItem;
import com.tmax.tibero.jdbc.data.BytesStreamWrapper;
import com.tmax.tibero.jdbc.data.Column;
import com.tmax.tibero.jdbc.data.DataType;
import com.tmax.tibero.jdbc.data.ParamContainer;
import com.tmax.tibero.jdbc.data.ReaderWrapper;
import com.tmax.tibero.jdbc.data.RsetType;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.data.TbDate;
import com.tmax.tibero.jdbc.data.TbTimestamp;
import com.tmax.tibero.jdbc.data.TbTimestampTZ;
import com.tmax.tibero.jdbc.data.binder.Binder;
import com.tmax.tibero.jdbc.data.binder.StaticBinder;
import com.tmax.tibero.jdbc.driver.TbConnection;
import com.tmax.tibero.jdbc.driver.TbParameterMetaData;
import com.tmax.tibero.jdbc.driver.TbResultSetFactory;
import com.tmax.tibero.jdbc.driver.TbResultSetMetaData;
import com.tmax.tibero.jdbc.driver.TbStatement;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.msg.TbColumnDesc;
import com.tmax.tibero.jdbc.util.TbSQLParser;
import com.tmax.tibero.jdbc.util.TbSQLTypeScanner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Vector;

public class TbPreparedStatementImpl
extends TbStatement
implements PreparedStatement,
ParamContainer {
    protected byte[] ppid;
    private static byte[] PPID_NULL = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected int bindParamCnt = 0;
    private int hiddenColCnt = 0;
    private int outColCnt = 0;
    private TbColumnDesc[] colMeta;
    private ResultSetMetaData resultSetMetaData;
    private String processedBigLiteralSql;
    private ArrayList<BigLiteral> bigLiterals;
    protected BindData bindData;
    private BatchUpdateInfo batchUpdateInfo;
    private int batchFlag = 256;
    protected int allocatedBatchRowCount = 1;
    protected int currentRowIndex = 0;
    private int[][] paramInt;
    private long[][] paramLong;
    private float[][] paramFloat;
    private double[][] paramDouble;
    private BigDecimal[][] paramBigDecimal;
    private String[][] paramString;
    private Timestamp[][] paramTimestamp;
    private TbTimestampTZ[][] paramTbTimestampTZ;
    private TbTimestamp[][] paramTbTimestamp;
    private TbDate[][] paramTbDate;
    private Calendar[][] paramCalendar;
    private byte[][][] paramBytes;
    private InputStream[][] paramStream;
    private Reader[][] paramReader;
    private byte[][] paramTypes;
    private Struct[][] paramStruct;
    private Array[][] paramArray;
    protected Binder[][] binder;
    protected Binder staticNullBinder;
    protected Binder staticStringBinder;
    protected Binder staticReaderBinder;
    protected Binder staticIntBinder;
    protected Binder staticLongBinder;
    protected Binder staticFloatBinder;
    protected Binder staticDoubleBinder;
    protected Binder staticBinaryFloatBinder;
    protected Binder staticBinaryDoubleBinder;
    protected Binder staticBigDecimalBinder;
    protected Binder staticDateBinder;
    protected Binder staticTimeBinder;
    protected Binder staticTimestampBinder;
    protected Binder staticTimestampTZBinder;
    protected Binder staticTbDateBinder;
    protected Binder staticTbTimestampBinder;
    protected Binder staticBytesBinder;
    protected Binder staticStreamBinder;
    protected Binder staticNStringBinder;
    protected Binder staticNReaderBinder;
    protected Binder staticStructBinder;
    protected Binder staticArrayBinder;
    private final int varcharMax = 4000;
    private final int deferrableStrLen = 4000 / Math.max(2, this.typeConverter.getMaxBytesPerChar()) + 1;
    private final int deferrableNStrLen = 4000 / Math.max(2, this.typeConverter.getMaxBytesPerNChar()) + 1;
    protected Object autoGenKeyArr;
    private boolean supportBinaryDoubleFloatType;

    private void initializeBinder(ServerInfo serverInfo) {
        this.supportBinaryDoubleFloatType = TbPreparedStatementImpl.isSupportBinaryDoubleFloatType(serverInfo);
        this.staticNullBinder = StaticBinder.getNullBinder();
        this.staticStringBinder = StaticBinder.getStringBinder();
        this.staticReaderBinder = StaticBinder.getReaderBinder();
        this.staticIntBinder = StaticBinder.getIntBinder();
        this.staticLongBinder = StaticBinder.getLongBinder();
        this.staticFloatBinder = StaticBinder.getFloatBinder();
        this.staticDoubleBinder = StaticBinder.getDoubleBinder();
        this.staticBinaryFloatBinder = StaticBinder.getBinaryFloatBinder(this.supportBinaryDoubleFloatType);
        this.staticBinaryDoubleBinder = StaticBinder.getBinaryDoubleBinder(this.supportBinaryDoubleFloatType);
        this.staticBigDecimalBinder = StaticBinder.getBigDecimalBinder();
        this.staticDateBinder = StaticBinder.getDateBinder();
        this.staticTimeBinder = StaticBinder.getTimeBinder();
        this.staticTimestampBinder = StaticBinder.getTimestampBinder();
        this.staticTimestampTZBinder = StaticBinder.getTbTimestampTZBinder();
        this.staticTbDateBinder = StaticBinder.getTbDateBinder();
        this.staticTbTimestampBinder = StaticBinder.getTbTimestampBinder();
        this.staticBytesBinder = StaticBinder.getBytesBinder();
        this.staticStreamBinder = StaticBinder.getStreamBinder();
        this.staticNStringBinder = StaticBinder.getNStringBinder();
        this.staticNReaderBinder = StaticBinder.getNReaderBinder();
        this.staticStructBinder = StaticBinder.getStructBinder();
        this.staticArrayBinder = StaticBinder.getArrayBinder();
    }

    public TbPreparedStatementImpl(TbConnection tbConnection, String string) throws SQLException {
        this(tbConnection, string, 1003, 1007, 64000, false);
        this.initializeBinder(tbConnection.getServerInfo());
    }

    public TbPreparedStatementImpl(TbConnection tbConnection, String string, int n, int n2, int n3, boolean bl) throws SQLException {
        super(tbConnection, n, n2, n3);
        this.poolable = tbConnection.info.isStmtCache();
        this.sqlTypeScanner = new TbSQLTypeScanner();
        this.initSql(string);
        if (bl) {
            this.forcePrepare();
        } else {
            this.initParameter();
        }
        this.initializeBinder(tbConnection.getServerInfo());
    }

    @Override
    public void addBatch() throws SQLException {
        int n = this.bindData.getDFRParameterCnt();
        for (int i = 0; i < this.bindParamCnt; ++i) {
            BindItem bindItem;
            if (this.binder[this.currentRowIndex][i] == null) {
                this.setCachedBindParameter(i);
            }
            if ((bindItem = this.bindData.getBindItem(i)).isOUTParameter()) {
                throw TbError.newSQLException(-90631);
            }
            if (n > 0 || this.paramTypes[0][i] == this.paramTypes[this.currentRowIndex][i]) continue;
            this.batchFlag = 0;
        }
        if (this.batchUpdateInfo == null) {
            this.batchUpdateInfo = new BatchUpdateInfo();
        }
        BindData bindData = new BindData();
        this.bindData.clone(bindData);
        this.bindData.clearDFRParameter();
        this.batchUpdateInfo.add(new BatchInfo(bindData, this.currentRowIndex));
        if (this.currentRowIndex == this.allocatedBatchRowCount - 1) {
            this.growBatchArray(this.allocatedBatchRowCount, 0);
        }
        ++this.currentRowIndex;
    }

    private void setCachedBindParameter(int n) throws SQLException {
        if (this.currentRowIndex > 0) {
            BindItem bindItem = this.bindData.getBindItem(n);
            int n2 = bindItem.getSQLType();
            block0 : switch (n2) {
                case 4: {
                    this.paramInt[this.currentRowIndex][n] = this.paramInt[this.currentRowIndex - 1][n];
                    break;
                }
                case -5: {
                    this.paramBigDecimal[this.currentRowIndex][n] = this.paramBigDecimal[this.currentRowIndex - 1][n];
                    break;
                }
                case 6: {
                    this.paramFloat[this.currentRowIndex][n] = this.paramFloat[this.currentRowIndex - 1][n];
                    break;
                }
                case 8: {
                    this.paramDouble[this.currentRowIndex][n] = this.paramDouble[this.currentRowIndex - 1][n];
                    break;
                }
                case 2: {
                    this.paramLong[this.currentRowIndex][n] = this.paramLong[this.currentRowIndex - 1][n];
                    break;
                }
                case 12: {
                    this.paramString[this.currentRowIndex][n] = this.paramString[this.currentRowIndex - 1][n];
                    break;
                }
                case -1: {
                    this.paramReader[this.currentRowIndex][n] = this.paramReader[this.currentRowIndex - 1][n];
                    break;
                }
                case 91: 
                case 92: {
                    byte by = this.paramTypes[this.currentRowIndex - 1][n];
                    switch (by) {
                        case 5: {
                            if (this.paramCalendar != null && this.paramCalendar[this.currentRowIndex - 1][n] != null) {
                                this.paramCalendar[this.currentRowIndex][n] = this.paramCalendar[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            if (this.paramTbDate != null && this.paramTbDate[this.currentRowIndex - 1][n] != null) {
                                this.paramTbDate[this.currentRowIndex][n] = this.paramTbDate[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(n2));
                        }
                        case 7: {
                            if (this.paramTimestamp != null && this.paramTimestamp[this.currentRowIndex - 1][n] != null) {
                                this.paramTimestamp[this.currentRowIndex][n] = this.paramTimestamp[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            if (this.paramTbTimestamp != null && this.paramTbTimestamp[this.currentRowIndex - 1][n] != null) {
                                this.paramTbTimestamp[this.currentRowIndex][n] = this.paramTbTimestamp[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(n2));
                        }
                    }
                    throw TbError.newSQLException(-590704, Integer.toString(n2));
                }
                case 93: {
                    byte by = this.paramTypes[this.currentRowIndex - 1][n];
                    switch (by) {
                        case 5: {
                            if (this.paramCalendar != null && this.paramCalendar[this.currentRowIndex - 1][n] != null) {
                                this.paramCalendar[this.currentRowIndex][n] = this.paramCalendar[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            if (this.paramTbDate != null && this.paramTbDate[this.currentRowIndex - 1][n] != null) {
                                this.paramTbDate[this.currentRowIndex][n] = this.paramTbDate[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            if (this.paramBytes != null && this.paramBytes[this.currentRowIndex - 1][n] != null) {
                                this.paramBytes[this.currentRowIndex][n] = this.paramBytes[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(n2));
                        }
                        case 7: {
                            if (this.paramTimestamp != null && this.paramTimestamp[this.currentRowIndex - 1][n] != null) {
                                this.paramTimestamp[this.currentRowIndex][n] = this.paramTimestamp[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            if (this.paramTbTimestamp != null && this.paramTbTimestamp[this.currentRowIndex - 1][n] != null) {
                                this.paramTbTimestamp[this.currentRowIndex][n] = this.paramTbTimestamp[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(n2));
                        }
                        case 21: {
                            if (this.paramTbTimestampTZ != null && this.paramTbTimestampTZ[this.currentRowIndex - 1][n] != null) {
                                this.paramTbTimestampTZ[this.currentRowIndex][n] = this.paramTbTimestampTZ[this.currentRowIndex - 1][n];
                                break block0;
                            }
                            throw TbError.newSQLException(-590704, Integer.toString(n2));
                        }
                    }
                    throw TbError.newSQLException(-590704, Integer.toString(n2));
                }
                case -2: {
                    this.paramBytes[this.currentRowIndex][n] = this.paramBytes[this.currentRowIndex - 1][n];
                    break;
                }
                case -4: {
                    this.paramStream[this.currentRowIndex][n] = this.paramStream[this.currentRowIndex - 1][n];
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw TbError.newSQLException(-590704, Integer.toString(n2));
                }
            }
        } else {
            throw TbError.newSQLException(-90627);
        }
        this.binder[this.currentRowIndex][n] = this.binder[this.currentRowIndex - 1][n];
        this.paramTypes[this.currentRowIndex][n] = this.paramTypes[this.currentRowIndex - 1][n];
    }

    private void addBigLiteral(ArrayList<BigLiteral> arrayList) throws SQLException {
        int n = arrayList.size();
        if (this.bindParamCnt == 0) {
            this.binder = new Binder[this.allocatedBatchRowCount][n];
            this.paramTypes = new byte[this.allocatedBatchRowCount][n];
            this.bindData = new BindData(n);
            for (int i = 0; i < n; ++i) {
                BigLiteral bigLiteral = arrayList.get(i);
                String string = bigLiteral.getLiteralValue();
                int n2 = bigLiteral.getLiteralIndex();
                if (this.paramReader == null) {
                    this.paramReader = new Reader[this.allocatedBatchRowCount][n];
                }
                this.bindData.setDFRParam(n2, -1, string.length());
                this.paramReader[this.currentRowIndex][n2] = new StringReader(string);
                this.paramTypes[this.currentRowIndex][n2] = 13;
                this.binder[this.currentRowIndex][n2] = this.staticReaderBinder;
            }
            return;
        }
        this.growBatchArray(0, n);
        this.bindData.resize(this.bindParamCnt + n);
        for (int i = 0; i < n; ++i) {
            BigLiteral bigLiteral = arrayList.get(i);
            int n3 = bigLiteral.getLiteralIndex();
            String string = bigLiteral.getLiteralValue();
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt + n];
            }
            if (n3 < this.bindParamCnt) {
                this.pushParamData(n, n3);
            }
            this.bindData.insertDFRLiteral(n3, -1, string.length());
            this.paramReader[this.currentRowIndex][n3] = new StringReader(string);
            this.paramTypes[this.currentRowIndex][n3] = 13;
            this.binder[this.currentRowIndex][n3] = this.staticReaderBinder;
        }
    }

    public void buildColMetaArray(int n, int n2, TbColumnDesc[] tbColumnDescArray) {
        this.outColCnt = n;
        this.hiddenColCnt = n2;
        this.colMeta = tbColumnDescArray;
    }

    protected void checkParameterIndex(int n) throws SQLException {
        if (n < 0 || n > this.bindParamCnt) {
            throw TbError.newSQLException(-90609);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.batchUpdateInfo != null) {
            this.batchUpdateInfo.clear();
        }
        for (int i = this.currentRowIndex; i >= 0; --i) {
            for (int j = 0; j < this.bindParamCnt; ++j) {
                this.binder[i][j] = null;
            }
        }
        this.currentRowIndex = 0;
    }

    private void clearBigLiteral(ArrayList<BigLiteral> arrayList) throws SQLException {
        int n = arrayList.size();
        int[] nArray = new int[n];
        block15: for (int i = n - 1; i >= 0; --i) {
            int n2;
            BigLiteral bigLiteral = arrayList.get(i);
            nArray[i] = bigLiteral.getLiteralIndex();
            BindItem bindItem = this.bindData.getBindItem(i);
            int n3 = bindItem.getSQLType();
            for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                this.binder[this.currentRowIndex][n2] = this.binder[this.currentRowIndex][n2 + 1];
                this.binder[this.currentRowIndex][n2 + 1] = null;
            }
            for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                this.paramTypes[this.currentRowIndex][n2] = this.paramTypes[this.currentRowIndex][n2 + 1];
            }
            switch (n3) {
                case 4: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramInt[this.currentRowIndex][n2] = this.paramInt[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case -5: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramBigDecimal[this.currentRowIndex][n2] = this.paramBigDecimal[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case 6: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramFloat[this.currentRowIndex][n2] = this.paramFloat[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case 8: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramDouble[this.currentRowIndex][n2] = this.paramDouble[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case 2: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramLong[this.currentRowIndex][n2] = this.paramLong[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case 12: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramString[this.currentRowIndex][n2] = this.paramString[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case -1: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramReader[this.currentRowIndex][n2] = this.paramReader[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case 91: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        if (this.paramTbDate == null) continue;
                        this.paramTbDate[this.currentRowIndex][n2] = this.paramTbDate[this.currentRowIndex][n2 + 1];
                    }
                }
                case 92: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        if (this.paramCalendar == null) continue;
                        this.paramCalendar[this.currentRowIndex][n2] = this.paramCalendar[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case 93: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        if (this.paramTimestamp != null) {
                            this.paramTimestamp[this.currentRowIndex][n2] = this.paramTimestamp[this.currentRowIndex][n2 + 1];
                        }
                        if (this.paramTbTimestamp != null) {
                            this.paramTbTimestamp[this.currentRowIndex][n2] = this.paramTbTimestamp[this.currentRowIndex][n2 + 1];
                        }
                        if (this.paramTbTimestampTZ == null) continue;
                        this.paramTbTimestampTZ[this.currentRowIndex][n2] = this.paramTbTimestampTZ[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case -2: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramBytes[this.currentRowIndex][n2] = this.paramBytes[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case -4: {
                    for (n2 = nArray[i]; n2 < this.bindParamCnt + n - 1; ++n2) {
                        this.paramStream[this.currentRowIndex][n2] = this.paramStream[this.currentRowIndex][n2 + 1];
                    }
                    continue block15;
                }
                case 0: {
                    continue block15;
                }
                default: {
                    throw TbError.newSQLException(-590704, Integer.toString(n3));
                }
            }
        }
        this.bindData.removeDFRLiteral(nArray);
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.bindData != null) {
            this.bindData.reuse();
        }
        for (int i = 0; i < this.bindParamCnt; ++i) {
            this.binder[this.currentRowIndex][i] = null;
        }
    }

    protected void copyBindParamInfo(ParamContainer paramContainer) throws SQLException {
        Reader[] readerArray;
        InputStream[] inputStreamArray;
        byte[][] byArray;
        TbTimestampTZ[] tbTimestampTZArray;
        TbTimestamp[] tbTimestampArray;
        TbDate[] tbDateArray;
        Timestamp[] timestampArray;
        Calendar[] calendarArray;
        String[] stringArray;
        BigDecimal[] bigDecimalArray;
        double[] dArray;
        float[] fArray;
        long[] lArray;
        int[] nArray;
        int n = paramContainer.getParameterCnt();
        this.getBindData().set(paramContainer.getBindData());
        Binder[][] binderArray = paramContainer.getBinder();
        this.binder = new Binder[this.allocatedBatchRowCount][this.bindParamCnt];
        if (binderArray != null) {
            for (int i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(binderArray[0], 0, this.binder[i], 0, n);
            }
        }
        byte[] byArray2 = paramContainer.getParamTypesOfRow(this.currentRowIndex);
        this.paramTypes = new byte[this.allocatedBatchRowCount][this.bindParamCnt];
        if (byArray2 != null) {
            System.arraycopy(byArray2, 0, this.paramTypes[this.currentRowIndex], 0, n);
        }
        if ((nArray = paramContainer.getParamIntOfRow(this.currentRowIndex)) != null) {
            this.paramInt = new int[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(nArray, 0, this.paramInt[this.currentRowIndex], 0, n);
        }
        if ((lArray = paramContainer.getParamLongOfRow(this.currentRowIndex)) != null) {
            this.paramLong = new long[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(lArray, 0, this.paramLong[this.currentRowIndex], 0, n);
        }
        if ((fArray = paramContainer.getParamFloatOfRow(this.currentRowIndex)) != null) {
            this.paramFloat = new float[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(fArray, 0, this.paramFloat[this.currentRowIndex], 0, n);
        }
        if ((dArray = paramContainer.getParamDoubleOfRow(this.currentRowIndex)) != null) {
            this.paramDouble = new double[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(lArray, 0, this.paramDouble[this.currentRowIndex], 0, n);
        }
        if ((bigDecimalArray = paramContainer.getParamBigDecimalOfRow(this.currentRowIndex)) != null) {
            this.paramBigDecimal = new BigDecimal[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(bigDecimalArray, 0, this.paramBigDecimal[this.currentRowIndex], 0, n);
        }
        if ((stringArray = paramContainer.getParamStringOfRow(this.currentRowIndex)) != null) {
            this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(stringArray, 0, this.paramString[this.currentRowIndex], 0, n);
        }
        if ((calendarArray = paramContainer.getParamCalendarOfRow(this.currentRowIndex)) != null) {
            this.paramCalendar = new Calendar[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(calendarArray, 0, this.paramCalendar[this.currentRowIndex], 0, n);
        }
        if ((timestampArray = paramContainer.getParamTimestampOfRow(this.currentRowIndex)) != null) {
            this.paramTimestamp = new Timestamp[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(timestampArray, 0, this.paramTimestamp[this.currentRowIndex], 0, n);
        }
        if ((tbDateArray = paramContainer.getParamTbDateOfRow(this.currentRowIndex)) != null) {
            this.paramTbDate = new TbDate[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tbDateArray, 0, this.paramTbDate[this.currentRowIndex], 0, n);
        }
        if ((tbTimestampArray = paramContainer.getParamTbTimestampOfRow(this.currentRowIndex)) != null) {
            this.paramTbTimestamp = new TbTimestamp[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tbTimestampArray, 0, this.paramTbTimestamp[this.currentRowIndex], 0, n);
        }
        if ((tbTimestampTZArray = paramContainer.getParamTbTimestampTZOfRow(this.currentRowIndex)) != null) {
            this.paramTbTimestampTZ = new TbTimestampTZ[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(tbTimestampTZArray, 0, this.paramTbTimestampTZ[this.currentRowIndex], 0, n);
        }
        if ((byArray = paramContainer.getParamBytesOfRow(this.currentRowIndex)) != null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
            System.arraycopy(byArray, 0, this.paramBytes[this.currentRowIndex], 0, n);
        }
        if ((inputStreamArray = paramContainer.getParamStreamOfRow(this.currentRowIndex)) != null) {
            this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(inputStreamArray, 0, this.paramStream[this.currentRowIndex], 0, n);
        }
        if ((readerArray = paramContainer.getParamReaderOfRow(this.currentRowIndex)) != null) {
            this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            System.arraycopy(readerArray, 0, this.paramReader[this.currentRowIndex], 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string) throws SQLException {
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = false;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (n == 2) {
            return this.execute(string);
        }
        if (n != 1) {
            TbError.newSQLException(-590733);
        }
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(null);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            TbError.newSQLException(-590732);
        }
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(nArray);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (stringArray == null || stringArray.length == 0) {
            TbError.newSQLException(-590734);
        }
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(stringArray);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        return this.currentRs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        Object object;
        int n = this.conn.typeConverter.getMaxBytesPerChar();
        this.checkConnectionOpen();
        this.initBeforeExecute();
        if (this.currentRowIndex == 0) {
            this.batchCounts = new int[0];
            return this.batchCounts;
        }
        if (this.originalSql.length() > 65535 / n) {
            object = new ArrayList<BigLiteral>();
            TbSQLParser.getBigLiteral(this.originalSql, n, object);
            if (((ArrayList)object).size() > 0) {
                throw TbError.newSQLException(-90652);
            }
        }
        try {
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
            }
            this.isExecuting = true;
            object = this.conn;
            synchronized (object) {
                this.batchCounts = this.conn.getTbComm().batchUpdateLoop(this, this.batchUpdateInfo);
            }
            object = this.batchCounts;
            return object;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
            this.clearBatch();
        }
    }

    private int executeBigLiteral(String string, ArrayList<BigLiteral> arrayList) throws SQLException {
        this.addBigLiteral(arrayList);
        try {
            int n = this.executeCompleteSQL(string);
            return n;
        }
        catch (SQLException sQLException) {
            this.ppid = null;
            throw sQLException;
        }
        finally {
            this.clearBigLiteral(arrayList);
        }
    }

    private void prepareBigLiteralInternal(String string, ArrayList<BigLiteral> arrayList) throws SQLException {
        this.addBigLiteral(arrayList);
        try {
            this.prepareSQLInternal(string);
        }
        catch (SQLException sQLException) {
            this.ppid = null;
            throw sQLException;
        }
        finally {
            this.clearBigLiteral(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeCompleteSQL(String string) throws SQLException {
        if (!this.isInsertStmt(string)) {
            this.returnAutoGeneratedKeys = false;
        }
        if (TbSQLTypeScanner.isQueryStmt(this.sqlType) && (this.userRsetType.getType() == 1005 || this.userRsetType.getConcurrency() == 1008)) {
            if (this.rsetTypeDowngraded) {
                this.realRsetType = RsetType.getDownGradedRsetType(this.userRsetType.getRank());
                TbConnection tbConnection = this.conn;
                synchronized (tbConnection) {
                    int n = this.conn.getTbComm().prepareExecute(this, string, this.currentRowIndex);
                    this.rsetTypeDowngraded = true;
                    return n;
                }
            }
            this.sqlWithRowId = this.getQueryWithRowId(string);
            try {
                this.realRsetType = this.userRsetType;
                TbConnection tbConnection = this.conn;
                synchronized (tbConnection) {
                    return this.conn.getTbComm().prepareExecute(this, this.sqlWithRowId, this.currentRowIndex);
                }
            }
            catch (SQLException sQLException) {
                this.realRsetType = RsetType.getDownGradedRsetType(this.userRsetType.getRank());
                TbConnection tbConnection = this.conn;
                synchronized (tbConnection) {
                    int n = this.conn.getTbComm().prepareExecute(this, string, this.currentRowIndex);
                    this.rsetTypeDowngraded = true;
                    return n;
                }
            }
        }
        if (TbSQLTypeScanner.isDMLStmt(this.sqlType) || !TbSQLTypeScanner.isQueryStmt(this.sqlType) && !TbSQLTypeScanner.isPSMStmt(this.sqlType)) {
            this.realRsetType = this.userRsetType;
            String string2 = string;
            if (this.returnAutoGeneratedKeys) {
                if (this.realRsetType.isSensitive() || this.realRsetType.isUpdatable()) {
                    this.realRsetType = RsetType.SIRD;
                }
                if (this.autoGenKeyArr == null) {
                    string2 = this.getAutoGenSql(this.originalSql);
                } else if (this.autoGenKeyArr instanceof int[]) {
                    string2 = this.getAutoGenSql(this.originalSql, (int[])this.autoGenKeyArr);
                } else if (this.autoGenKeyArr instanceof String[]) {
                    string2 = this.getAutoGenSql(this.originalSql, (String[])this.autoGenKeyArr);
                }
            }
            TbConnection tbConnection = this.conn;
            synchronized (tbConnection) {
                this.rowsUpdated = this.conn.getTbComm().prepareExecute(this, string2, this.currentRowIndex);
            }
            return this.rowsUpdated;
        }
        this.realRsetType = TbSQLTypeScanner.isPSMStmt(this.sqlType) && this.userRsetType.isScrollable() || this.userRsetType.isUpdatable() ? RsetType.getDownGradedRsetType(this.userRsetType.getRank()) : this.userRsetType;
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            return this.conn.getTbComm().prepareExecute(this, string, this.currentRowIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareSQLInternal(String string) throws SQLException {
        if (!this.isInsertStmt(string)) {
            this.returnAutoGeneratedKeys = false;
        }
        if (TbSQLTypeScanner.isQueryStmt(this.sqlType)) {
            this.realRsetType = this.userRsetType;
            Vector<Integer> vector = new Vector<Integer>();
            TbConnection tbConnection = this.conn;
            synchronized (tbConnection) {
                this.conn.getTbComm().prepare(this, string, vector);
            }
            this.allocatedBatchRowCount = 1;
            this.currentRowIndex = 0;
            this.bindData = new BindData(this.bindParamCnt);
            this.binder = new Binder[this.allocatedBatchRowCount][this.bindParamCnt];
            this.paramTypes = new byte[this.allocatedBatchRowCount][this.bindParamCnt];
            for (int i = 0; i < this.bindParamCnt; ++i) {
                int n = vector.get(i);
                DataType.checkValidDataType(n);
                this.paramTypes[this.currentRowIndex][i] = (byte)n;
            }
            vector.clear();
            vector = null;
        }
    }

    protected synchronized int executeInternal(String string) throws SQLException {
        int n = this.conn.typeConverter.getMaxBytesPerChar();
        if (string.length() > 65535 / n) {
            if (this.processedBigLiteralSql == null) {
                if (this.bigLiterals == null) {
                    this.bigLiterals = new ArrayList();
                }
                this.processedBigLiteralSql = TbSQLParser.getBigLiteral(string, n, this.bigLiterals);
            }
            if (this.bigLiterals.size() > 0) {
                return this.executeBigLiteral(this.processedBigLiteralSql, this.bigLiterals);
            }
        }
        try {
            return this.executeCompleteSQL(string);
        }
        catch (SQLException sQLException) {
            this.ppid = null;
            throw sQLException;
        }
    }

    protected synchronized void prepareInternal(String string) throws SQLException {
        int n = this.conn.typeConverter.getMaxBytesPerChar();
        if (string.length() > 65535 / n) {
            if (this.processedBigLiteralSql == null) {
                if (this.bigLiterals == null) {
                    this.bigLiterals = new ArrayList();
                }
                this.processedBigLiteralSql = TbSQLParser.getBigLiteral(string, n, this.bigLiterals);
            }
            if (this.bigLiterals.size() > 0) {
                this.prepareBigLiteralInternal(this.processedBigLiteralSql, this.bigLiterals);
            }
        }
        try {
            this.prepareSQLInternal(string);
        }
        catch (SQLException sQLException) {
            this.ppid = null;
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout > 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.currentRs == null) {
            this.currentRs = TbResultSetFactory.buildResultSet(this, -1, 0, 0);
        }
        return this.currentRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout > 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.executeInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
        if (this.currentRs == null) {
            this.currentRs = TbResultSetFactory.buildResultSet(this, -1, 0, 0);
        }
        return this.currentRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string) throws SQLException {
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = false;
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (n == 2) {
            return this.executeUpdate(string);
        }
        if (n != 1) {
            TbError.newSQLException(-590733);
        }
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(null);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n2 = this.executeInternal(this.originalSql);
            return n2;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray == null || nArray.length == 0) {
            TbError.newSQLException(-590732);
        }
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(nArray);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray == null || stringArray.length == 0) {
            TbError.newSQLException(-590732);
        }
        this.checkConnectionOpen();
        this.initSQLInfo(string);
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        this.returnAutoGeneratedKeys = true;
        this.setAutoGenKeyArr(stringArray);
        if (this.queryTimeout != 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            int n = this.executeInternal(this.originalSql);
            return n;
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout != 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcePrepare() throws SQLException {
        Vector<Integer> vector = new Vector<Integer>();
        TbConnection tbConnection = this.conn;
        synchronized (tbConnection) {
            this.conn.getTbComm().prepare(this, this.originalSql, vector);
        }
        this.allocatedBatchRowCount = 1;
        this.currentRowIndex = 0;
        this.bindData = new BindData(this.bindParamCnt);
        this.binder = new Binder[this.allocatedBatchRowCount][this.bindParamCnt];
        this.paramTypes = new byte[this.allocatedBatchRowCount][this.bindParamCnt];
        for (int i = 0; i < this.bindParamCnt; ++i) {
            int n = vector.get(i);
            DataType.checkValidDataType(n);
            this.paramTypes[this.currentRowIndex][i] = (byte)n;
        }
        vector.clear();
        vector = null;
    }

    public int getBatchFlag() {
        return this.batchFlag;
    }

    public int getBatchRowCount() {
        return this.currentRowIndex;
    }

    @Override
    public BindData getBindData() {
        return this.bindData;
    }

    @Override
    public Binder[][] getBinder() {
        return this.binder;
    }

    @Override
    public Binder getBinder(int n, int n2) {
        return this.binder[n][n2];
    }

    public TbColumnDesc[] getColMetaArray() {
        return this.colMeta;
    }

    public int getHiddenColCnt() {
        return this.hiddenColCnt;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        if (resultSet == null) {
            this.prepareInternal();
            int n = this.getColumnCount();
            Column[] columnArray = new Column[n];
            for (int i = 0; i < n; ++i) {
                columnArray[i] = new Column(this.conn.getMapDateToTimestamp());
            }
            this.typeConverter.buildColumnMetaData(this.colMeta, this.hiddenColCnt, n, columnArray);
            this.resultSetMetaData = new TbResultSetMetaData(columnArray, 0);
        }
        return this.resultSetMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareInternal() throws SQLException {
        this.checkConnectionOpen();
        if (this.batchStmts != null) {
            this.checkBatchStmtRemained();
            this.initBatchStmts();
        }
        this.initBeforeExecute();
        if (this.queryTimeout > 0) {
            this.conn.getTimeout().setTimeout(this.queryTimeout * 1000, this);
        }
        try {
            this.isExecuting = true;
            this.prepareInternal(this.originalSql);
        }
        finally {
            this.isExecuting = false;
            if (this.queryTimeout > 0) {
                this.conn.getTimeout().cancelTimeout();
            }
        }
    }

    int getColumnCount() {
        int n = this.getHiddenColCnt();
        int n2 = 0;
        if (this.getRealRsetType() != null) {
            n2 = n + (this.getRealRsetType().useRowId() ? 1 : 0);
        }
        return this.getOutColCnt() - n2;
    }

    public int getOutColCnt() {
        return this.outColCnt;
    }

    @Override
    public BigDecimal getParamBigDecimal(int n, int n2) {
        return this.paramBigDecimal[n][n2];
    }

    @Override
    public BigDecimal[] getParamBigDecimalOfRow(int n) {
        return this.paramBigDecimal == null ? null : this.paramBigDecimal[n];
    }

    @Override
    public byte[] getParamBytes(int n, int n2) {
        return this.paramBytes[n][n2];
    }

    @Override
    public byte[][] getParamBytesOfRow(int n) {
        return this.paramBytes == null ? (byte[][])null : this.paramBytes[n];
    }

    @Override
    public Calendar getParamCalendar(int n, int n2) {
        return this.paramCalendar[n][n2];
    }

    @Override
    public Calendar[] getParamCalendarOfRow(int n) {
        return this.paramCalendar == null ? null : this.paramCalendar[n];
    }

    @Override
    public double getParamDouble(int n, int n2) {
        return this.paramDouble[n][n2];
    }

    @Override
    public double[] getParamDoubleOfRow(int n) {
        return this.paramDouble == null ? null : this.paramDouble[n];
    }

    @Override
    public int getParameterCnt() {
        return this.bindParamCnt;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new TbParameterMetaData(this.bindParamCnt);
    }

    @Override
    public float getParamFloat(int n, int n2) {
        return this.paramFloat[n][n2];
    }

    @Override
    public float[] getParamFloatOfRow(int n) {
        return this.paramFloat == null ? null : this.paramFloat[n];
    }

    @Override
    public int getParamInt(int n, int n2) {
        return this.paramInt[n][n2];
    }

    @Override
    public int[] getParamIntOfRow(int n) {
        return this.paramInt == null ? null : this.paramInt[n];
    }

    @Override
    public long getParamLong(int n, int n2) {
        return this.paramLong[n][n2];
    }

    @Override
    public long[] getParamLongOfRow(int n) {
        return this.paramLong == null ? null : this.paramLong[n];
    }

    @Override
    public Reader getParamReader(int n, int n2) {
        return this.paramReader[n][n2];
    }

    @Override
    public Reader[] getParamReaderOfRow(int n) {
        return this.paramReader == null ? null : this.paramReader[n];
    }

    @Override
    public InputStream getParamStream(int n, int n2) {
        return this.paramStream[n][n2];
    }

    @Override
    public InputStream[] getParamStreamOfRow(int n) {
        return this.paramStream == null ? null : this.paramStream[n];
    }

    @Override
    public String getParamString(int n, int n2) {
        return this.paramString[n][n2];
    }

    @Override
    public String[] getParamStringOfRow(int n) {
        return this.paramString == null ? null : this.paramString[n];
    }

    @Override
    public Timestamp getParamTimestamp(int n, int n2) {
        return this.paramTimestamp[n][n2];
    }

    @Override
    public TbDate getParamTbDate(int n, int n2) {
        return this.paramTbDate[n][n2];
    }

    @Override
    public TbDate[] getParamTbDateOfRow(int n) {
        return this.paramTbDate == null ? null : this.paramTbDate[n];
    }

    @Override
    public TbTimestamp getParamTbTimestamp(int n, int n2) {
        return this.paramTbTimestamp[n][n2];
    }

    @Override
    public TbTimestamp[] getParamTbTimestampOfRow(int n) {
        return this.paramTbTimestamp == null ? null : this.paramTbTimestamp[n];
    }

    @Override
    public TbTimestampTZ getParamTbTimestampTZ(int n, int n2) {
        return this.paramTbTimestampTZ[n][n2];
    }

    @Override
    public TbTimestampTZ[] getParamTbTimestampTZOfRow(int n) {
        return this.paramTbTimestampTZ == null ? null : this.paramTbTimestampTZ[n];
    }

    @Override
    public Timestamp[] getParamTimestampOfRow(int n) {
        return this.paramTimestamp == null ? null : this.paramTimestamp[n];
    }

    @Override
    public Array getParamArray(int n, int n2) {
        return this.paramArray[n][n2];
    }

    @Override
    public Array[] getParamArrayOfRow(int n) {
        return this.paramArray == null ? null : this.paramArray[n];
    }

    @Override
    public Struct getParamStruct(int n, int n2) {
        return this.paramStruct[n][n2];
    }

    @Override
    public Struct[] getParamStructOfRow(int n) {
        return this.paramStruct == null ? null : this.paramStruct[n];
    }

    @Override
    public byte getParamType(int n, int n2) {
        return this.paramTypes[n][n2];
    }

    @Override
    public byte[][] getParamTypes() {
        return this.paramTypes;
    }

    @Override
    public byte[] getParamTypesOfRow(int n) {
        return this.paramTypes == null ? null : this.paramTypes[n];
    }

    public byte[] getPPID() {
        return this.ppid;
    }

    private void growBatchArray(int n, int n2) {
        int n3;
        int n4 = this.bindParamCnt + n2;
        int n5 = this.allocatedBatchRowCount + n;
        Binder[][] binderArray = this.binder;
        this.binder = new Binder[n5][n4];
        if (binderArray != null) {
            for (int i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(binderArray[i], 0, this.binder[i], 0, this.bindParamCnt);
            }
        }
        byte[][] byArray = this.paramTypes;
        this.paramTypes = new byte[n5][n4];
        if (byArray != null) {
            for (int i = 0; i < this.allocatedBatchRowCount; ++i) {
                System.arraycopy(byArray[i], 0, this.paramTypes[i], 0, this.bindParamCnt);
            }
        }
        if (this.paramInt != null) {
            int[][] nArray = this.paramInt;
            this.paramInt = new int[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(nArray[n3], 0, this.paramInt[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramLong != null) {
            long[][] lArray = this.paramLong;
            this.paramLong = new long[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(lArray[n3], 0, this.paramLong[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramFloat != null) {
            float[][] fArray = this.paramFloat;
            this.paramFloat = new float[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(fArray[n3], 0, this.paramFloat[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramDouble != null) {
            double[][] dArray = this.paramDouble;
            this.paramDouble = new double[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(dArray[n3], 0, this.paramDouble[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramBigDecimal != null) {
            BigDecimal[][] bigDecimalArray = this.paramBigDecimal;
            this.paramBigDecimal = new BigDecimal[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(bigDecimalArray[n3], 0, this.paramBigDecimal[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramString != null) {
            String[][] stringArray = this.paramString;
            this.paramString = new String[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(stringArray[n3], 0, this.paramString[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramCalendar != null) {
            Calendar[][] calendarArray = this.paramCalendar;
            this.paramCalendar = new Calendar[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(calendarArray[n3], 0, this.paramCalendar[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramTimestamp != null) {
            Timestamp[][] timestampArray = this.paramTimestamp;
            this.paramTimestamp = new Timestamp[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(timestampArray[n3], 0, this.paramTimestamp[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramTbDate != null) {
            TbDate[][] tbDateArray = this.paramTbDate;
            this.paramTbDate = new TbDate[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(tbDateArray[n3], 0, this.paramTbDate[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramTbTimestamp != null) {
            TbTimestamp[][] tbTimestampArray = this.paramTbTimestamp;
            this.paramTbTimestamp = new TbTimestamp[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(tbTimestampArray[n3], 0, this.paramTbTimestamp[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramTbTimestampTZ != null) {
            TbTimestampTZ[][] tbTimestampTZArray = this.paramTbTimestampTZ;
            this.paramTbTimestampTZ = new TbTimestampTZ[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(tbTimestampTZArray[n3], 0, this.paramTbTimestampTZ[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramBytes != null) {
            byte[][][] byArray2 = this.paramBytes;
            this.paramBytes = new byte[n5][n4][];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(byArray2[n3], 0, this.paramBytes[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramStream != null) {
            InputStream[][] inputStreamArray = this.paramStream;
            this.paramStream = new InputStream[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(inputStreamArray[n3], 0, this.paramStream[n3], 0, this.bindParamCnt);
            }
        }
        if (this.paramReader != null) {
            Reader[][] readerArray = this.paramReader;
            this.paramReader = new Reader[n5][n4];
            for (n3 = 0; n3 < this.allocatedBatchRowCount; ++n3) {
                System.arraycopy(readerArray[n3], 0, this.paramReader[n3], 0, this.bindParamCnt);
            }
        }
        this.allocatedBatchRowCount = n5;
    }

    public void initParameter() throws SQLException {
        this.bindParamCnt = TbSQLParser.getParamCount(this.originalSql, this.sqlType);
        this.allocatedBatchRowCount = 1;
        this.currentRowIndex = 0;
        if (this.bindData == null) {
            this.bindData = new BindData(this.bindParamCnt);
        } else {
            this.bindData.reuse();
            this.bindData.resize(this.bindParamCnt);
        }
        this.paramTypes = new byte[this.allocatedBatchRowCount][this.bindParamCnt];
        this.binder = new Binder[this.allocatedBatchRowCount][this.bindParamCnt];
    }

    private void initSQLInfo(String string) throws SQLException {
        if (this.originalSql.equals(string)) {
            return;
        }
        if (this.ppid != null) {
            this.ppid = null;
        }
        this.initSql(string);
        this.initParameter();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        return this.poolable;
    }

    private void pushParamData(int n, int n2) throws SQLException {
        int n3;
        BindItem bindItem = this.bindData.getBindItem(n2);
        int n4 = bindItem.getSQLType();
        for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
            this.binder[this.currentRowIndex][n3] = this.binder[this.currentRowIndex][n3 - 1];
        }
        for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
            this.paramTypes[this.currentRowIndex][n3] = this.paramTypes[this.currentRowIndex][n3 - 1];
        }
        switch (n4) {
            case 4: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramInt[this.currentRowIndex][n3] = this.paramInt[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case -5: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramBigDecimal[this.currentRowIndex][n3] = this.paramBigDecimal[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case 6: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramFloat[this.currentRowIndex][n3] = this.paramFloat[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case 8: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramDouble[this.currentRowIndex][n3] = this.paramDouble[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case 2: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramLong[this.currentRowIndex][n3] = this.paramLong[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case 12: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramString[this.currentRowIndex][n3] = this.paramString[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case -1: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramReader[this.currentRowIndex][n3] = this.paramReader[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case 91: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    if (this.paramTbDate == null) continue;
                    this.paramTbDate[this.currentRowIndex][n3] = this.paramTbDate[this.currentRowIndex][n3 - 1];
                }
            }
            case 92: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    if (this.paramCalendar == null) continue;
                    this.paramCalendar[this.currentRowIndex][n3] = this.paramCalendar[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case 93: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    if (this.paramTimestamp != null) {
                        this.paramTimestamp[this.currentRowIndex][n3] = this.paramTimestamp[this.currentRowIndex][n3 - 1];
                    }
                    if (this.paramTbTimestamp != null) {
                        this.paramTbTimestamp[this.currentRowIndex][n3] = this.paramTbTimestamp[this.currentRowIndex][n3 - 1];
                    }
                    if (this.paramTbTimestampTZ == null) continue;
                    this.paramTbTimestampTZ[this.currentRowIndex][n3] = this.paramTbTimestampTZ[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case -2: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramBytes[this.currentRowIndex][n3] = this.paramBytes[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case -4: {
                for (n3 = this.bindParamCnt + n - 1; n3 > n2; --n3) {
                    this.paramStream[this.currentRowIndex][n3] = this.paramStream[this.currentRowIndex][n3 - 1];
                }
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw TbError.newSQLException(-590704, Integer.toString(n4));
            }
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.ppid = null;
        this.colMeta = null;
        this.paramInt = null;
        this.paramLong = null;
        this.paramFloat = null;
        this.paramDouble = null;
        this.paramBigDecimal = null;
        this.paramString = null;
        this.paramCalendar = null;
        this.paramTimestamp = null;
        this.paramTbDate = null;
        this.paramTbTimestamp = null;
        this.paramTbTimestampTZ = null;
        this.paramBytes = null;
        this.paramStream = null;
        this.paramReader = null;
        this.paramTypes = null;
        this.binder = null;
        this.processedBigLiteralSql = null;
        this.resultSetMetaData = null;
        if (this.bigLiterals != null) {
            this.bigLiterals.clear();
            this.bigLiterals = null;
        }
        if (this.bindData != null) {
            this.bindData.reset();
            this.bindData = null;
        }
        if (this.batchUpdateInfo != null) {
            this.batchUpdateInfo.clear();
            this.batchUpdateInfo = null;
        }
        this.autoGenKeyArr = null;
    }

    @Override
    public synchronized void resetForCache() {
        super.resetForCache();
        this.paramInt = null;
        this.paramLong = null;
        this.paramFloat = null;
        this.paramDouble = null;
        this.paramBigDecimal = null;
        this.paramString = null;
        this.paramCalendar = null;
        this.paramTimestamp = null;
        this.paramTbDate = null;
        this.paramTbTimestamp = null;
        this.paramTbTimestampTZ = null;
        this.paramBytes = null;
        this.paramStream = null;
        this.paramReader = null;
        this.paramTypes = null;
        this.binder = null;
        this.allocatedBatchRowCount = 1;
        this.currentRowIndex = 0;
        this.processedBigLiteralSql = null;
        this.resultSetMetaData = null;
        if (this.bigLiterals != null) {
            this.bigLiterals.clear();
            this.bigLiterals = null;
        }
        if (this.bindData != null) {
            this.bindData.reset();
            this.bindData = null;
        }
        if (this.batchUpdateInfo != null) {
            this.batchUpdateInfo.clear();
            this.batchUpdateInfo = null;
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        this.setArrayInternal(n, array);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.setAsciiStreamInternal(n, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStreamInternal(n, inputStream, n2);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.setAsciiStreamInternal(n, inputStream, (int)l);
    }

    void setAsciiStreamInternal(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null || n2 <= 0) {
            this.setNullInternal(n, 3);
            return;
        }
        int n3 = 65532 < n2 ? 65533 : n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        try {
            n4 = inputStream.read(byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90202, iOException.getMessage());
        }
        if (n4 < 0) {
            this.setNullInternal(n, 3);
        } else if (n4 > 65532) {
            if (this.paramStream == null) {
                this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(n - 1, -1, n2);
            this.paramStream[this.currentRowIndex][n - 1] = new BytesStreamWrapper(inputStream, byArray, n4);
            this.binder[this.currentRowIndex][n - 1] = this.staticStreamBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 13;
        } else {
            if (this.paramBytes == null) {
                this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
            }
            this.bindData.setINParam(n - 1, 12, n4);
            this.paramBytes[this.currentRowIndex][n - 1] = byArray;
            this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 3;
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimalInternal(n, bigDecimal);
    }

    void setBigDecimalInternal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNullInternal(n, 1);
            return;
        }
        if (this.paramBigDecimal == null) {
            this.paramBigDecimal = new BigDecimal[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, -5, -1);
        this.paramBigDecimal[this.currentRowIndex][n - 1] = bigDecimal;
        this.paramTypes[this.currentRowIndex][n - 1] = 1;
        this.binder[this.currentRowIndex][n - 1] = this.staticBigDecimalBinder;
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.setBinaryStreamInternal(n, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStreamInternal(n, inputStream, n2);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.setBinaryStreamInternal(n, inputStream, (int)l);
    }

    void setBinaryStreamInternal(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null || n2 <= 0) {
            this.setNullInternal(n, 4);
            return;
        }
        int n3 = 65532 < n2 ? 65533 : n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        try {
            n4 = inputStream.read(byArray, 0, n3);
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90202, iOException.getMessage());
        }
        if (n4 < 0) {
            this.setNullInternal(n, 4);
        } else if (n4 > 65532) {
            if (this.paramStream == null) {
                this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(n - 1, -4, n2);
            this.paramStream[this.currentRowIndex][n - 1] = new BytesStreamWrapper(inputStream, byArray, n4);
            this.binder[this.currentRowIndex][n - 1] = this.staticStreamBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 12;
        } else {
            if (this.paramBytes == null) {
                this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
            }
            this.bindData.setINParam(n - 1, -2, n4);
            this.paramBytes[this.currentRowIndex][n - 1] = byArray;
            this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 4;
        }
    }

    public void setBindData(BindData bindData) {
        this.bindData = bindData;
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        this.setBlobInternal(n, blob);
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.setBlobInternal(n, inputStream, Integer.MAX_VALUE);
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.setBlobInternal(n, inputStream, l);
    }

    void setBlobInternal(int n, Blob blob) throws SQLException {
        if (blob == null) {
            this.setNullInternal(n, 12);
            return;
        }
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        this.bindData.setINParam(n - 1, -2, ((TbLob)((Object)blob)).getLocatorLength());
        this.paramBytes[this.currentRowIndex][n - 1] = ((TbLob)((Object)blob)).getLocator();
        this.paramTypes[this.currentRowIndex][n - 1] = 12;
        this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
    }

    void setBlobInternal(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.setBinaryStreamInternal(n, inputStream, (int)l);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        this.setBooleanInternal(n, bl);
    }

    void setBooleanInternal(int n, boolean bl) throws SQLException {
        if (this.paramString == null) {
            this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 1, 1);
        this.paramString[this.currentRowIndex][n - 1] = bl ? "1" : "0";
        this.paramTypes[this.currentRowIndex][n - 1] = 2;
        this.binder[this.currentRowIndex][n - 1] = this.staticStringBinder;
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        this.setByteInternal(n, by);
    }

    void setByteInternal(int n, byte by) throws SQLException {
        if (this.paramInt == null) {
            this.paramInt = new int[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 4, -1);
        this.paramInt[this.currentRowIndex][n - 1] = by;
        this.paramTypes[this.currentRowIndex][n - 1] = 1;
        this.binder[this.currentRowIndex][n - 1] = this.staticIntBinder;
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setBytesInternal(n, 4, byArray);
    }

    public void setBytes(int n, int n2, byte[] byArray) throws SQLException {
        DataType.checkValidDataType(n2);
        this.setBytesInternal(n, n2, byArray);
    }

    void setBytesInternal(int n, int n2, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNullInternal(n, n2);
            return;
        }
        if (byArray.length >= 65532) {
            if (this.paramStream == null) {
                this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(n - 1, -4, byArray.length);
            this.paramStream[this.currentRowIndex][n - 1] = new ByteArrayInputStream(byArray);
            this.binder[this.currentRowIndex][n - 1] = this.staticStreamBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 12;
        } else {
            if (this.paramBytes == null) {
                this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
            }
            if (!(this.supportBinaryDoubleFloatType || n2 != 24 && n2 != 23)) {
                n2 = 1;
            }
            this.bindData.setINParam(n - 1, -2, byArray.length);
            this.paramBytes[this.currentRowIndex][n - 1] = byArray;
            this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = (byte)n2;
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStreamInternal(n, reader, Integer.MAX_VALUE);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStreamInternal(n, reader, n2);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.setCharacterStreamInternal(n, reader, (int)l);
    }

    void setCharacterStreamInternal(int n, Reader reader, int n2) throws SQLException {
        if (reader == null || n2 <= 0) {
            this.setNullInternal(n, 3);
            return;
        }
        int n3 = n2 < 4001 ? n2 : 4001;
        char[] cArray = new char[n3];
        int n4 = 0;
        try {
            n4 = reader.read(cArray, 0, n3);
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90202, iOException.getMessage());
        }
        if (n4 < 0) {
            this.setNullInternal(n, 3);
        } else if (n4 < this.deferrableStrLen) {
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(n - 1, 12, n2);
            this.paramString[this.currentRowIndex][n - 1] = new String(cArray, 0, n4);
            this.binder[this.currentRowIndex][n - 1] = this.staticStringBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 3;
        } else if (n4 > 4000) {
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(n - 1, -1, n2);
            this.paramReader[this.currentRowIndex][n - 1] = ReaderWrapper.getInstance(reader, cArray, n4);
            this.binder[this.currentRowIndex][n - 1] = this.staticReaderBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 13;
        } else {
            byte[] byArray = new byte[n4 * this.typeConverter.getMaxBytesPerChar()];
            int n5 = this.typeConverter.charsToBytes(cArray, 0, n4, byArray, 0, byArray.length);
            if (n5 < 4000) {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
                }
                this.bindData.setINParam(n - 1, 12, n5);
                this.paramBytes[this.currentRowIndex][n - 1] = byArray;
                this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
                this.paramTypes[this.currentRowIndex][n - 1] = 3;
            } else {
                if (this.paramStream == null) {
                    this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
                }
                this.bindData.setDFRParam(n - 1, -1, n5);
                this.paramStream[this.currentRowIndex][n - 1] = new ByteArrayInputStream(byArray, 0, n5);
                this.binder[this.currentRowIndex][n - 1] = this.staticStreamBinder;
                this.paramTypes[this.currentRowIndex][n - 1] = 13;
            }
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        this.setClobInternal(n, 13, clob);
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.setClobInternal(n, reader, Integer.MAX_VALUE);
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.setClobInternal(n, reader, l);
    }

    public void setClobInternal(int n, int n2, Clob clob) throws SQLException {
        if (clob == null) {
            this.setNullInternal(n, n2);
            return;
        }
        if (!(clob instanceof TbClob) && !(clob instanceof TbNClob)) {
            throw TbError.newSQLException(-590770, clob.toString());
        }
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        this.bindData.setINParam(n - 1, -2, ((TbLob)((Object)clob)).getLocatorLength());
        this.paramBytes[this.currentRowIndex][n - 1] = ((TbLob)((Object)clob)).getLocator();
        this.paramTypes[this.currentRowIndex][n - 1] = (byte)n2;
        this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
    }

    void setClobInternal(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.setCharacterStreamInternal(n, reader, (int)l);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setDateInternal(n, date);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            this.setNullInternal(n, 5);
            return;
        }
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(date);
        byte[] byArray = new byte[8];
        this.typeConverter.fromDate(byArray, 0, calendar);
        this.bindData.setINParam(n - 1, 91, byArray.length);
        this.paramBytes[this.currentRowIndex][n - 1] = byArray;
        this.paramTypes[this.currentRowIndex][n - 1] = 5;
        this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
    }

    void setDateInternal(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNullInternal(n, 5);
            return;
        }
        if (this.paramCalendar == null) {
            this.paramCalendar = new Calendar[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.bindData.setINParam(n - 1, 91, -1);
        this.paramCalendar[this.currentRowIndex][n - 1] = calendar;
        this.paramTypes[this.currentRowIndex][n - 1] = 5;
        this.binder[this.currentRowIndex][n - 1] = this.staticDateBinder;
    }

    public void setTbDate(int n, TbDate tbDate) throws SQLException {
        this.setTbDateInternal(n, tbDate);
    }

    void setTbDateInternal(int n, TbDate tbDate) throws SQLException {
        if (tbDate == null) {
            this.setNullInternal(n, 5);
            return;
        }
        if (this.paramTbDate == null) {
            this.paramTbDate = new TbDate[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 91, -1);
        this.paramTbDate[this.currentRowIndex][n - 1] = tbDate;
        this.paramTypes[this.currentRowIndex][n - 1] = 5;
        this.binder[this.currentRowIndex][n - 1] = this.staticTbDateBinder;
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        this.setDoubleInternal(n, d);
    }

    void setDoubleInternal(int n, double d) throws SQLException {
        if (this.paramDouble == null) {
            this.paramDouble = new double[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        if (this.supportBinaryDoubleFloatType && (Double.compare(d, Double.NaN) == 0 || Double.compare(d, Double.NEGATIVE_INFINITY) == 0 || Double.compare(d, Double.POSITIVE_INFINITY) == 0)) {
            this.setBinaryDoubleInternal(n, d);
        } else {
            this.bindData.setINParam(n - 1, 8, -1);
            this.paramDouble[this.currentRowIndex][n - 1] = d;
            this.paramTypes[this.currentRowIndex][n - 1] = 1;
            this.binder[this.currentRowIndex][n - 1] = this.staticDoubleBinder;
        }
    }

    public void setBinaryDouble(int n, double d) throws SQLException {
        this.setBinaryDoubleInternal(n, d);
    }

    void setBinaryDoubleInternal(int n, double d) throws SQLException {
        if (this.paramDouble == null) {
            this.paramDouble = new double[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        if (this.supportBinaryDoubleFloatType) {
            this.bindData.setINParam(n - 1, 101, -1);
            this.paramDouble[this.currentRowIndex][n - 1] = d;
            this.paramTypes[this.currentRowIndex][n - 1] = 24;
            this.binder[this.currentRowIndex][n - 1] = this.staticBinaryDoubleBinder;
        } else {
            this.setDoubleInternal(n, d);
        }
    }

    public void setFixedCHAR(int n, String string) throws SQLException {
        this.setFixedCHARInternal(n, string);
    }

    void setFixedCHARInternal(int n, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            this.setNullInternal(n, 3);
            return;
        }
        if (this.paramString == null) {
            this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 1, string.length());
        this.paramString[this.currentRowIndex][n - 1] = string;
        this.binder[this.currentRowIndex][n - 1] = this.staticStringBinder;
        this.paramTypes[this.currentRowIndex][n - 1] = 2;
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        this.setFloatInternal(n, f);
    }

    void setFloatInternal(int n, float f) throws SQLException {
        if (this.paramFloat == null) {
            this.paramFloat = new float[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        if (this.supportBinaryDoubleFloatType && (Float.compare(f, Float.NaN) == 0 || Float.compare(f, Float.NEGATIVE_INFINITY) == 0 || Float.compare(f, Float.POSITIVE_INFINITY) == 0)) {
            this.setBinaryFloatInternal(n, f);
        } else {
            this.bindData.setINParam(n - 1, 6, -1);
            this.paramFloat[this.currentRowIndex][n - 1] = f;
            this.paramTypes[this.currentRowIndex][n - 1] = 1;
            this.binder[this.currentRowIndex][n - 1] = this.staticFloatBinder;
        }
    }

    public void setBinaryFloat(int n, float f) throws SQLException {
        this.setBinaryFloatInternal(n, f);
    }

    void setBinaryFloatInternal(int n, float f) throws SQLException {
        if (this.paramFloat == null) {
            this.paramFloat = new float[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        if (this.supportBinaryDoubleFloatType) {
            this.bindData.setINParam(n - 1, 100, -1);
            this.paramFloat[this.currentRowIndex][n - 1] = f;
            this.paramTypes[this.currentRowIndex][n - 1] = 23;
            this.binder[this.currentRowIndex][n - 1] = this.staticBinaryFloatBinder;
        } else {
            this.setFloatInternal(n, f);
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        this.setIntInternal(n, n2);
    }

    void setIntInternal(int n, int n2) throws SQLException {
        if (this.paramInt == null) {
            this.paramInt = new int[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 4, -1);
        this.paramInt[this.currentRowIndex][n - 1] = n2;
        this.paramTypes[this.currentRowIndex][n - 1] = 1;
        this.binder[this.currentRowIndex][n - 1] = this.staticIntBinder;
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        this.setLongInternal(n, l);
    }

    void setLongInternal(int n, long l) throws SQLException {
        if (this.paramLong == null) {
            this.paramLong = new long[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 2, -1);
        this.paramLong[this.currentRowIndex][n - 1] = l;
        this.paramTypes[this.currentRowIndex][n - 1] = 1;
        this.binder[this.currentRowIndex][n - 1] = this.staticLongBinder;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setNCharacterStreamInternal(n, reader, Integer.MAX_VALUE);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.setNCharacterStreamInternal(n, reader, (int)l);
    }

    void setNCharacterStreamInternal(int n, Reader reader, int n2) throws SQLException {
        if (reader == null || n2 <= 0) {
            this.setNullInternal(n, 19);
            return;
        }
        int n3 = n2 < 4001 ? n2 : 4001;
        char[] cArray = new char[n3];
        int n4 = 0;
        try {
            n4 = reader.read(cArray, 0, n3);
        }
        catch (IOException iOException) {
            throw TbError.newSQLException(-90202, iOException.getMessage());
        }
        if (n4 < 0) {
            this.setNullInternal(n, 19);
        } else if (n4 < this.deferrableNStrLen) {
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(n - 1, -9, n2);
            this.paramString[this.currentRowIndex][n - 1] = new String(cArray, 0, n4);
            this.binder[this.currentRowIndex][n - 1] = this.staticNStringBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 19;
        } else if (n4 > 4000) {
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(n - 1, -16, n2);
            this.paramReader[this.currentRowIndex][n - 1] = ReaderWrapper.getInstance(reader, cArray, n4);
            this.binder[this.currentRowIndex][n - 1] = this.staticNReaderBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 20;
        } else {
            byte[] byArray = new byte[n4 * this.typeConverter.getMaxBytesPerNChar()];
            int n5 = this.typeConverter.nCharsToBytes(cArray, 0, n4, byArray, 0, byArray.length);
            if (n5 < 4000) {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
                }
                this.bindData.setINParam(n - 1, -9, n5);
                this.paramBytes[this.currentRowIndex][n - 1] = byArray;
                this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
                this.paramTypes[this.currentRowIndex][n - 1] = 19;
            } else {
                if (this.paramStream == null) {
                    this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
                }
                this.bindData.setDFRParam(n - 1, -16, n5);
                this.paramStream[this.currentRowIndex][n - 1] = new ByteArrayInputStream(byArray, 0, n5);
                this.binder[this.currentRowIndex][n - 1] = this.staticStreamBinder;
                this.paramTypes[this.currentRowIndex][n - 1] = 20;
            }
        }
    }

    public void setNClob(int n, Clob clob) throws SQLException {
        this.setClobInternal(n, 20, clob);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.setClobInternal(n, 20, nClob);
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.setNClobInternal(n, reader, Integer.MAX_VALUE);
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw TbError.newSQLException(-90656, Long.toString(l));
        }
        this.setNClobInternal(n, reader, (int)l);
    }

    void setNClobInternal(int n, Reader reader, int n2) throws SQLException {
        if (reader == null || n2 <= 0) {
            this.setNullInternal(n, 19);
            return;
        }
        if (n2 >= this.conn.getMaxDFRNCharCount()) {
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(n - 1, -16, n2);
            this.paramReader[this.currentRowIndex][n - 1] = reader;
            this.binder[this.currentRowIndex][n - 1] = this.staticNReaderBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 20;
        } else {
            int n3 = 0;
            char[] cArray = new char[n2];
            try {
                n3 = reader.read(cArray, 0, n2);
            }
            catch (IOException iOException) {
                throw TbError.newSQLException(-90202, iOException.getMessage());
            }
            if (n3 != n2) {
                char[] cArray2 = cArray;
                cArray = new char[n3];
                System.arraycopy(cArray2, 0, cArray, 0, n3);
            }
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(n - 1, -9, n2);
            this.paramString[this.currentRowIndex][n - 1] = new String(cArray);
            this.binder[this.currentRowIndex][n - 1] = this.staticStringBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 19;
        }
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.setNStringInternal(n, string);
    }

    void setNStringInternal(int n, String string) throws SQLException {
        if (string == null || string.length() == 0) {
            this.setNullInternal(n, 19);
            return;
        }
        if (string.length() < this.deferrableNStrLen) {
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(n - 1, -9, string.length());
            this.paramString[this.currentRowIndex][n - 1] = string;
            this.binder[this.currentRowIndex][n - 1] = this.staticNStringBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 19;
        } else {
            byte[] byArray = new byte[string.length() * this.typeConverter.getMaxBytesPerNChar()];
            int n2 = this.typeConverter.fromNString(byArray, 0, string);
            if (n2 > 4000) {
                if (this.paramStream == null) {
                    this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
                }
                this.bindData.setDFRParam(n - 1, -16, n2);
                this.paramStream[this.currentRowIndex][n - 1] = new ByteArrayInputStream(byArray, 0, n2);
                this.binder[this.currentRowIndex][n - 1] = this.staticStreamBinder;
                this.paramTypes[this.currentRowIndex][n - 1] = 20;
            } else {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
                }
                this.bindData.setINParam(n - 1, -9, n2);
                this.paramBytes[this.currentRowIndex][n - 1] = byArray;
                this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
                this.paramTypes[this.currentRowIndex][n - 1] = 19;
            }
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.setNullInternal(n, DataType.getDataType(n2));
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        this.setNullInternal(n, DataType.getDataType(n2));
    }

    void setNullInternal(int n, int n2) throws SQLException {
        this.bindData.setINParam(n - 1, 0, 0);
        this.paramTypes[this.currentRowIndex][n - 1] = (byte)n2;
        this.binder[this.currentRowIndex][n - 1] = this.staticNullBinder;
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, DataType.getSqlType(object), 0);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObjectInternal(n, object, n2, n3);
    }

    void setObjectInternal(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNullInternal(n, 2);
            return;
        }
        switch (n2) {
            case -7: {
                this.setBooleanInternal(n, new Boolean(object.toString()));
                break;
            }
            case -15: 
            case -9: {
                this.setNStringInternal(n, object.toString());
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                if (object instanceof Boolean) {
                    this.setStringInternal(n, (Boolean)object != false ? "1" : "0");
                    break;
                }
                this.setStringInternal(n, object.toString());
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytesInternal(n, 4, (byte[])object);
                break;
            }
            case -6: 
            case 5: {
                if (object instanceof Number) {
                    this.setShortInternal(n, ((Number)object).shortValue());
                    break;
                }
                if (object instanceof String) {
                    this.setShortInternal(n, Short.parseShort((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setShortInternal(n, (short)((Boolean)object != false ? 1 : 0));
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 4: {
                if (object instanceof Number) {
                    this.setIntInternal(n, ((Number)object).intValue());
                    break;
                }
                if (object instanceof String) {
                    this.setIntInternal(n, Integer.parseInt((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setIntInternal(n, (Boolean)object != false ? 1 : 0);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case -5: {
                if (object instanceof Number) {
                    this.setLongInternal(n, ((Number)object).longValue());
                    break;
                }
                if (object instanceof String) {
                    this.setLongInternal(n, Long.parseLong((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setLongInternal(n, (Boolean)object != false ? 1L : 0L);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 3: {
                if (object instanceof BigDecimal) {
                    this.setBigDecimalInternal(n, (BigDecimal)object);
                    break;
                }
                if (object instanceof Number) {
                    this.setBigDecimalInternal(n, new BigDecimal(((Number)object).doubleValue()));
                    break;
                }
                if (object instanceof String) {
                    this.setBigDecimalInternal(n, new BigDecimal((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setBigDecimalInternal(n, new BigDecimal((Boolean)object != false ? 1.0 : 0.0));
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 7: {
                if (object instanceof Number) {
                    this.setFloatInternal(n, ((Number)object).floatValue());
                    break;
                }
                if (object instanceof String) {
                    this.setFloatInternal(n, Float.valueOf((String)object).floatValue());
                    break;
                }
                if (object instanceof Boolean) {
                    this.setFloatInternal(n, (Boolean)object != false ? 1.0f : 0.0f);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 6: 
            case 8: {
                if (object instanceof Number) {
                    this.setDoubleInternal(n, ((Number)object).doubleValue());
                    break;
                }
                if (object instanceof String) {
                    this.setDoubleInternal(n, Double.valueOf((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setDoubleInternal(n, (Boolean)object != false ? 1.0 : 0.0);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 2: {
                if (object instanceof Short) {
                    this.setShortInternal(n, (Short)object);
                    break;
                }
                if (object instanceof Integer) {
                    this.setIntInternal(n, (Integer)object);
                    break;
                }
                if (object instanceof Long) {
                    this.setLongInternal(n, (Long)object);
                    break;
                }
                if (object instanceof Float) {
                    this.setFloatInternal(n, ((Float)object).floatValue());
                    break;
                }
                if (object instanceof Double) {
                    this.setDoubleInternal(n, (Double)object);
                    break;
                }
                if (object instanceof BigDecimal) {
                    this.setBigDecimalInternal(n, (BigDecimal)object);
                    break;
                }
                if (object instanceof Boolean) {
                    this.setBooleanInternal(n, (Boolean)object);
                    break;
                }
                if (object instanceof String) {
                    this.setBigDecimalInternal(n, new BigDecimal((String)object));
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 100: {
                if (object instanceof Number) {
                    this.setBinaryFloatInternal(n, ((Number)object).floatValue());
                    break;
                }
                if (object instanceof String) {
                    this.setBinaryFloatInternal(n, Float.valueOf((String)object).floatValue());
                    break;
                }
                if (object instanceof Boolean) {
                    this.setBinaryFloatInternal(n, (Boolean)object != false ? 1.0f : 0.0f);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 101: {
                if (object instanceof Number) {
                    this.setBinaryDoubleInternal(n, ((Number)object).doubleValue());
                    break;
                }
                if (object instanceof String) {
                    this.setBinaryDoubleInternal(n, Double.valueOf((String)object));
                    break;
                }
                if (object instanceof Boolean) {
                    this.setBinaryDoubleInternal(n, (Boolean)object != false ? 1.0 : 0.0);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 91: {
                if (object instanceof Date) {
                    this.setDateInternal(n, (Date)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setDateInternal(n, (Date)object);
                    break;
                }
                if (object instanceof String) {
                    this.setDateInternal(n, Date.valueOf((String)object));
                    break;
                }
                if (object instanceof TbDate) {
                    this.setTbDate(n, (TbDate)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 92: {
                if (object instanceof Time) {
                    this.setTimeInternal(n, (Time)object);
                    break;
                }
                if (object instanceof Timestamp) {
                    this.setTimeInternal(n, new Time(((Timestamp)object).getTime()));
                    break;
                }
                if (object instanceof Date) {
                    this.setTimeInternal(n, new Time(((Date)object).getTime()));
                    break;
                }
                if (object instanceof String) {
                    this.setTimeInternal(n, Time.valueOf((String)object));
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 93: {
                if (object instanceof Timestamp) {
                    this.setTimestampInternal(n, (Timestamp)object);
                    break;
                }
                if (object instanceof Date) {
                    this.setDateInternal(n, (Date)object);
                    break;
                }
                if (object instanceof String) {
                    this.setTimestampInternal(n, Timestamp.valueOf((String)object));
                    break;
                }
                if (object instanceof TbTimestamp) {
                    this.setTbTimestamp(n, (TbTimestamp)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 2004: {
                if (object instanceof Blob) {
                    this.setBlobInternal(n, (Blob)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 2011: {
                if (object instanceof NClob) {
                    this.setClobInternal(n, 20, (NClob)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 2005: {
                if (object instanceof Clob) {
                    this.setClobInternal(n, 13, (Clob)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case -8: {
                if (object instanceof RowId) {
                    this.setRowIdInternal(n, (RowId)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            case 2009: {
                if (object instanceof SQLXML) {
                    this.setSQLXMLInternal(n, (SQLXML)object);
                    break;
                }
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
            default: {
                throw TbError.newSQLException(-590704, object.toString() + "," + n2);
            }
        }
    }

    private void setStructInternal(int n, Struct struct) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    protected void setStructInternalForOutParam(int n, Struct struct) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    private void setArrayInternal(int n, Array array) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    protected void setArrayInternalForOutParam(int n, Array array) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    private void setTableInternal(int n, Array array) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void setParameterCnt(int n) {
        this.bindParamCnt = n;
    }

    protected void setParamTypes(int n, byte by) {
        this.paramTypes[this.currentRowIndex][n] = by;
    }

    @Override
    public void setPoolable(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90659);
        }
        this.poolable = bl;
    }

    public void setPPID(byte[] byArray) {
        this.ppid = (byte[])(byArray == null || Arrays.equals(byArray, PPID_NULL) ? null : byArray);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        if (!(rowId instanceof TbRowId)) {
            throw TbError.newSQLException(-590771, String.valueOf(rowId));
        }
        this.setRowIdInternal(n, rowId);
    }

    void setRowIdInternal(int n, RowId rowId) throws SQLException {
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        this.bindData.setINParam(n - 1, -8, rowId.getBytes().length);
        this.paramBytes[this.currentRowIndex][n - 1] = rowId.getBytes();
        this.paramTypes[this.currentRowIndex][n - 1] = 15;
        this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        this.setShortInternal(n, s);
    }

    void setShortInternal(int n, short s) throws SQLException {
        if (this.paramInt == null) {
            this.paramInt = new int[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 4, -1);
        this.paramInt[this.currentRowIndex][n - 1] = s;
        this.paramTypes[this.currentRowIndex][n - 1] = 1;
        this.binder[this.currentRowIndex][n - 1] = this.staticIntBinder;
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.setSQLXMLInternal(n, sQLXML);
    }

    void setSQLXMLInternal(int n, SQLXML sQLXML) throws SQLException {
        InputStream inputStream = ((TbSQLXML)sQLXML).getValue();
        if (this.paramStream == null) {
            this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setDFRParam(n - 1, 2009, Integer.MAX_VALUE);
        this.paramStream[this.currentRowIndex][n - 1] = inputStream;
        this.paramTypes[this.currentRowIndex][n - 1] = 13;
        this.binder[this.currentRowIndex][n - 1] = this.staticStreamBinder;
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        this.setStringInternal(n, string);
    }

    void setStringInternal(int n, String string) throws SQLException {
        if (this.conn.info.getDefaultNChar()) {
            this.setNStringInternal(n, string);
            return;
        }
        if (string == null || string.length() == 0) {
            this.setNullInternal(n, 3);
            return;
        }
        if (string.length() < this.deferrableStrLen) {
            if (this.paramString == null) {
                this.paramString = new String[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(n - 1, 12, string.length());
            this.paramString[this.currentRowIndex][n - 1] = string;
            this.binder[this.currentRowIndex][n - 1] = this.staticStringBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 3;
        } else if (string.length() > 4000) {
            if (this.paramReader == null) {
                this.paramReader = new Reader[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setDFRParam(n - 1, -1, string.length());
            this.paramReader[this.currentRowIndex][n - 1] = new StringReader(string);
            this.binder[this.currentRowIndex][n - 1] = this.staticReaderBinder;
            this.paramTypes[this.currentRowIndex][n - 1] = 13;
        } else {
            byte[] byArray = new byte[string.length() * this.typeConverter.getMaxBytesPerChar()];
            int n2 = this.typeConverter.fromString(byArray, 0, string);
            if (n2 > 4000) {
                if (this.paramStream == null) {
                    this.paramStream = new InputStream[this.allocatedBatchRowCount][this.bindParamCnt];
                }
                this.bindData.setDFRParam(n - 1, -1, n2);
                this.paramStream[this.currentRowIndex][n - 1] = new ByteArrayInputStream(byArray, 0, n2);
                this.binder[this.currentRowIndex][n - 1] = this.staticStreamBinder;
                this.paramTypes[this.currentRowIndex][n - 1] = 13;
            } else {
                if (this.paramBytes == null) {
                    this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
                }
                this.bindData.setINParam(n - 1, 12, n2);
                this.paramBytes[this.currentRowIndex][n - 1] = byArray;
                this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
                this.paramTypes[this.currentRowIndex][n - 1] = 3;
            }
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setTimeInternal(n, time);
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setNullInternal(n, 5);
            return;
        }
        if (this.paramBytes == null) {
            this.paramBytes = new byte[this.allocatedBatchRowCount][this.bindParamCnt][];
        }
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        calendar.setTime(time);
        byte[] byArray = new byte[8];
        this.typeConverter.fromTime(byArray, 0, calendar, 0);
        this.bindData.setINParam(n - 1, 92, byArray.length);
        this.paramBytes[this.currentRowIndex][n - 1] = byArray;
        this.paramTypes[this.currentRowIndex][n - 1] = 5;
        this.binder[this.currentRowIndex][n - 1] = this.staticBytesBinder;
    }

    void setTimeInternal(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNullInternal(n, 5);
            return;
        }
        if (this.paramCalendar == null) {
            this.paramCalendar = new Calendar[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        this.bindData.setINParam(n - 1, 92, 0);
        this.paramCalendar[this.currentRowIndex][n - 1] = calendar;
        this.paramTypes[this.currentRowIndex][n - 1] = 5;
        this.binder[this.currentRowIndex][n - 1] = this.staticTimeBinder;
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestampInternal(n, timestamp);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            this.setNullInternal(n, 7);
            return;
        }
        TbDatabaseMetaData tbDatabaseMetaData = new TbDatabaseMetaData(this.conn);
        if (tbDatabaseMetaData.getDatabaseMajorVersion() < 5) {
            if (calendar == null) {
                calendar = Calendar.getInstance();
            }
            calendar.setTimeInMillis(timestamp.getTime());
            TbTimestamp tbTimestamp = new TbTimestamp(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), timestamp.getNanos());
            if (this.paramTbTimestamp == null) {
                this.paramTbTimestamp = new TbTimestamp[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            this.bindData.setINParam(n - 1, 93, -1);
            this.paramTbTimestamp[this.currentRowIndex][n - 1] = tbTimestamp;
            this.paramTypes[this.currentRowIndex][n - 1] = 7;
            this.binder[this.currentRowIndex][n - 1] = this.staticTbTimestampBinder;
        } else {
            if (this.paramTbTimestampTZ == null) {
                this.paramTbTimestampTZ = new TbTimestampTZ[this.allocatedBatchRowCount][this.bindParamCnt];
            }
            TbTimestampTZ tbTimestampTZ = new TbTimestampTZ(timestamp, calendar.getTimeZone());
            this.bindData.setINParam(n - 1, 93, -1);
            this.paramTbTimestampTZ[this.currentRowIndex][n - 1] = tbTimestampTZ;
            this.paramTypes[this.currentRowIndex][n - 1] = 21;
            this.binder[this.currentRowIndex][n - 1] = this.staticTimestampTZBinder;
        }
    }

    void setTimestampInternal(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNullInternal(n, 7);
            return;
        }
        if (this.paramTimestamp == null) {
            this.paramTimestamp = new Timestamp[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 93, -1);
        this.paramTimestamp[this.currentRowIndex][n - 1] = timestamp;
        this.paramTypes[this.currentRowIndex][n - 1] = 7;
        this.binder[this.currentRowIndex][n - 1] = this.staticTimestampBinder;
    }

    public void setTbTimestamp(int n, TbTimestamp tbTimestamp) throws SQLException {
        this.setTbTimestampInternal(n, tbTimestamp);
    }

    void setTbTimestampInternal(int n, TbTimestamp tbTimestamp) throws SQLException {
        if (tbTimestamp == null) {
            this.setNullInternal(n, 7);
            return;
        }
        if (this.paramTbTimestamp == null) {
            this.paramTbTimestamp = new TbTimestamp[this.allocatedBatchRowCount][this.bindParamCnt];
        }
        this.bindData.setINParam(n - 1, 93, -1);
        this.paramTbTimestamp[this.currentRowIndex][n - 1] = tbTimestamp;
        this.paramTypes[this.currentRowIndex][n - 1] = 7;
        this.binder[this.currentRowIndex][n - 1] = this.staticTbTimestampBinder;
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setUnicodeStreamInternal(n, inputStream, n2);
    }

    void setUnicodeStreamInternal(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null || n2 <= 0) {
            this.setNullInternal(n, 3);
            return;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.setCharacterStreamInternal(n, inputStreamReader, n2);
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    @Override
    public void addBatch(String string) throws SQLException {
        this.initSQLInfo(string);
        int n = this.bindData.getDFRParameterCnt();
        for (int i = 0; i < this.bindParamCnt; ++i) {
            BindItem bindItem;
            if (this.binder[this.currentRowIndex][i] == null) {
                this.setCachedBindParameter(i);
            }
            if ((bindItem = this.bindData.getBindItem(i)).isOUTParameter()) {
                throw TbError.newSQLException(-90631);
            }
            if (n > 0 || this.paramTypes[0][i] == this.paramTypes[this.currentRowIndex][i]) continue;
            this.batchFlag = 0;
        }
        if (this.batchUpdateInfo == null) {
            this.batchUpdateInfo = new BatchUpdateInfo();
        }
        BindData bindData = new BindData();
        this.bindData.clone(bindData);
        this.bindData.clearDFRParameter();
        this.batchUpdateInfo.add(new BatchInfo(bindData, this.currentRowIndex));
        if (this.currentRowIndex == this.allocatedBatchRowCount - 1) {
            this.growBatchArray(this.allocatedBatchRowCount, 0);
        }
        ++this.currentRowIndex;
    }

    public void setAutoGenKeyArr(Object object) {
        this.autoGenKeyArr = object;
    }

    private static boolean isSupportBinaryDoubleFloatType(ServerInfo serverInfo) {
        return serverInfo.getProtocolMajorVersion() * 100 + serverInfo.getProtocolMinorVersion() >= 206;
    }
}

