/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.rowset;

import com.tmax.tibero.jdbc.err.TbError;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;

public class TbRowSetMetaData
implements RowSetMetaData,
Serializable {
    private static final long serialVersionUID = -1910875269279117964L;
    private int columnCount;
    private boolean[] autoIncrement;
    private boolean[] caseSensitive;
    private String[] catalogName;
    private int[] columnDIsplaySize;
    private String[] columnLabel;
    private String[] columnName;
    private int[] columnType;
    private String[] columnTypeName;
    private boolean[] currency;
    private int[] nullable;
    private int[] precision;
    private int[] scale;
    private String[] schemaName;
    private boolean[] searchable;
    private boolean[] signed;
    private String[] tableName;
    private boolean[] definatelyWritable;
    private boolean[] readOnly;
    private boolean[] writable;
    private String[] columnClassName;

    public TbRowSetMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.columnCount = resultSetMetaData.getColumnCount();
        this.autoIncrement = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnDIsplaySize = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.searchable = new boolean[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.autoIncrement[i] = resultSetMetaData.isAutoIncrement(i + 1);
            this.caseSensitive[i] = resultSetMetaData.isCaseSensitive(i + 1);
            this.catalogName[i] = resultSetMetaData.getCatalogName(i + 1);
            this.columnDIsplaySize[i] = resultSetMetaData.getColumnDisplaySize(i + 1);
            this.columnLabel[i] = resultSetMetaData.getColumnLabel(i + 1);
            this.columnName[i] = resultSetMetaData.getColumnName(i + 1);
            this.columnType[i] = resultSetMetaData.getColumnType(i + 1);
            this.columnTypeName[i] = resultSetMetaData.getColumnTypeName(i + 1);
            this.currency[i] = resultSetMetaData.isCurrency(i + 1);
            this.nullable[i] = resultSetMetaData.isNullable(i + 1);
            this.precision[i] = resultSetMetaData.getPrecision(i + 1);
            this.scale[i] = resultSetMetaData.getScale(i + 1);
            this.schemaName[i] = resultSetMetaData.getSchemaName(i + 1);
            this.searchable[i] = resultSetMetaData.isSearchable(i + 1);
            this.signed[i] = resultSetMetaData.isSearchable(i + 1);
            this.tableName[i] = resultSetMetaData.getTableName(i + 1);
            this.definatelyWritable[i] = resultSetMetaData.isDefinitelyWritable(i + 1);
            this.readOnly[i] = resultSetMetaData.isReadOnly(i + 1);
            this.writable[i] = resultSetMetaData.isWritable(i + 1);
            this.columnClassName[i] = resultSetMetaData.getColumnClassName(i + 1);
        }
    }

    public TbRowSetMetaData(int n) {
        this.columnCount = n;
        this.autoIncrement = new boolean[this.columnCount];
        this.caseSensitive = new boolean[this.columnCount];
        this.catalogName = new String[this.columnCount];
        this.columnDIsplaySize = new int[this.columnCount];
        this.columnLabel = new String[this.columnCount];
        this.columnName = new String[this.columnCount];
        this.columnType = new int[this.columnCount];
        this.columnTypeName = new String[this.columnCount];
        this.currency = new boolean[this.columnCount];
        this.nullable = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.precision = new int[this.columnCount];
        this.scale = new int[this.columnCount];
        this.schemaName = new String[this.columnCount];
        this.searchable = new boolean[this.columnCount];
        this.signed = new boolean[this.columnCount];
        this.tableName = new String[this.columnCount];
        this.definatelyWritable = new boolean[this.columnCount];
        this.readOnly = new boolean[this.columnCount];
        this.writable = new boolean[this.columnCount];
        this.columnClassName = new String[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.autoIncrement[i] = true;
            this.caseSensitive[i] = false;
            this.catalogName[i] = "";
            this.columnDIsplaySize[i] = 0;
            this.columnLabel[i] = "";
            this.columnName[i] = "";
            this.columnType[i] = 0;
            this.columnTypeName[i] = "";
            this.currency[i] = false;
            this.nullable[i] = 1;
            this.precision[i] = 0;
            this.scale[i] = 0;
            this.schemaName[i] = "";
            this.searchable[i] = false;
            this.signed[i] = false;
            this.tableName[i] = "";
            this.definatelyWritable[i] = false;
            this.readOnly[i] = false;
            this.writable[i] = false;
            this.columnClassName[i] = "";
        }
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.columnCount) {
            throw TbError.newSQLException(-90834, Integer.toString(n));
        }
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.catalogName[n - 1];
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.columnClassName[n - 1];
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.columnDIsplaySize[n - 1];
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.columnLabel[n - 1];
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.columnName[n - 1];
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.columnType[n - 1];
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.columnTypeName[n - 1];
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.precision[n - 1];
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.scale[n - 1];
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.schemaName[n - 1];
    }

    @Override
    public String getTableName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.tableName[n - 1];
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.autoIncrement[n - 1];
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.caseSensitive[n - 1];
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.currency[n - 1];
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.definatelyWritable[n - 1];
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.nullable[n - 1];
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.readOnly[n - 1];
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.searchable[n - 1];
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.signed[n - 1];
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.writable[n - 1];
    }

    @Override
    public void setAutoIncrement(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.autoIncrement[n - 1] = bl;
    }

    @Override
    public void setCaseSensitive(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.caseSensitive[n - 1] = bl;
    }

    @Override
    public void setCatalogName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.catalogName[n - 1] = string;
    }

    @Override
    public void setColumnCount(int n) throws SQLException {
        this.columnCount = n;
    }

    @Override
    public void setColumnDisplaySize(int n, int n2) throws SQLException {
        this.checkColumnIndex(n);
        this.columnDIsplaySize[n - 1] = n2;
    }

    @Override
    public void setColumnLabel(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.columnLabel[n - 1] = string;
    }

    @Override
    public void setColumnName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.columnName[n - 1] = string;
    }

    @Override
    public void setColumnType(int n, int n2) throws SQLException {
        this.checkColumnIndex(n);
        this.columnType[n - 1] = n2;
    }

    @Override
    public void setColumnTypeName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.columnTypeName[n - 1] = string;
    }

    @Override
    public void setCurrency(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.currency[n - 1] = bl;
    }

    @Override
    public void setNullable(int n, int n2) throws SQLException {
        this.checkColumnIndex(n);
        this.nullable[n - 1] = n2;
    }

    @Override
    public void setPrecision(int n, int n2) throws SQLException {
        this.checkColumnIndex(n);
        this.precision[n - 1] = n2;
    }

    @Override
    public void setScale(int n, int n2) throws SQLException {
        this.checkColumnIndex(n);
        this.scale[n - 1] = n2;
    }

    @Override
    public void setSchemaName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.schemaName[n - 1] = string;
    }

    @Override
    public void setSearchable(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.searchable[n - 1] = bl;
    }

    @Override
    public void setSigned(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.signed[n - 1] = bl;
    }

    @Override
    public void setTableName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.tableName[n - 1] = string;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw TbError.newSQLException(-90657);
        }
    }
}

