/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc;

import com.tmax.tibero.jdbc.TbClobBase;
import com.tmax.tibero.jdbc.TbLob;
import com.tmax.tibero.jdbc.err.TbError;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class TbClobReader
extends Reader {
    private TbClobBase clob = null;
    private int bufOffset = 0;
    private long lobOffset = 0L;
    private int fetchedSize = 0;
    private long totalSize = 0L;
    private long totalFetchedSize = 0L;
    private char[] buf = null;
    private boolean opened = false;

    public TbClobReader(TbClobBase tbClobBase, long l, long l2) throws SQLException {
        if (tbClobBase == null) {
            throw TbError.newSQLException(-590767);
        }
        this.clob = tbClobBase;
        this.bufOffset = 0;
        this.lobOffset = l - 1L;
        this.fetchedSize = 0;
        this.totalSize = l2;
        this.buf = new char[TbLob.getMaxChunkSize()];
        this.opened = true;
    }

    private void checkClosed() throws IOException {
        if (!this.opened) {
            throw new IOException(TbError.getMsg(-90900));
        }
    }

    @Override
    public void close() throws IOException {
        this.opened = false;
        this.clob = null;
        this.buf = null;
    }

    private int getRemainedInBuffer() {
        return this.fetchedSize - this.bufOffset;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        this.checkClosed();
        if (this.getRemainedInBuffer() == 0) {
            if (this.clob.isEndOfStream()) {
                if (this.clob.getIsTempLob() && this.clob.freeTmpLobOnEOF()) {
                    try {
                        this.clob.free();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return -1;
                }
                return -1;
            }
            try {
                this.readNextBuffer();
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
        }
        if (this.getRemainedInBuffer() >= n2) {
            System.arraycopy(this.buf, this.bufOffset, cArray, n, n2);
            this.bufOffset += n2;
            return n2;
        }
        int n3 = 0;
        while (n2 > n3) {
            int n4 = this.getRemainedInBuffer();
            if (n4 > n2 - n3) {
                n4 = n2 - n3;
            }
            System.arraycopy(this.buf, this.bufOffset, cArray, n + n3, n4);
            n3 += n4;
            this.bufOffset += n4;
            if (this.getRemainedInBuffer() != 0) continue;
            if (!this.clob.isEndOfStream()) {
                try {
                    this.readNextBuffer();
                    continue;
                }
                catch (SQLException sQLException) {
                    throw new IOException(sQLException.getMessage());
                }
            }
            return n3;
        }
        return n3;
    }

    private void readNextBuffer() throws SQLException {
        long l = 0L;
        long l2 = this.totalSize - this.totalFetchedSize;
        if ((long)this.buf.length < l2) {
            l = this.clob.getChars(this.lobOffset + 1L, this.buf);
        } else {
            l = this.clob.getChars(this.lobOffset + 1L, this.buf, 0L, l2);
            this.clob.setEndOfStream(true);
        }
        this.totalFetchedSize += l;
        this.fetchedSize = (int)l;
        this.lobOffset += l;
        this.bufOffset = 0;
    }
}

