/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.queue.service;

import com.munjaon.server.cache.service.SerialNoService;
import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.queue.mapper.KftMapper;
import com.munjaon.server.queue.pool.KakaoAlarmMemoryQueue;
import com.munjaon.server.queue.pool.KakaoFriendQueuePool;
import com.munjaon.server.queue.pool.WriteQueue;
import com.munjaon.server.queue.service.QueueAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KakaoFriendQueueService
implements QueueAction {
    private static final Logger log = LoggerFactory.getLogger(KakaoFriendQueueService.class);
    private final KftMapper kftMapper;
    private final KakaoFriendQueuePool queueInstance = KakaoFriendQueuePool.getInstance();
    private final KakaoAlarmMemoryQueue memoryQueue = KakaoAlarmMemoryQueue.getInstance();
    private final SerialNoService serialNoService;

    public int getQueueSize() {
        return this.queueInstance.getQueueSize();
    }

    public boolean isExistQueue(String name) {
        return this.queueInstance.isExistQueue(name);
    }

    public void removeQueue(String name) {
        this.queueInstance.removeQueue(name);
    }

    public void addQueue(WriteQueue queue) {
        this.queueInstance.addQueue(queue);
    }

    public void pushQueue(BasicMessageDto data) {
        boolean isError = false;
        try {
            this.queueInstance.pushQueue(data);
        }
        catch (Exception e) {
            isError = true;
        }
        if (isError) {
            log.error("Push queue failed");
        }
    }

    public int saveMessageToTable(BasicMessageDto data) {
        String serialNo = this.serialNoService.getSerialNo();
        String groupSerialNo = serialNo.replace("MSGID", "MGRP");
        data.setId(serialNo);
        data.setMsgGroupID(groupSerialNo);
        log.debug("Save message to table : {}", (Object)data);
        return this.kftMapper.insert(data);
    }

    public void memoryEnQueue(BasicMessageDto data) {
        this.memoryQueue.memoryEnQueue(data);
    }

    public BasicMessageDto memoryDeQueue() {
        return this.memoryQueue.memoryDeQueue();
    }

    public int getMemorySize() {
        return this.memoryQueue.getMemorySize();
    }

    public boolean isMemoryEmpty() {
        return this.memoryQueue.isMemoryEmpty();
    }

    public KakaoFriendQueueService(KftMapper kftMapper, SerialNoService serialNoService) {
        this.kftMapper = kftMapper;
        this.serialNoService = serialNoService;
    }
}

