/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.cache.service;

import com.munjaon.server.cache.dto.MemberDto;
import com.munjaon.server.cache.mapper.MemberMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MemberService {
    private static final Logger log = LoggerFactory.getLogger(MemberService.class);
    private final MemberMapper memberMapper;

    public String getMemberLastModifiedTime(String tableSchema) {
        return this.memberMapper.getMemberLastModifiedTime(tableSchema);
    }

    public String getConfigLastModifiedTime(String tableSchema) {
        return this.memberMapper.getConfigLastModifiedTime(tableSchema);
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"cacheMember"})
    public List<MemberDto> list() {
        return this.memberMapper.list();
    }

    @Transactional(readOnly=true)
    @Cacheable(value={"cacheMember"}, key="#mberId")
    public MemberDto get(String mberId) {
        return this.memberMapper.get(mberId);
    }

    @CacheEvict(value={"cacheMember"}, allEntries=true)
    public void deleteAllMember() {
        log.info("Cache All Clear");
    }

    @CacheEvict(value={"cacheMember"}, key="#mberId")
    public void deleteOneMember(String mberId) {
        log.info("Cache Clear: {}", (Object)mberId);
    }

    @Transactional
    public int updateStts(MemberDto params) {
        return this.memberMapper.updateStts(params);
    }

    public int updateStts(String mberId, String mberSttus) {
        MemberDto params = new MemberDto();
        params.setMberId(mberId);
        params.setMberSttus(mberSttus);
        return this.memberMapper.updateStts(params);
    }

    public MemberService(MemberMapper memberMapper) {
        this.memberMapper = memberMapper;
    }
}

