/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.task;

import com.munjaon.server.cache.dto.MemberDto;
import com.munjaon.server.cache.enums.CacheService;
import com.munjaon.server.cache.service.MemberService;
import com.munjaon.server.queue.pool.ReportQueue;
import com.munjaon.server.server.dto.ReportUserDto;
import com.munjaon.server.server.packet.Bind;
import com.munjaon.server.server.packet.Header;
import com.munjaon.server.server.packet.Packet;
import com.munjaon.server.server.queue.ReportUserQueue;
import com.munjaon.server.util.LogUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Callable;

public class ReportReadTask
implements Callable<ReportUserDto> {
    public static final SimpleDateFormat sdf = new SimpleDateFormat("[MM-dd HH:mm:ss]");
    public static final String LOG_DATE_FORMAT = "[MM-dd HH:mm:ss]";
    private Selector selector;
    private SelectionKey key;
    private final ReportUserQueue reportUserQueue = ReportUserQueue.getInstance();
    private ReportUserDto reportUserDto;
    private final LogUtil logger;

    public ReportReadTask(Selector selector, SelectionKey key, LogUtil logger) {
        this.selector = selector;
        this.key = key;
        this.reportUserDto = (ReportUserDto)key.attachment();
        this.logger = logger;
    }

    @Override
    public ReportUserDto call() throws Exception {
        int size = -1;
        try {
            SocketChannel channel = (SocketChannel)this.key.channel();
            ByteBuffer headBuffer = ByteBuffer.allocate(10);
            try {
                size = channel.read(headBuffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (size > 0) {
                String command = Header.getCommand((ByteBuffer)headBuffer);
                switch (Integer.parseInt(command)) {
                    case 1: {
                        this.recvBind(channel, headBuffer);
                        break;
                    }
                    case 6: {
                        this.recvReport(channel, headBuffer);
                        break;
                    }
                    case 8: {
                        this.recvLinkCheck(channel, headBuffer);
                        break;
                    }
                    default: {
                        this.expireConnectUser();
                        break;
                    }
                }
            } else {
                this.expireConnectUser();
            }
        }
        catch (Exception e) {
            size = -1;
            e.printStackTrace();
        }
        if (size <= 0) {
            this.reportUserDto.setCommand(-1);
        }
        return this.reportUserDto;
    }

    private void recvLinkCheck(SocketChannel channel, ByteBuffer headBuffer) {
        try {
            ByteBuffer bodyBuffer = ByteBuffer.allocate(3);
            int size = channel.read(bodyBuffer);
            if (size > 0) {
                this.saveSystemLog((Object)"Recv link check");
                this.reportUserDto.updateLastTrafficTime();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recvReport(SocketChannel channel, ByteBuffer headBuffer) {
        try {
            ByteBuffer bodyBuffer = ByteBuffer.allocate(1);
            this.saveSystemLog((Object)"recv report");
            int size = channel.read(bodyBuffer);
            if (size > 0) {
                ReportQueue reportQueue = this.reportUserDto.getReportQueue();
                this.reportUserDto.updateLastTrafficTime();
                if (reportQueue != null) {
                    reportQueue.addReadCounter();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recvBind(SocketChannel channel, ByteBuffer headBuffer) {
        String resultCode = "00";
        try {
            ByteBuffer bindBuffer = ByteBuffer.allocate(51);
            ByteBuffer bodyBuffer = ByteBuffer.allocate(41);
            channel.read(bodyBuffer);
            Packet.mergeBuffers((ByteBuffer)bindBuffer, (ByteBuffer)headBuffer, (ByteBuffer)bodyBuffer);
            String id = Bind.getBindId((ByteBuffer)bindBuffer);
            String pwd = Bind.getBindPwd((ByteBuffer)bindBuffer);
            this.saveSystemLog((Object)("Bind id : " + id));
            this.saveSystemLog((Object)("Bind pwd : " + pwd));
            if (id == null || pwd == null) {
                resultCode = "50";
            } else if (this.reportUserQueue.isExist(id)) {
                resultCode = "60";
            } else {
                MemberService svc = (MemberService)CacheService.LOGIN_SERVICE.getService();
                MemberDto memberDto = null;
                if (svc != null) {
                    memberDto = svc.get(id);
                }
                if (memberDto == null || !pwd.equals(memberDto.getAccessKey())) {
                    resultCode = "20";
                } else {
                    this.reportUserDto.setUserId(id);
                    this.reportUserDto.setLogin(true);
                    this.reportUserDto.setMemberDto(memberDto);
                    ReportQueue reportQueue = new ReportQueue(this.reportUserDto.getQueuePath(), this.reportUserDto.getUserId());
                    this.reportUserDto.setReportQueue(reportQueue);
                    this.reportUserQueue.putUser(this.reportUserDto);
                    this.reportUserDto.updateLastTrafficTime();
                }
            }
        }
        catch (Exception e) {
            resultCode = "10";
            e.printStackTrace();
        }
        try {
            this.saveSystemLog((Object)("Bind ResultCode : " + resultCode));
            channel.write(Bind.makeBindAckBuffer((String)resultCode));
            if (!"00".equals(resultCode)) {
                this.expireConnectUser();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void expireConnectUser() {
        if (this.key == null || !this.key.isValid()) {
            return;
        }
        try {
            SocketChannel channel = (SocketChannel)this.key.channel();
            if (this.reportUserDto != null) {
                if (this.reportUserDto.getUserId() != null) {
                    this.reportUserQueue.removeUser(this.reportUserDto.getUserId());
                }
                this.key.attach(null);
            }
            channel.close();
            this.key.cancel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveSystemLog(Object obj) {
        this.saveLog(obj, true);
    }

    private void saveLog(Object obj) {
        this.saveLog(obj, false);
    }

    private void saveLog(Object obj, boolean isConsoleOutput) {
        if (isConsoleOutput) {
            System.out.println(LocalDateTime.now().format(DateTimeFormatter.ofPattern(LOG_DATE_FORMAT)) + " {{REPORT_READ_TASK}} " + obj);
        }
        if (this.logger == null) {
            return;
        }
        this.logger.log(obj);
    }
}

