/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.service;

import com.munjaon.server.server.dto.ConnectUserDto;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public abstract class Server {
    private InetSocketAddress listenAddress;
    private Selector selector;
    private Long lastTrafficCheckTime = System.currentTimeMillis();

    private Server(InetSocketAddress listenAddress) {
        this.listenAddress = listenAddress;
    }

    protected Server(String address, int port) throws IOException {
        this(new InetSocketAddress(address, port));
        this.selector = Selector.open();
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        serverChannel.configureBlocking(false);
        serverChannel.socket().bind(this.listenAddress);
        serverChannel.register(this.selector, 16);
    }

    protected Iterator<SelectionKey> selectInterest() throws IOException {
        if (this.selector.select(1000L) == 0) {
            return null;
        }
        return this.selector.selectedKeys().iterator();
    }

    protected void execInterest(Iterator<SelectionKey> keys) throws IOException {
        while (keys != null && keys.hasNext()) {
            SelectionKey key = keys.next();
            keys.remove();
            if (!key.isValid()) continue;
            if (key.isAcceptable()) {
                this.accept(this.selector, key);
                continue;
            }
            if (key.isReadable()) {
                this.receive(this.selector, key);
                continue;
            }
            if (!key.isWritable()) continue;
            this.send(this.selector, key);
        }
    }

    protected void accept(Selector selector, SelectionKey key) throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)key.channel();
        SocketChannel channel = serverChannel.accept();
        channel.configureBlocking(false);
        Socket socket = channel.socket();
        SocketAddress remoteAddr = socket.getRemoteSocketAddress();
        System.out.println("Connected to: " + remoteAddr);
        channel.register(selector, 1, ConnectUserDto.builder().lastTrafficTime(Long.valueOf(System.currentTimeMillis())).remoteIP(remoteAddr.toString()).build());
    }

    protected void checkInterest() throws IOException {
        if (this.lastTrafficCheckTime - System.currentTimeMillis() < 3000L) {
            return;
        }
        for (SelectionKey key : this.selector.keys()) {
            ConnectUserDto userDto;
            if (key.interestOps() != 1 || (userDto = (ConnectUserDto)key.attachment()) == null || userDto.isAlive() == 0) continue;
            System.out.println("userDto is disconnet");
            SocketChannel channel = (SocketChannel)key.channel();
            Socket socket = channel.socket();
            channel.close();
            socket.close();
            key.attach(null);
            key.cancel();
        }
        this.lastTrafficCheckTime = System.currentTimeMillis();
    }

    protected void releaseServer() throws IOException {
        this.selector.close();
    }

    protected abstract void receive(Selector var1, SelectionKey var2) throws IOException;

    protected abstract void send(Selector var1, SelectionKey var2) throws IOException;
}

