/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.packet;

import com.munjaon.server.server.packet.Header;
import com.munjaon.server.server.packet.Packet;
import com.munjaon.server.util.CommonUtil;
import java.nio.ByteBuffer;

public final class SmsMessage {
    public static final int DELIVER_SMS_BODY_LENGTH = 239;
    public static final int DELIVER_SMS_ACK_BODY_LENGTH = 21;
    public static final int DELIVER_MESSAGE_LENGTH = 160;
    public static final int DELIVER_MESSAGE_POSITION = 89;

    public static void putMessageForDeliver(ByteBuffer buffer, String message) {
        if (buffer == null || message == null) {
            return;
        }
        message = CommonUtil.cutString((String)message, (int)160);
        buffer.put(89, message.getBytes());
    }

    public static String getMessageForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(89);
        byte[] destArray = new byte[160];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static ByteBuffer makeDeliverAckBuffer(String msgId, String status) {
        ByteBuffer buffer = ByteBuffer.allocate(31);
        Packet.setDefaultByte((ByteBuffer)buffer);
        Header.putHeader((ByteBuffer)buffer, (String)"4", (int)21);
        buffer.put(10, msgId.getBytes());
        buffer.put(30, status.getBytes());
        return buffer;
    }
}

