/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.packet;

import com.munjaon.server.server.packet.Header;
import com.munjaon.server.server.packet.Packet;
import com.munjaon.server.util.CommonUtil;
import java.nio.ByteBuffer;

public final class KakaoMessage {
    public static final int LIMIT_FILE_CAPACITY = 51200;
    public static final int DELIVER_JSON_FILENAME_LENGTH = 40;
    public static final int DELIVER_JSON_FILENAME_POSITION = 0;
    public static final int DELIVER_JSON_FILESIZE_LENGTH = 8;
    public static final int DELIVER_JSON_FILESIZE_POSITION = 40;
    public static final int DELIVER_KAKAO_BODY_LENGTH = 2233;
    public static final int DELIVER_KAKAO_ACK_BODY_LENGTH = 21;
    public static final int DELIVER_SUBJECT_LENGTH = 40;
    public static final int DELIVER_SUBJECT_POSITION = 89;
    public static final int DELIVER_MESSAGE_LENGTH = 2000;
    public static final int DELIVER_MESSAGE_POSITION = 129;
    public static final int DELIVER_KAKAO_SENDER_KEY_LENGTH = 40;
    public static final int DELIVER_KAKAO_SENDER_KEY_POSITION = 2129;
    public static final int DELIVER_KAKAO_TEMPLATE_CODE_LENGTH = 64;
    public static final int DELIVER_KAKAO_TEMPLATE_CODE_POSITION = 2169;

    public static void putSubjectForDeliver(ByteBuffer buffer, String subject) {
        if (buffer == null || subject == null) {
            return;
        }
        subject = CommonUtil.cutString((String)subject, (int)40);
        buffer.put(89, subject.getBytes());
    }

    public static String getSubjectForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(89);
        byte[] destArray = new byte[40];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putMessageForDeliver(ByteBuffer buffer, String message) {
        if (buffer == null || message == null) {
            return;
        }
        message = CommonUtil.cutString((String)message, (int)2000);
        buffer.put(129, message.getBytes());
    }

    public static String getMessageForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(129);
        byte[] destArray = new byte[2000];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putKakaoSenderKeyForDeliver(ByteBuffer buffer, String kakaoSenderKey) {
        if (buffer == null || kakaoSenderKey == null) {
            return;
        }
        kakaoSenderKey = CommonUtil.cutString((String)kakaoSenderKey, (int)40);
        buffer.put(2129, kakaoSenderKey.getBytes());
    }

    public static String getKakaoSenderKeyForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(2129);
        byte[] destArray = new byte[40];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static void putKakaoTemplateCodeForDeliver(ByteBuffer buffer, String kakaoTemplateCode) {
        if (buffer == null || kakaoTemplateCode == null) {
            return;
        }
        kakaoTemplateCode = CommonUtil.cutString((String)kakaoTemplateCode, (int)64);
        buffer.put(2169, kakaoTemplateCode.getBytes());
    }

    public static String getKakaoTemplateCodeForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(2169);
        byte[] destArray = new byte[64];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static String getFileNameForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(0);
        byte[] destArray = new byte[40];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static String getFileSizeForDeliver(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(40);
        byte[] destArray = new byte[8];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static ByteBuffer makeDeliverAckBuffer(String msgId, String status) {
        ByteBuffer buffer = ByteBuffer.allocate(31);
        Packet.setDefaultByte((ByteBuffer)buffer);
        Header.putHeader((ByteBuffer)buffer, (String)"4", (int)21);
        buffer.put(10, msgId.getBytes());
        buffer.put(30, status.getBytes());
        return buffer;
    }
}

