/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.server.packet;

import com.munjaon.server.server.packet.Header;
import com.munjaon.server.server.packet.Packet;
import java.nio.ByteBuffer;

public final class Bind {
    public static final int BIND_BODY_LENGTH = 41;
    public static final int BIND_ID_LENGTH = 20;
    public static final int BIND_ID_POSITION = 10;
    public static final int BIND_PWD_LENGTH = 20;
    public static final int BIND_PWD_POSITION = 30;
    public static final int BIND_ENCRYPTION_LENGTH = 1;
    public static final int BIND_ENCRYPTION_POSITION = 50;
    public static final int BIND_ACK_BODY_LENGTH = 2;
    public static final int BIND_ACK_RESULT_CODE_LENGTH = 2;
    public static final int BIND_ACK_RESULT_CODE_POSITION = 10;
    public static final String ENCRYPTION = "0";

    public static ByteBuffer makeBindBuffer(String id, String pwd) {
        ByteBuffer buffer = ByteBuffer.allocate(51);
        Packet.setDefaultByte((ByteBuffer)buffer);
        Header.putHeader((ByteBuffer)buffer, (String)"1", (int)41);
        if (id != null) {
            buffer.put(10, id.getBytes());
        }
        if (pwd != null) {
            buffer.put(30, pwd.getBytes());
        }
        buffer.put(50, ENCRYPTION.getBytes());
        return buffer;
    }

    public static ByteBuffer makeBindAckBuffer(String resultCode) {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        Packet.setDefaultByte((ByteBuffer)buffer);
        Header.putHeader((ByteBuffer)buffer, (String)"2", (int)2);
        if (resultCode != null) {
            buffer.put(10, resultCode.getBytes());
        }
        return buffer;
    }

    public static String getBindId(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(10);
        byte[] destArray = new byte[20];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static String getBindPwd(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(30);
        byte[] destArray = new byte[20];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static String getBindEncryption(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(50);
        byte[] destArray = new byte[1];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }

    public static String getBindAckResultCode(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        buffer.position(10);
        byte[] destArray = new byte[2];
        buffer.get(destArray);
        return Packet.getString((byte[])destArray);
    }
}

