/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.scheduler.service;

import com.munjaon.server.cache.service.MemberService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CacheScheduleService {
    private static final Logger log = LoggerFactory.getLogger(CacheScheduleService.class);
    private final MemberService memberService;
    @Value(value="${agent.db-name}")
    private String tableSchema;
    private String member_last_modified_time = null;
    private String config_last_modified_time = null;

    public void doService() throws Exception {
        this.doMemberService();
    }

    private void doMemberService() {
        if (this.member_last_modified_time == null || this.config_last_modified_time == null) {
            log.info("Member List Info is First Caching~~~");
            this.memberService.deleteAllMember();
            this.member_last_modified_time = this.memberService.getMemberLastModifiedTime(this.tableSchema);
            this.config_last_modified_time = this.memberService.getConfigLastModifiedTime(this.tableSchema);
            return;
        }
        if (this.member_last_modified_time.equals(this.memberService.getMemberLastModifiedTime(this.tableSchema)) && this.config_last_modified_time.equals(this.memberService.getConfigLastModifiedTime(this.tableSchema))) {
            return;
        }
        log.info("Member List Info is Delete And Caching~~~");
        this.memberService.deleteAllMember();
        this.member_last_modified_time = this.memberService.getMemberLastModifiedTime(this.tableSchema);
        this.config_last_modified_time = this.memberService.getConfigLastModifiedTime(this.tableSchema);
    }

    public CacheScheduleService(MemberService memberService) {
        this.memberService = memberService;
    }
}

