/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.queue.pool;

import com.munjaon.server.config.ServiceCode;
import com.munjaon.server.queue.config.QueueConstants;
import com.munjaon.server.queue.dto.BasicMessageDto;
import com.munjaon.server.queue.dto.QueueInfo;
import com.munjaon.server.util.FileUtil;
import com.munjaon.server.util.JobFileFactory;
import com.munjaon.server.util.MessageUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public abstract class WriteQueue {
    protected ByteBuffer headerBuffer = null;
    protected byte[] headerArray = null;
    protected String createDate = "";
    protected int pushCounter = 0;
    protected String queuePath;
    protected FileChannel channel = null;
    protected QueueInfo queueInfo = null;
    protected ByteBuffer dataBuffer = null;

    protected void initQueuePath() {
        this.queuePath = System.getProperty("ROOTPATH") + File.separator + this.queueInfo.getQueuePath();
        FileUtil.mkdirs((String)this.queuePath);
    }

    public void initQueue() throws Exception {
        this.headerBuffer = ByteBuffer.allocateDirect(20);
        this.initQueuePath();
        this.queueInfo.setQueueFileName(this.queuePath + File.separator + this.queueInfo.getQueueName() + ".queue");
        File file = new File(this.queueInfo.getQueueFileName());
        this.channel = new RandomAccessFile(file, "rw").getChannel();
        if (file.length() == 0L) {
            this.createDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            this.pushCounter = 0;
            this.writeHeader();
        } else {
            this.readHeader();
        }
    }

    public void backupQueue() throws IOException {
        String backupDir = this.queuePath + File.separator + "backup" + File.separator + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JobFileFactory.transferFile((String)this.queuePath, (String)(this.queueInfo.getQueueName() + ".queue"), (String)backupDir, (String)(this.queueInfo.getQueueName() + ".queue"));
    }

    protected void readHeader() throws Exception {
        this.initHeaderBuffer();
        this.channel.position(0L);
        this.channel.read(this.headerBuffer);
        this.headerArray = new byte[10];
        this.headerBuffer.position(0);
        this.headerBuffer.get(this.headerArray);
        this.createDate = QueueConstants.getString((byte[])this.headerArray);
        this.headerArray = new byte[10];
        this.headerBuffer.position(10);
        this.headerBuffer.get(this.headerArray);
        this.pushCounter = Integer.parseInt(QueueConstants.getString((byte[])this.headerArray));
    }

    protected void writeHeader() throws Exception {
        this.initHeaderBuffer();
        this.channel.position(0L);
        this.headerBuffer.put(this.createDate.getBytes());
        this.headerBuffer.position(10);
        this.headerBuffer.put(Integer.toString(this.pushCounter).getBytes());
        this.headerBuffer.flip();
        this.channel.write(this.headerBuffer);
    }

    protected void initHeaderBuffer() {
        this.headerBuffer.clear();
        for (int loopCnt = 0; loopCnt < 20; ++loopCnt) {
            this.headerBuffer.put((byte)0);
        }
        this.headerBuffer.position(0);
    }

    public void close() throws IOException {
        if (this.isOpen()) {
            this.channel.close();
        }
    }

    protected boolean isOpen() {
        if (this.channel == null) {
            return false;
        }
        return this.channel.isOpen();
    }

    public void truncateQueue() throws Exception {
        String thisDate = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        if (this.createDate.equals(thisDate)) {
            return;
        }
        if (this.isOpen()) {
            this.readHeader();
            this.channel.truncate(0L);
            this.createDate = thisDate;
            this.pushCounter = 0;
            this.writeHeader();
        }
    }

    public String getQueueName() {
        if (this.queueInfo == null) {
            return null;
        }
        return this.queueInfo.getQueueName();
    }

    protected int isValidateMessage(BasicMessageDto messageDto) {
        int result = this.isValidateMessageForCommon(messageDto);
        if (result != ServiceCode.OK.getCode()) {
            return result;
        }
        return this.isValidateMessageForExtend(messageDto);
    }

    protected int isValidateMessageForCommon(BasicMessageDto messageDto) {
        if (MessageUtil.isEmptyForMessage((String)messageDto.getUserId(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getUserId(), (int)20, (boolean)true)) {
            return ServiceCode.MSG_ERROR_USERID.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getFeeType(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getFeeType(), (int)1, (boolean)true)) {
            return ServiceCode.MSG_ERROR_FEETYPE.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getUnitCost(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getUnitCost(), (int)10, (boolean)true)) {
            return ServiceCode.MSG_ERROR_UNITCOST.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getMsgGroupID(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getMsgGroupID(), (int)20, (boolean)true)) {
            return ServiceCode.MSG_ERROR_MSGGROUPID.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getUserMsgID(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getUserMsgID(), (int)20, (boolean)true)) {
            return ServiceCode.MSG_ERROR_USERMSGID.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getServiceType(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getServiceType(), (int)1, (boolean)true)) {
            return ServiceCode.MSG_ERROR_SERVICETYPE.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getSendStatus(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getSendStatus(), (int)5, (boolean)true)) {
            return ServiceCode.MSG_ERROR_SENDSTATUS.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getUserSender(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getUserSender(), (int)12, (boolean)true)) {
            return ServiceCode.MSG_ERROR_USERSENDER.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getUserReceiver(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getUserReceiver(), (int)12, (boolean)true)) {
            return ServiceCode.MSG_ERROR_USERRECEIVER.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getRequestDt(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getRequestDt(), (int)15, (boolean)true)) {
            return ServiceCode.MSG_ERROR_REQUESTDT.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getRemoteIP(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getRemoteIP(), (int)25, (boolean)true)) {
            return ServiceCode.MSG_ERROR_REMOTEIP.getCode();
        }
        if (MessageUtil.isEmptyForMessage((String)messageDto.getRouterSeq(), (boolean)true) || MessageUtil.isOverByteForMessage((String)messageDto.getRouterSeq(), (int)5, (boolean)true)) {
            return ServiceCode.MSG_ERROR_ROUTERSEQ.getCode();
        }
        return ServiceCode.OK.getCode();
    }

    public abstract int isValidateMessageForExtend(BasicMessageDto var1);

    public abstract void pushMessageToBuffer(BasicMessageDto var1) throws Exception;

    public abstract void initDataBuffer();

    public String getCreateDate() {
        return this.createDate;
    }

    public int getPushCounter() {
        return this.pushCounter;
    }

    public String getQueuePath() {
        return this.queuePath;
    }

    public QueueInfo getQueueInfo() {
        return this.queueInfo;
    }
}

