/*
 * Decompiled with CFR 0.152.
 */
package com.munjaon.server.util;

import com.munjaon.server.util.FileUtil;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogUtil {
    private static final String sTimeFormat = "[HH:mm:ss.SSS] ";
    private static final String sDateFormat = "_yyyyMMdd";
    private static final String sFileExt = ".log";
    private PrintWriter out;
    private String sLogFile;
    private String sDate;

    public LogUtil(String sLogFile) {
        this.sLogFile = sLogFile;
        if (sLogFile != null) {
            FileUtil.mkdirs((String)sLogFile, (boolean)true);
        }
    }

    private void open() {
        this.close();
        if (this.sLogFile != null) {
            try {
                this.out = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.sLogFile + this.sDate + sFileExt, true)), true);
            }
            catch (Exception e) {
                this.out = null;
            }
        }
        if (this.out == null) {
            this.out = new PrintWriter(System.out, true);
        }
    }

    public void close() {
        if (this.sLogFile != null && this.out != null) {
            try {
                this.out.close();
                this.out = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void log(String sFile, Object oLog) {
        LogUtil logger = new LogUtil(sFile);
        logger.log(oLog);
        logger.close();
    }

    public synchronized void log(Object oLog) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        Date date = new Date();
        sdf.applyPattern(sDateFormat);
        String sDates = sdf.format(date);
        sdf.applyPattern(sTimeFormat);
        String sTime = sdf.format(date);
        try {
            if (!sDates.equals(this.sDate)) {
                this.sDate = sDates;
                this.open();
            }
            if (oLog instanceof Exception) {
                this.out.print(sTime);
                ((Exception)oLog).printStackTrace(this.out);
                if (this.sLogFile == null) {
                    ((Exception)oLog).printStackTrace();
                }
            } else {
                this.out.println(sTime + oLog);
            }
            this.out.flush();
        }
        catch (Exception e) {
            this.close();
        }
    }
}

